/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.sqlclient;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A connection to the database server.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.SqlConnection original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.SqlConnection.class)
public class SqlConnection extends io.vertx.rxjava3.sqlclient.SqlClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SqlConnection that = (SqlConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SqlConnection> __TYPE_ARG = new TypeArg<>(    obj -> new SqlConnection((io.vertx.sqlclient.SqlConnection) obj),
    SqlConnection::getDelegate
  );

  private final io.vertx.sqlclient.SqlConnection delegate;
  
  public SqlConnection(io.vertx.sqlclient.SqlConnection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public SqlConnection(Object delegate) {
    super((io.vertx.sqlclient.SqlConnection)delegate);
    this.delegate = (io.vertx.sqlclient.SqlConnection)delegate;
  }

  public io.vertx.sqlclient.SqlConnection getDelegate() {
    return delegate;
  }

  /**
   * Create a prepared statement using the given <code>sql</code> string.
   * @param sql the sql
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.sqlclient.PreparedStatement> prepare(java.lang.String sql) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.sqlclient.PreparedStatement> ret = rxPrepare(sql);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Create a prepared statement using the given <code>sql</code> string.
   * @param sql the sql
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.sqlclient.PreparedStatement> rxPrepare(java.lang.String sql) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.prepare(sql, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)event))));
    });
  }

  /**
   * Create a prepared statement using the given <code>sql</code> string.
   * @param sql the sql
   * @param options 
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.sqlclient.PreparedStatement> prepare(java.lang.String sql, io.vertx.sqlclient.PrepareOptions options) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.sqlclient.PreparedStatement> ret = rxPrepare(sql, options);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Create a prepared statement using the given <code>sql</code> string.
   * @param sql the sql
   * @param options 
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.sqlclient.PreparedStatement> rxPrepare(java.lang.String sql, io.vertx.sqlclient.PrepareOptions options) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.prepare(sql, options, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)event))));
    });
  }

  /**
   * Set an handler called with connection errors.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.sqlclient.SqlConnection exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Set an handler called when the connection is closed.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.sqlclient.SqlConnection closeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Begin a transaction and returns a {@link io.vertx.rxjava3.sqlclient.Transaction} for controlling and tracking
   * this transaction.
   * <p/>
   * When the connection is explicitely closed, any inflight transaction is rollbacked.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.sqlclient.Transaction> begin() { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.sqlclient.Transaction> ret = rxBegin();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Begin a transaction and returns a {@link io.vertx.rxjava3.sqlclient.Transaction} for controlling and tracking
   * this transaction.
   * <p/>
   * When the connection is explicitely closed, any inflight transaction is rollbacked.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.sqlclient.Transaction> rxBegin() { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.begin(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.sqlclient.Transaction.newInstance((io.vertx.sqlclient.Transaction)event))));
    });
  }

  /**
   * @return the current transaction if it exists, otherwise null
   */
  public io.vertx.rxjava3.sqlclient.Transaction transaction() { 
    io.vertx.rxjava3.sqlclient.Transaction ret = io.vertx.rxjava3.sqlclient.Transaction.newInstance((io.vertx.sqlclient.Transaction)delegate.transaction());
    return ret;
  }

  /**
   * @return whether the connection uses SSL
   */
  public boolean isSSL() { 
    boolean ret = delegate.isSSL();
    return ret;
  }

  /**
   * Close the current connection after all the pending commands have been processed.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable close() { 
    io.reactivex.rxjava3.core.Completable ret = rxClose();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Close the current connection after all the pending commands have been processed.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.close(handler);
    });
  }

  /**
   * @return The static metadata about the backend database server for this connection
   */
  public io.vertx.rxjava3.sqlclient.spi.DatabaseMetadata databaseMetadata() { 
    io.vertx.rxjava3.sqlclient.spi.DatabaseMetadata ret = io.vertx.rxjava3.sqlclient.spi.DatabaseMetadata.newInstance((io.vertx.sqlclient.spi.DatabaseMetadata)delegate.databaseMetadata());
    return ret;
  }

  public static SqlConnection newInstance(io.vertx.sqlclient.SqlConnection arg) {
    return arg != null ? new SqlConnection(arg) : null;
  }

}
