/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.sqlclient;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A row oriented stream.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.RowStream original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.RowStream.class)
public class RowStream<T> implements io.vertx.rxjava3.core.streams.ReadStream<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RowStream that = (RowStream) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RowStream> __TYPE_ARG = new TypeArg<>(    obj -> new RowStream((io.vertx.sqlclient.RowStream) obj),
    RowStream::getDelegate
  );

  private final io.vertx.sqlclient.RowStream<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public RowStream(io.vertx.sqlclient.RowStream delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public RowStream(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.sqlclient.RowStream)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.sqlclient.RowStream getDelegate() {
    return delegate;
  }

  private io.reactivex.rxjava3.core.Observable<T> observable;
  private io.reactivex.rxjava3.core.Flowable<T> flowable;

  public synchronized io.reactivex.rxjava3.core.Observable<T> toObservable() {
    if (observable == null) {
      Function<T, T> conv = (Function<T, T>) __typeArg_0.wrap;
      observable = ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.rxjava3.core.Flowable<T> toFlowable() {
    if (flowable == null) {
      Function<T, T> conv = (Function<T, T>) __typeArg_0.wrap;
      flowable = FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }


  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava3.core.streams.Pipe<T> pipe() { 
    io.vertx.rxjava3.core.streams.Pipe<T> ret = io.vertx.rxjava3.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), __typeArg_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable pipeTo(io.vertx.rxjava3.core.streams.WriteStream<T> dst) { 
    io.reactivex.rxjava3.core.Completable ret = rxPipeTo(dst);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxPipeTo(io.vertx.rxjava3.core.streams.WriteStream<T> dst) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  public io.vertx.rxjava3.sqlclient.RowStream<T> exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava3.sqlclient.RowStream<T> handler(io.vertx.core.Handler<T> handler) { 
    delegate.handler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> (T)__typeArg_0.wrap(event)));
    return this;
  }

  public io.vertx.rxjava3.sqlclient.RowStream<T> pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.rxjava3.sqlclient.RowStream<T> resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.rxjava3.sqlclient.RowStream<T> endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.rxjava3.sqlclient.RowStream<T> fetch(long l) { 
    delegate.fetch(l);
    return this;
  }

  /**
   * Close the stream and release the resources.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable close() { 
    io.reactivex.rxjava3.core.Completable ret = rxClose();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Close the stream and release the resources.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.close(completionHandler);
    });
  }

  public static <T> RowStream<T> newInstance(io.vertx.sqlclient.RowStream arg) {
    return arg != null ? new RowStream<T>(arg) : null;
  }

  public static <T> RowStream<T> newInstance(io.vertx.sqlclient.RowStream arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new RowStream<T>(arg, __typeArg_T) : null;
  }

}
