/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.servicediscovery.types;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.types.MongoDataSource original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.servicediscovery.types.MongoDataSource.class)
public class MongoDataSource {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MongoDataSource that = (MongoDataSource) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MongoDataSource> __TYPE_ARG = new TypeArg<>(    obj -> new MongoDataSource((io.vertx.servicediscovery.types.MongoDataSource) obj),
    MongoDataSource::getDelegate
  );

  private final io.vertx.servicediscovery.types.MongoDataSource delegate;
  
  public MongoDataSource(io.vertx.servicediscovery.types.MongoDataSource delegate) {
    this.delegate = delegate;
  }

  public MongoDataSource(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.types.MongoDataSource)delegate;
  }

  public io.vertx.servicediscovery.types.MongoDataSource getDelegate() {
    return delegate;
  }

  /**
   * Convenient method to create a record for a Mongo data source.
   * @param name the service name
   * @param location the location of the service (e.g. url, port...)
   * @param metadata additional metadata
   * @return the created record
   */
  public static io.vertx.servicediscovery.Record createRecord(java.lang.String name, io.vertx.core.json.JsonObject location, io.vertx.core.json.JsonObject metadata) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.MongoDataSource.createRecord(name, location, metadata);
    return ret;
  }

  /**
   * Convenient method that looks for a Mongo datasource source and provides the configured {@link io.vertx.rxjava3.ext.mongo.MongoClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return 
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.mongo.MongoClient> getMongoClient(io.vertx.rxjava3.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.mongo.MongoClient> ret = rxGetMongoClient(discovery, filter);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Convenient method that looks for a Mongo datasource source and provides the configured {@link io.vertx.rxjava3.ext.mongo.MongoClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return 
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.mongo.MongoClient> rxGetMongoClient(io.vertx.rxjava3.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      io.vertx.servicediscovery.types.MongoDataSource.getMongoClient(discovery.getDelegate(), filter, new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.rxjava3.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)event))));
    });
  }

  /**
   * Convenient method that looks for a Mongo datasource source and provides the configured
   * {@link io.vertx.rxjava3.ext.mongo.MongoClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter
   * @return 
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.mongo.MongoClient> getMongoClient(io.vertx.rxjava3.servicediscovery.ServiceDiscovery discovery, java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.mongo.MongoClient> ret = rxGetMongoClient(discovery, filter);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Convenient method that looks for a Mongo datasource source and provides the configured
   * {@link io.vertx.rxjava3.ext.mongo.MongoClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter
   * @return 
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.mongo.MongoClient> rxGetMongoClient(io.vertx.rxjava3.servicediscovery.ServiceDiscovery discovery, java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      io.vertx.servicediscovery.types.MongoDataSource.getMongoClient(discovery.getDelegate(), filter, new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.rxjava3.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)event))));
    });
  }

  /**
   * Convenient method that looks for a Mongo datasource source and provides the configured {@link io.vertx.rxjava3.ext.mongo.MongoClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration the consumer configuration
   * @return 
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.mongo.MongoClient> getMongoClient(io.vertx.rxjava3.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter, io.vertx.core.json.JsonObject consumerConfiguration) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.mongo.MongoClient> ret = rxGetMongoClient(discovery, filter, consumerConfiguration);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Convenient method that looks for a Mongo datasource source and provides the configured {@link io.vertx.rxjava3.ext.mongo.MongoClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration the consumer configuration
   * @return 
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.mongo.MongoClient> rxGetMongoClient(io.vertx.rxjava3.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter, io.vertx.core.json.JsonObject consumerConfiguration) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      io.vertx.servicediscovery.types.MongoDataSource.getMongoClient(discovery.getDelegate(), filter, consumerConfiguration, new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.rxjava3.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)event))));
    });
  }

  /**
   * Unknown type.
   */
  public static final java.lang.String UNKNOWN = io.vertx.servicediscovery.types.MongoDataSource.UNKNOWN;
  public static final java.lang.String TYPE = io.vertx.servicediscovery.types.MongoDataSource.TYPE;
  public static MongoDataSource newInstance(io.vertx.servicediscovery.types.MongoDataSource arg) {
    return arg != null ? new MongoDataSource(arg) : null;
  }

}
