/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.pgclient;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A  of {@link io.vertx.rxjava3.pgclient.PgConnection PostgreSQL connections}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.pgclient.PgPool original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.pgclient.PgPool.class)
public class PgPool extends io.vertx.rxjava3.sqlclient.Pool {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PgPool that = (PgPool) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<PgPool> __TYPE_ARG = new TypeArg<>(    obj -> new PgPool((io.vertx.pgclient.PgPool) obj),
    PgPool::getDelegate
  );

  private final io.vertx.pgclient.PgPool delegate;
  
  public PgPool(io.vertx.pgclient.PgPool delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public PgPool(Object delegate) {
    super((io.vertx.pgclient.PgPool)delegate);
    this.delegate = (io.vertx.pgclient.PgPool)delegate;
  }

  public io.vertx.pgclient.PgPool getDelegate() {
    return delegate;
  }

  /**
   * Like {@link io.vertx.rxjava3.pgclient.PgPool#pool} with a default <code>poolOptions</code>.
   * @return 
   */
  public static io.vertx.rxjava3.pgclient.PgPool pool() { 
    io.vertx.rxjava3.pgclient.PgPool ret = io.vertx.rxjava3.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.pgclient.PgPool#pool} with <code>connectOptions</code> build from the environment variables.
   * @param options 
   * @return 
   */
  public static io.vertx.rxjava3.pgclient.PgPool pool(io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.rxjava3.pgclient.PgPool ret = io.vertx.rxjava3.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(options));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.pgclient.PgPool#pool} with a default <code>poolOptions</code>.
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.rxjava3.pgclient.PgPool pool(java.lang.String connectionUri) { 
    io.vertx.rxjava3.pgclient.PgPool ret = io.vertx.rxjava3.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(connectionUri));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.pgclient.PgPool#pool} with <code>connectOptions</code> build from <code>connectionUri</code>.
   * @param connectionUri 
   * @param options 
   * @return 
   */
  public static io.vertx.rxjava3.pgclient.PgPool pool(java.lang.String connectionUri, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.rxjava3.pgclient.PgPool ret = io.vertx.rxjava3.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(connectionUri, options));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.pgclient.PgPool#pool} with default options.
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.rxjava3.pgclient.PgPool pool(io.vertx.rxjava3.core.Vertx vertx, java.lang.String connectionUri) { 
    io.vertx.rxjava3.pgclient.PgPool ret = io.vertx.rxjava3.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(vertx.getDelegate(), connectionUri));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.pgclient.PgPool#pool} with the <code>database</code> retrieved from the environment variables.
   * @param vertx 
   * @param options 
   * @return 
   */
  public static io.vertx.rxjava3.pgclient.PgPool pool(io.vertx.rxjava3.core.Vertx vertx, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.rxjava3.pgclient.PgPool ret = io.vertx.rxjava3.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.pgclient.PgPool#pool} with <code>database</code> retrieved from the given <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.rxjava3.pgclient.PgPool pool(io.vertx.rxjava3.core.Vertx vertx, java.lang.String connectionUri, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.rxjava3.pgclient.PgPool ret = io.vertx.rxjava3.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(vertx.getDelegate(), connectionUri, poolOptions));
    return ret;
  }

  /**
   * Create a connection pool to the PostgreSQL <code>database</code> configured with the given <code>options</code>.
   * @param database the database
   * @param options the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.rxjava3.pgclient.PgPool pool(io.vertx.pgclient.PgConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.rxjava3.pgclient.PgPool ret = io.vertx.rxjava3.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(database, options));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.pgclient.PgPool#pool} with a specific  instance.
   * @param vertx 
   * @param database 
   * @param options 
   * @return 
   */
  public static io.vertx.rxjava3.pgclient.PgPool pool(io.vertx.rxjava3.core.Vertx vertx, io.vertx.pgclient.PgConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.rxjava3.pgclient.PgPool ret = io.vertx.rxjava3.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(vertx.getDelegate(), database, options));
    return ret;
  }

  /**
   * Create a connection pool to the PostgreSQL <code>databases</code> with round-robin selection.
   * Round-robin is applied when a new connection is created by the pool.
   * @param databases the list of databases
   * @param poolOptions the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.rxjava3.pgclient.PgPool pool(java.util.List<io.vertx.pgclient.PgConnectOptions> databases, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.rxjava3.pgclient.PgPool ret = io.vertx.rxjava3.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(databases, poolOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.pgclient.PgPool#pool} with a specific  instance.
   * @param vertx 
   * @param databases 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.rxjava3.pgclient.PgPool pool(io.vertx.rxjava3.core.Vertx vertx, java.util.List<io.vertx.pgclient.PgConnectOptions> databases, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.rxjava3.pgclient.PgPool ret = io.vertx.rxjava3.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(vertx.getDelegate(), databases, poolOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.pgclient.PgPool#client} with default options.
   * @return 
   */
  public static io.vertx.rxjava3.sqlclient.SqlClient client() { 
    io.vertx.rxjava3.sqlclient.SqlClient ret = io.vertx.rxjava3.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.pgclient.PgPool#client} with <code>database</code> retrieved from the environment variables.
   * @param options 
   * @return 
   */
  public static io.vertx.rxjava3.sqlclient.SqlClient client(io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.rxjava3.sqlclient.SqlClient ret = io.vertx.rxjava3.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(options));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.pgclient.PgPool#pool} with default options.
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.rxjava3.sqlclient.SqlClient client(java.lang.String connectionUri) { 
    io.vertx.rxjava3.sqlclient.SqlClient ret = io.vertx.rxjava3.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(connectionUri));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.pgclient.PgPool#client} with <code>database</code> retrieved from the <code>connectionUri</code>.
   * @param connectionUri 
   * @param options 
   * @return 
   */
  public static io.vertx.rxjava3.sqlclient.SqlClient client(java.lang.String connectionUri, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.rxjava3.sqlclient.SqlClient ret = io.vertx.rxjava3.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(connectionUri, options));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.pgclient.PgPool#client} with default options.
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.rxjava3.sqlclient.SqlClient client(io.vertx.rxjava3.core.Vertx vertx, java.lang.String connectionUri) { 
    io.vertx.rxjava3.sqlclient.SqlClient ret = io.vertx.rxjava3.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(vertx.getDelegate(), connectionUri));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.pgclient.PgPool#client} with <code>database</code> retrieved from the environment variables.
   * @param vertx 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.rxjava3.sqlclient.SqlClient client(io.vertx.rxjava3.core.Vertx vertx, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.rxjava3.sqlclient.SqlClient ret = io.vertx.rxjava3.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(vertx.getDelegate(), poolOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.pgclient.PgPool#client} with <code>database</code> build from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @param options 
   * @return 
   */
  public static io.vertx.rxjava3.sqlclient.SqlClient client(io.vertx.rxjava3.core.Vertx vertx, java.lang.String connectionUri, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.rxjava3.sqlclient.SqlClient ret = io.vertx.rxjava3.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(vertx.getDelegate(), connectionUri, options));
    return ret;
  }

  /**
   * Create a client backed by a connection pool to the PostgreSQL <code>database</code> configured with the given <code>options</code>.
   * @param database 
   * @param options the options for creating the backing pool
   * @return the pooled client
   */
  public static io.vertx.rxjava3.sqlclient.SqlClient client(io.vertx.pgclient.PgConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.rxjava3.sqlclient.SqlClient ret = io.vertx.rxjava3.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(database, options));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.pgclient.PgPool#client} with a specific  instance.
   * @param vertx 
   * @param database 
   * @param options 
   * @return 
   */
  public static io.vertx.rxjava3.sqlclient.SqlClient client(io.vertx.rxjava3.core.Vertx vertx, io.vertx.pgclient.PgConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.rxjava3.sqlclient.SqlClient ret = io.vertx.rxjava3.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(vertx.getDelegate(), database, options));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.pgclient.PgPool#client} with a specific  instance.
   * @param vertx 
   * @param databases 
   * @param options 
   * @return 
   */
  public static io.vertx.rxjava3.sqlclient.SqlClient client(io.vertx.rxjava3.core.Vertx vertx, java.util.List<io.vertx.pgclient.PgConnectOptions> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.rxjava3.sqlclient.SqlClient ret = io.vertx.rxjava3.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(vertx.getDelegate(), databases, options));
    return ret;
  }

  /**
   * Create a client backed by a connection pool to the PostgreSQL <code>databases</code> with round-robin selection.
   * Round-robin is applied when a new connection is created by the pool.
   * @param databases the list of databases
   * @param options the options for creating the pool
   * @return the pooled client
   */
  public static io.vertx.rxjava3.sqlclient.SqlClient client(java.util.List<io.vertx.pgclient.PgConnectOptions> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.rxjava3.sqlclient.SqlClient ret = io.vertx.rxjava3.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(databases, options));
    return ret;
  }

  public io.vertx.rxjava3.pgclient.PgPool connectHandler(io.vertx.core.Handler<io.vertx.rxjava3.sqlclient.SqlConnection> handler) { 
    delegate.connectHandler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.rxjava3.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)event)));
    return this;
  }

  public io.vertx.rxjava3.pgclient.PgPool connectionProvider(java.util.function.Function<io.vertx.rxjava3.core.Context,io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.sqlclient.SqlConnection>> provider) { 
    delegate.connectionProvider(new Function<io.vertx.core.Context,io.vertx.core.Future<io.vertx.sqlclient.SqlConnection>>() {
      public io.vertx.core.Future<io.vertx.sqlclient.SqlConnection> apply(io.vertx.core.Context arg) {
        io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.sqlclient.SqlConnection> ret = provider.apply(io.vertx.rxjava3.core.Context.newInstance((io.vertx.core.Context)arg));
        return io.vertx.rxjava3.SingleHelper.toFuture(ret, obj -> obj.getDelegate());
      }
    });
    return this;
  }

  /**
   * Create a connection pool to the PostgreSQL <code>databases</code>. The supplier is called
   * to provide the options when a new connection is created by the pool.
   * @param databases the databases supplier
   * @param poolOptions the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.rxjava3.pgclient.PgPool pool(java.util.function.Supplier<io.vertx.core.Future<io.vertx.pgclient.PgConnectOptions>> databases, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.rxjava3.pgclient.PgPool ret = io.vertx.rxjava3.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(databases, poolOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.pgclient.PgPool#pool} with a specific  instance.
   * @param vertx 
   * @param databases 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.rxjava3.pgclient.PgPool pool(io.vertx.rxjava3.core.Vertx vertx, java.util.function.Supplier<io.vertx.core.Future<io.vertx.pgclient.PgConnectOptions>> databases, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.rxjava3.pgclient.PgPool ret = io.vertx.rxjava3.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(vertx.getDelegate(), databases, poolOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.pgclient.PgPool#client} with a specific  instance.
   * @param vertx 
   * @param databases 
   * @param options 
   * @return 
   */
  public static io.vertx.rxjava3.sqlclient.SqlClient client(io.vertx.rxjava3.core.Vertx vertx, java.util.function.Supplier<io.vertx.core.Future<io.vertx.pgclient.PgConnectOptions>> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.rxjava3.sqlclient.SqlClient ret = io.vertx.rxjava3.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(vertx.getDelegate(), databases, options));
    return ret;
  }

  /**
   * Create a client backed by a connection pool to the PostgreSQL <code>databases</code>. The supplier is called
   * to provide the options when a new connection is created by the pool.
   * @param databases the databases supplier
   * @param options the options for creating the pool
   * @return the pooled client
   */
  public static io.vertx.rxjava3.sqlclient.SqlClient client(java.util.function.Supplier<io.vertx.core.Future<io.vertx.pgclient.PgConnectOptions>> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.rxjava3.sqlclient.SqlClient ret = io.vertx.rxjava3.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(databases, options));
    return ret;
  }

  public static PgPool newInstance(io.vertx.pgclient.PgPool arg) {
    return arg != null ? new PgPool(arg) : null;
  }

}
