/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.kafka.client.producer;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Vert.x Kafka producer record.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.client.producer.KafkaProducerRecord original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.kafka.client.producer.KafkaProducerRecord.class)
public class KafkaProducerRecord<K,V> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaProducerRecord that = (KafkaProducerRecord) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<KafkaProducerRecord> __TYPE_ARG = new TypeArg<>(    obj -> new KafkaProducerRecord((io.vertx.kafka.client.producer.KafkaProducerRecord) obj),
    KafkaProducerRecord::getDelegate
  );

  private final io.vertx.kafka.client.producer.KafkaProducerRecord<K,V> delegate;
  public final TypeArg<K> __typeArg_0;
  public final TypeArg<V> __typeArg_1;
  
  public KafkaProducerRecord(io.vertx.kafka.client.producer.KafkaProducerRecord delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();    this.__typeArg_1 = TypeArg.unknown();  }

  public KafkaProducerRecord(Object delegate, TypeArg<K> typeArg_0, TypeArg<V> typeArg_1) {
    this.delegate = (io.vertx.kafka.client.producer.KafkaProducerRecord)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  public io.vertx.kafka.client.producer.KafkaProducerRecord getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava3.kafka.client.producer.KafkaHeader> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.kafka.client.producer.KafkaHeader>(o1 -> io.vertx.rxjava3.kafka.client.producer.KafkaHeader.newInstance((io.vertx.kafka.client.producer.KafkaHeader)o1), o1 -> o1.getDelegate());

  /**
   * Create a concrete instance of a Vert.x producer record
   * @param topic the topic this record is being sent to
   * @param key the key (or null if no key is specified)
   * @param value the value
   * @param timestamp the timestamp of this record
   * @param partition the partition to which the record will be sent (or null if no partition was specified)
   * @return Vert.x producer record
   */
  public static <K, V> io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V> create(java.lang.String topic, K key, V value, java.lang.Long timestamp, java.lang.Integer partition) { 
    io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V> ret = io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord.newInstance((io.vertx.kafka.client.producer.KafkaProducerRecord)io.vertx.kafka.client.producer.KafkaProducerRecord.create(topic, key, value, timestamp, partition), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * Create a concrete instance of a Vert.x producer record
   * @param topic the topic this record is being sent to
   * @param key the key (or null if no key is specified)
   * @param value the value
   * @return Vert.x producer record
   */
  public static <K, V> io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V> create(java.lang.String topic, K key, V value) { 
    io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V> ret = io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord.newInstance((io.vertx.kafka.client.producer.KafkaProducerRecord)io.vertx.kafka.client.producer.KafkaProducerRecord.create(topic, key, value), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * Create a concrete instance of a Vert.x producer record
   * @param topic the topic this record is being sent to
   * @param value the value
   * @return Vert.x producer record
   */
  public static <K, V> io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V> create(java.lang.String topic, V value) { 
    io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V> ret = io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord.newInstance((io.vertx.kafka.client.producer.KafkaProducerRecord)io.vertx.kafka.client.producer.KafkaProducerRecord.create(topic, value), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * @return the topic this record is being sent to
   */
  public java.lang.String topic() { 
    java.lang.String ret = delegate.topic();
    return ret;
  }

  /**
   * @return the key (or null if no key is specified)
   */
  public K key() { 
    K ret = (K)__typeArg_0.wrap(delegate.key());
    return ret;
  }

  /**
   * @return the value
   */
  public V value() { 
    V ret = (V)__typeArg_1.wrap(delegate.value());
    return ret;
  }

  /**
   * @return the timestamp of this record
   */
  public java.lang.Long timestamp() { 
    java.lang.Long ret = delegate.timestamp();
    return ret;
  }

  /**
   * @return the partition to which the record will be sent (or null if no partition was specified)
   */
  public java.lang.Integer partition() { 
    java.lang.Integer ret = delegate.partition();
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord#addHeader} but with a key/value pair
   * @param key 
   * @param value 
   * @return 
   */
  public io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V> addHeader(java.lang.String key, java.lang.String value) { 
    delegate.addHeader(key, value);
    return this;
  }

  /**
   * Like {@link io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord#addHeader} but with a key/value pair
   * @param key 
   * @param value 
   * @return 
   */
  public io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V> addHeader(java.lang.String key, io.vertx.rxjava3.core.buffer.Buffer value) { 
    delegate.addHeader(key, value.getDelegate());
    return this;
  }

  /**
   * Add an header to this record.
   * @param header the header
   * @return current KafkaProducerRecord instance
   */
  public io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V> addHeader(io.vertx.rxjava3.kafka.client.producer.KafkaHeader header) { 
    delegate.addHeader(header.getDelegate());
    return this;
  }

  /**
   * Add a list of headers to this record.
   * @param headers the headers
   * @return current KafkaProducerRecord instance
   */
  public io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V> addHeaders(java.util.List<io.vertx.rxjava3.kafka.client.producer.KafkaHeader> headers) { 
    delegate.addHeaders(headers.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()));
    return this;
  }

  /**
   * @return the headers of this record
   */
  public java.util.List<io.vertx.rxjava3.kafka.client.producer.KafkaHeader> headers() { 
    if (cached_0 != null) {
      return cached_0;
    }
    java.util.List<io.vertx.rxjava3.kafka.client.producer.KafkaHeader> ret = delegate.headers().stream().map(elt -> io.vertx.rxjava3.kafka.client.producer.KafkaHeader.newInstance((io.vertx.kafka.client.producer.KafkaHeader)elt)).collect(Collectors.toList());
    cached_0 = ret;
    return ret;
  }

  private java.util.List<io.vertx.rxjava3.kafka.client.producer.KafkaHeader> cached_0;
  public static <K,V> KafkaProducerRecord<K,V> newInstance(io.vertx.kafka.client.producer.KafkaProducerRecord arg) {
    return arg != null ? new KafkaProducerRecord<K,V>(arg) : null;
  }

  public static <K,V> KafkaProducerRecord<K,V> newInstance(io.vertx.kafka.client.producer.KafkaProducerRecord arg, TypeArg<K> __typeArg_K, TypeArg<V> __typeArg_V) {
    return arg != null ? new KafkaProducerRecord<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }

}
