/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.httpproxy;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Handles the HTTP proxy body.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.httpproxy.Body original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.httpproxy.Body.class)
public class Body {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Body that = (Body) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Body> __TYPE_ARG = new TypeArg<>(    obj -> new Body((io.vertx.httpproxy.Body) obj),
    Body::getDelegate
  );

  private final io.vertx.httpproxy.Body delegate;
  
  public Body(io.vertx.httpproxy.Body delegate) {
    this.delegate = delegate;
  }

  public Body(Object delegate) {
    this.delegate = (io.vertx.httpproxy.Body)delegate;
  }

  public io.vertx.httpproxy.Body getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava3.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.core.buffer.Buffer>(o1 -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());

  /**
   * Create a new <code>Body</code> instance.
   * @param stream the <code>ReadStream</code> of the body
   * @param len the determined length of the body
   * @return a reference to this, so the API can be used fluently
   */
  public static io.vertx.rxjava3.httpproxy.Body body(io.reactivex.rxjava3.core.Flowable<io.vertx.rxjava3.core.buffer.Buffer> stream, long len) { 
    io.vertx.rxjava3.httpproxy.Body ret = io.vertx.rxjava3.httpproxy.Body.newInstance((io.vertx.httpproxy.Body)io.vertx.httpproxy.Body.body(io.vertx.rxjava3.impl.ReadStreamSubscriber.asReadStream(stream, obj -> obj.getDelegate()).resume(), len));
    return ret;
  }

  /**
   * Create a new <code>Body</code> instance.
   * @param stream the  of the body
   * @return a reference to this, so the API can be used fluently
   */
  public static io.vertx.rxjava3.httpproxy.Body body(io.reactivex.rxjava3.core.Flowable<io.vertx.rxjava3.core.buffer.Buffer> stream) { 
    io.vertx.rxjava3.httpproxy.Body ret = io.vertx.rxjava3.httpproxy.Body.newInstance((io.vertx.httpproxy.Body)io.vertx.httpproxy.Body.body(io.vertx.rxjava3.impl.ReadStreamSubscriber.asReadStream(stream, obj -> obj.getDelegate()).resume()));
    return ret;
  }

  /**
   * Create a new <code>Body</code> instance.
   * @param buffer the  of the body
   * @return a reference to this, so the API can be used fluently
   */
  public static io.vertx.rxjava3.httpproxy.Body body(io.vertx.rxjava3.core.buffer.Buffer buffer) { 
    io.vertx.rxjava3.httpproxy.Body ret = io.vertx.rxjava3.httpproxy.Body.newInstance((io.vertx.httpproxy.Body)io.vertx.httpproxy.Body.body(buffer.getDelegate()));
    return ret;
  }

  /**
   *
   * Get length of the <code>Body</code>.
   * @return the body length or <code>-1</code> if that can't be determined
   */
  public long length() { 
    long ret = delegate.length();
    return ret;
  }

  /**
   *
   * Get stream of the <code>Body</code>.
   * @return the body stream
   */
  public io.vertx.rxjava3.core.streams.ReadStream<io.vertx.rxjava3.core.buffer.Buffer> stream() { 
    io.vertx.rxjava3.core.streams.ReadStream<io.vertx.rxjava3.core.buffer.Buffer> ret = io.vertx.rxjava3.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.stream(), TYPE_ARG_0);
    return ret;
  }

  public static Body newInstance(io.vertx.httpproxy.Body arg) {
    return arg != null ? new Body(arg) : null;
  }

}
