/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.grpc.client;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A gRPC client for Vert.x
 *
 * Unlike traditional gRPC clients, this client does not rely on a generated RPC interface to interact with the service.
 *
 * Instead, you can interact with the service with a request/response interfaces and gRPC messages, very much like
 * a traditional client.
 *
 * The client exposes 2 levels of API
 *
 * <ul>
 *   <li>a Protobuf message {@link io.vertx.rxjava3.grpc.client.GrpcClient #request(SocketAddress) API}: {@link io.vertx.rxjava3.grpc.client.GrpcClientRequest}/{@link io.vertx.rxjava3.grpc.client.GrpcClientResponse} with Protobuf messages to call any gRPC service in a generic way</li>
 *   <li>a gRPC message {@link io.vertx.rxjava3.grpc.client.GrpcClient#request}: {@link io.vertx.rxjava3.grpc.client.GrpcClientRequest}/{@link io.vertx.rxjava3.grpc.client.GrpcClientRequest} with gRPC messages to call a given method of a gRPC service</li>
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.grpc.client.GrpcClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.grpc.client.GrpcClient.class)
public class GrpcClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GrpcClient that = (GrpcClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GrpcClient> __TYPE_ARG = new TypeArg<>(    obj -> new GrpcClient((io.vertx.grpc.client.GrpcClient) obj),
    GrpcClient::getDelegate
  );

  private final io.vertx.grpc.client.GrpcClient delegate;
  
  public GrpcClient(io.vertx.grpc.client.GrpcClient delegate) {
    this.delegate = delegate;
  }

  public GrpcClient(Object delegate) {
    this.delegate = (io.vertx.grpc.client.GrpcClient)delegate;
  }

  public io.vertx.grpc.client.GrpcClient getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava3.grpc.client.GrpcClientRequest<io.vertx.rxjava3.core.buffer.Buffer,io.vertx.rxjava3.core.buffer.Buffer>> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.grpc.client.GrpcClientRequest<io.vertx.rxjava3.core.buffer.Buffer,io.vertx.rxjava3.core.buffer.Buffer>>(o1 -> io.vertx.rxjava3.grpc.client.GrpcClientRequest.newInstance((io.vertx.grpc.client.GrpcClientRequest)o1, new TypeArg<io.vertx.rxjava3.core.buffer.Buffer>(o2 -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o2), o2 -> o2.getDelegate()), new TypeArg<io.vertx.rxjava3.core.buffer.Buffer>(o2 -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());

  /**
   * Create a new client
   * @param vertx the vertx instance
   * @return the created client
   */
  public static io.vertx.rxjava3.grpc.client.GrpcClient client(io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.grpc.client.GrpcClient ret = io.vertx.rxjava3.grpc.client.GrpcClient.newInstance((io.vertx.grpc.client.GrpcClient)io.vertx.grpc.client.GrpcClient.client(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a new client
   * @param vertx the vertx instance
   * @param options the client options
   * @return the created client
   */
  public static io.vertx.rxjava3.grpc.client.GrpcClient client(io.vertx.rxjava3.core.Vertx vertx, io.vertx.core.http.HttpClientOptions options) { 
    io.vertx.rxjava3.grpc.client.GrpcClient ret = io.vertx.rxjava3.grpc.client.GrpcClient.newInstance((io.vertx.grpc.client.GrpcClient)io.vertx.grpc.client.GrpcClient.client(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Connect to the remote <code>server</code> and create a request for any hosted gRPC service.
   * @param server the server hosting the service
   * @return a future request
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.grpc.client.GrpcClientRequest<io.vertx.rxjava3.core.buffer.Buffer,io.vertx.rxjava3.core.buffer.Buffer>> request(io.vertx.rxjava3.core.net.SocketAddress server) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.grpc.client.GrpcClientRequest<io.vertx.rxjava3.core.buffer.Buffer,io.vertx.rxjava3.core.buffer.Buffer>> ret = rxRequest(server);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Connect to the remote <code>server</code> and create a request for any hosted gRPC service.
   * @param server the server hosting the service
   * @return a future request
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.grpc.client.GrpcClientRequest<io.vertx.rxjava3.core.buffer.Buffer,io.vertx.rxjava3.core.buffer.Buffer>> rxRequest(io.vertx.rxjava3.core.net.SocketAddress server) { 
    return AsyncResultSingle.toSingle(delegate.request(server.getDelegate()), __value -> io.vertx.rxjava3.grpc.client.GrpcClientRequest.newInstance((io.vertx.grpc.client.GrpcClientRequest)__value, new TypeArg<io.vertx.rxjava3.core.buffer.Buffer>(o0 -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o0), o0 -> o0.getDelegate()), new TypeArg<io.vertx.rxjava3.core.buffer.Buffer>(o0 -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o0), o0 -> o0.getDelegate())));
  }

  /**
   * Close this client.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable close() { 
    io.reactivex.rxjava3.core.Completable ret = rxClose();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Close this client.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable(delegate.close());
  }

  /**
   * Connect to the remote <code>server</code> and create a request for given <code>method</code> of a hosted gRPC service.
   * @param server the server hosting the service
   * @param service the service to be called
   * @return a future request
   */
  public <Req, Resp> io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.grpc.client.GrpcClientRequest<Req,Resp>> request(io.vertx.rxjava3.core.net.SocketAddress server, io.grpc.MethodDescriptor<Req,Resp> service) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.grpc.client.GrpcClientRequest<Req,Resp>> ret = rxRequest(server, service);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Connect to the remote <code>server</code> and create a request for given <code>method</code> of a hosted gRPC service.
   * @param server the server hosting the service
   * @param service the service to be called
   * @return a future request
   */
  public <Req, Resp> io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.grpc.client.GrpcClientRequest<Req,Resp>> rxRequest(io.vertx.rxjava3.core.net.SocketAddress server, io.grpc.MethodDescriptor<Req,Resp> service) { 
    return AsyncResultSingle.toSingle(delegate.request(server.getDelegate(), service), __value -> io.vertx.rxjava3.grpc.client.GrpcClientRequest.newInstance((io.vertx.grpc.client.GrpcClientRequest)__value, TypeArg.unknown(), TypeArg.unknown()));
  }

  /**
   * Call the <code>service</code> gRPC service hosted by <code>server</code>.
   * <p>
   *   The <code>requestHandler</code> is called to send the request, e.g. <code>req -> req.send(item)</code>
   * <p>
   *   The <code>responseFunction</code> extracts the result, e.g. <code>resp -> resp.last()</code>
   * <p>
   *   It can be used in various ways:
   * <ul>
   *   <li><code>Future<Resp> fut = client.call(..., req -> req.send(item), resp -> resp.last());</code></li>
   *   <li><code>Future<Void> fut = client.call(..., req -> req.send(stream), resp -> resp.pipeTo(anotherService));</code></li>
   *   <li><code>Future<List<Resp>> fut = client.call(..., req -> req.send(stream), resp -> resp.collecting(Collectors.toList()));</code></li>
   * </ul>
   * <pre>
   * @param server the server hosting the service
   * @param service the service to call
   * @param requestHandler the handler called to send the request
   * @param resultFn the function applied to extract the result.
   * @return a future of the result
   */
  public <Req, Resp, T> io.reactivex.rxjava3.core.Single<T> call(io.vertx.rxjava3.core.net.SocketAddress server, io.grpc.MethodDescriptor<Req,Resp> service, io.vertx.core.Handler<io.vertx.rxjava3.grpc.client.GrpcClientRequest<Req,Resp>> requestHandler, java.util.function.Function<io.vertx.rxjava3.grpc.client.GrpcClientResponse<Req,Resp>,io.reactivex.rxjava3.core.Single<T>> resultFn) { 
    io.reactivex.rxjava3.core.Single<T> ret = rxCall(server, service, requestHandler, resultFn);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Call the <code>service</code> gRPC service hosted by <code>server</code>.
   * <p>
   *   The <code>requestHandler</code> is called to send the request, e.g. <code>req -> req.send(item)</code>
   * <p>
   *   The <code>responseFunction</code> extracts the result, e.g. <code>resp -> resp.last()</code>
   * <p>
   *   It can be used in various ways:
   * <ul>
   *   <li><code>Future<Resp> fut = client.call(..., req -> req.send(item), resp -> resp.last());</code></li>
   *   <li><code>Future<Void> fut = client.call(..., req -> req.send(stream), resp -> resp.pipeTo(anotherService));</code></li>
   *   <li><code>Future<List<Resp>> fut = client.call(..., req -> req.send(stream), resp -> resp.collecting(Collectors.toList()));</code></li>
   * </ul>
   * <pre>
   * @param server the server hosting the service
   * @param service the service to call
   * @param requestHandler the handler called to send the request
   * @param resultFn the function applied to extract the result.
   * @return a future of the result
   */
  public <Req, Resp, T> io.reactivex.rxjava3.core.Single<T> rxCall(io.vertx.rxjava3.core.net.SocketAddress server, io.grpc.MethodDescriptor<Req,Resp> service, io.vertx.core.Handler<io.vertx.rxjava3.grpc.client.GrpcClientRequest<Req,Resp>> requestHandler, java.util.function.Function<io.vertx.rxjava3.grpc.client.GrpcClientResponse<Req,Resp>,io.reactivex.rxjava3.core.Single<T>> resultFn) { 
    return AsyncResultSingle.toSingle(delegate.call(server.getDelegate(), service, new io.vertx.lang.rx.DelegatingHandler<>(requestHandler, event -> io.vertx.rxjava3.grpc.client.GrpcClientRequest.newInstance((io.vertx.grpc.client.GrpcClientRequest)event, TypeArg.unknown(), TypeArg.unknown())), new Function<io.vertx.grpc.client.GrpcClientResponse<Req,Resp>,io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> apply(io.vertx.grpc.client.GrpcClientResponse<Req,Resp> arg) {
        io.reactivex.rxjava3.core.Single<T> ret = resultFn.apply(io.vertx.rxjava3.grpc.client.GrpcClientResponse.newInstance((io.vertx.grpc.client.GrpcClientResponse)arg, TypeArg.unknown(), TypeArg.unknown()));
        return io.vertx.rxjava3.SingleHelper.toFuture(ret, obj -> obj);
      }
    }), __value -> (T) __value);
  }

  public static GrpcClient newInstance(io.vertx.grpc.client.GrpcClient arg) {
    return arg != null ? new GrpcClient(arg) : null;
  }

}
