/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.validation.builder;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * In this interface you can find all available {@link io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory} to use in {@link io.vertx.rxjava3.ext.web.validation.builder.ValidationHandlerBuilder}. <br/>
 *
 * To create new schemas using , look at the <a href="https://vertx.io/docs/vertx-json-schema/java/">docs of vertx-json-schema</a>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.validation.builder.Parameters original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.validation.builder.Parameters.class)
public class Parameters {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Parameters that = (Parameters) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Parameters> __TYPE_ARG = new TypeArg<>(    obj -> new Parameters((io.vertx.ext.web.validation.builder.Parameters) obj),
    Parameters::getDelegate
  );

  private final io.vertx.ext.web.validation.builder.Parameters delegate;
  
  public Parameters(io.vertx.ext.web.validation.builder.Parameters delegate) {
    this.delegate = delegate;
  }

  public Parameters(Object delegate) {
    this.delegate = (io.vertx.ext.web.validation.builder.Parameters)delegate;
  }

  public io.vertx.ext.web.validation.builder.Parameters getDelegate() {
    return delegate;
  }

  /**
   * Creates a new required number parameter. Depending on the type provided in <code>schemaBuilder</code>, the parser will parse the number as {@link java.lang.Long} or {@link java.lang.Double}
   * @param parameterName 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory param(java.lang.String parameterName, io.vertx.json.schema.common.dsl.NumberSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.ParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.param(parameterName, schemaBuilder));
    return ret;
  }

  /**
   * Creates a new optional number parameter. Depending on the type provided in <code>schemaBuilder</code>, the parser will parse the number as {@link java.lang.Long} or {@link java.lang.Double}
   * @param parameterName 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory optionalParam(java.lang.String parameterName, io.vertx.json.schema.common.dsl.NumberSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.ParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.optionalParam(parameterName, schemaBuilder));
    return ret;
  }

  /**
   * Creates a new required string parameter
   * @param parameterName 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory param(java.lang.String parameterName, io.vertx.json.schema.common.dsl.StringSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.ParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.param(parameterName, schemaBuilder));
    return ret;
  }

  /**
   * Creates a new optional string parameter
   * @param parameterName 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory optionalParam(java.lang.String parameterName, io.vertx.json.schema.common.dsl.StringSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.ParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.optionalParam(parameterName, schemaBuilder));
    return ret;
  }

  /**
   * Creates a new required boolean parameter
   * @param parameterName 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory param(java.lang.String parameterName, io.vertx.json.schema.common.dsl.BooleanSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.ParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.param(parameterName, schemaBuilder));
    return ret;
  }

  /**
   * Creates a new optional boolean parameter
   * @param parameterName 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory optionalParam(java.lang.String parameterName, io.vertx.json.schema.common.dsl.BooleanSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.ParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.optionalParam(parameterName, schemaBuilder));
    return ret;
  }

  /**
   * Creates a new required array parameter serialized as comma separated
   * @param parameterName 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory param(java.lang.String parameterName, io.vertx.json.schema.common.dsl.ArraySchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.ParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.param(parameterName, schemaBuilder));
    return ret;
  }

  /**
   * Creates a new optional array parameter serialized as comma separated
   * @param parameterName 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory optionalParam(java.lang.String parameterName, io.vertx.json.schema.common.dsl.ArraySchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.ParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.optionalParam(parameterName, schemaBuilder));
    return ret;
  }

  /**
   * Creates a new required tuple parameter serialized as comma separated
   * @param parameterName 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory param(java.lang.String parameterName, io.vertx.json.schema.common.dsl.TupleSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.ParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.param(parameterName, schemaBuilder));
    return ret;
  }

  /**
   * Creates a new optional tuple parameter serialized as comma separated
   * @param parameterName 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory optionalParam(java.lang.String parameterName, io.vertx.json.schema.common.dsl.TupleSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.ParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.optionalParam(parameterName, schemaBuilder));
    return ret;
  }

  /**
   * Creates a required object parameter serialized as comma separated, like <code>key1,value1,key2,value2</code>
   * @param parameterName 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory param(java.lang.String parameterName, io.vertx.json.schema.common.dsl.ObjectSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.ParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.param(parameterName, schemaBuilder));
    return ret;
  }

  /**
   * Creates an optional object parameter serialized as comma separated, like <code>key1,value1,key2,value2</code>
   * @param parameterName 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory optionalParam(java.lang.String parameterName, io.vertx.json.schema.common.dsl.ObjectSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.ParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.optionalParam(parameterName, schemaBuilder));
    return ret;
  }

  /**
   * Creates a required parameter providing a 
   * @param parameterName 
   * @param schemaBuilder 
   * @param valueParser 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory param(java.lang.String parameterName, io.vertx.json.schema.common.dsl.SchemaBuilder schemaBuilder, io.vertx.ext.web.validation.impl.parser.ValueParser<java.lang.String> valueParser) { 
    io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.ParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.param(parameterName, schemaBuilder, valueParser));
    return ret;
  }

  /**
   * Creates an optional parameter providing a 
   * @param parameterName 
   * @param schemaBuilder 
   * @param valueParser 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory optionalParam(java.lang.String parameterName, io.vertx.json.schema.common.dsl.SchemaBuilder schemaBuilder, io.vertx.ext.web.validation.impl.parser.ValueParser<java.lang.String> valueParser) { 
    io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.ParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.ParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.optionalParam(parameterName, schemaBuilder, valueParser));
    return ret;
  }

  /**
   * Creates a required parameter serialized as valid json
   * @param parameterName 
   * @param builder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory jsonParam(java.lang.String parameterName, io.vertx.json.schema.common.dsl.SchemaBuilder builder) { 
    io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.jsonParam(parameterName, builder));
    return ret;
  }

  /**
   * Creates an optional parameter serialized as valid json
   * @param parameterName 
   * @param builder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory optionalJsonParam(java.lang.String parameterName, io.vertx.json.schema.common.dsl.SchemaBuilder builder) { 
    io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.optionalJsonParam(parameterName, builder));
    return ret;
  }

  /**
   * Creates a required array parameter deserializable using the provided parser factory. Look at {@link io.vertx.rxjava3.ext.web.validation.builder.Parsers} for available parser factories
   * @param parameterName 
   * @param arrayParserFactory 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory serializedParam(java.lang.String parameterName, io.vertx.rxjava3.ext.web.validation.builder.ArrayParserFactory arrayParserFactory, io.vertx.json.schema.common.dsl.ArraySchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.serializedParam(parameterName, arrayParserFactory.getDelegate(), schemaBuilder));
    return ret;
  }

  /**
   * Creates an optional array parameter deserializable using the provided parser factory. Look at {@link io.vertx.rxjava3.ext.web.validation.builder.Parsers} for available parser factories
   * @param parameterName 
   * @param arrayParserFactory 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory optionalSerializedParam(java.lang.String parameterName, io.vertx.rxjava3.ext.web.validation.builder.ArrayParserFactory arrayParserFactory, io.vertx.json.schema.common.dsl.ArraySchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.optionalSerializedParam(parameterName, arrayParserFactory.getDelegate(), schemaBuilder));
    return ret;
  }

  /**
   * Creates a required tuple parameter deserializable using the provided parser factory. Look at {@link io.vertx.rxjava3.ext.web.validation.builder.Parsers} for available parser factories
   * @param parameterName 
   * @param tupleParserFactory 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory serializedParam(java.lang.String parameterName, io.vertx.rxjava3.ext.web.validation.builder.TupleParserFactory tupleParserFactory, io.vertx.json.schema.common.dsl.TupleSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.serializedParam(parameterName, tupleParserFactory.getDelegate(), schemaBuilder));
    return ret;
  }

  /**
   * Creates an optional tuple parameter deserializable using the provided parser factory. Look at {@link io.vertx.rxjava3.ext.web.validation.builder.Parsers} for available parser factories
   * @param parameterName 
   * @param tupleParserFactory 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory optionalSerializedParam(java.lang.String parameterName, io.vertx.rxjava3.ext.web.validation.builder.TupleParserFactory tupleParserFactory, io.vertx.json.schema.common.dsl.TupleSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.optionalSerializedParam(parameterName, tupleParserFactory.getDelegate(), schemaBuilder));
    return ret;
  }

  /**
   * Creates a required object parameter deserializable using the provided parser factory. Look at {@link io.vertx.rxjava3.ext.web.validation.builder.Parsers} for available parser factories
   * @param parameterName 
   * @param objectParserFactory 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory serializedParam(java.lang.String parameterName, io.vertx.rxjava3.ext.web.validation.builder.ObjectParserFactory objectParserFactory, io.vertx.json.schema.common.dsl.ObjectSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.serializedParam(parameterName, objectParserFactory.getDelegate(), schemaBuilder));
    return ret;
  }

  /**
   * Creates an optional object parameter deserializable using the provided parser factory. Look at {@link io.vertx.rxjava3.ext.web.validation.builder.Parsers} for available parser factories
   * @param parameterName 
   * @param objectParserFactory 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory optionalSerializedParam(java.lang.String parameterName, io.vertx.rxjava3.ext.web.validation.builder.ObjectParserFactory objectParserFactory, io.vertx.json.schema.common.dsl.ObjectSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.optionalSerializedParam(parameterName, objectParserFactory.getDelegate(), schemaBuilder));
    return ret;
  }

  /**
   * Creates a required exploded array parameter. Exploded parameters looks like <code>parameterName=item1&parameterName=item2</code>
   * @param parameterName 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory explodedParam(java.lang.String parameterName, io.vertx.json.schema.common.dsl.ArraySchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.explodedParam(parameterName, schemaBuilder));
    return ret;
  }

  /**
   * Creates an optional exploded array parameter. Exploded parameters looks like <code>parameterName=item1&parameterName=item2</code>
   * @param parameterName 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory optionalExplodedParam(java.lang.String parameterName, io.vertx.json.schema.common.dsl.ArraySchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.optionalExplodedParam(parameterName, schemaBuilder));
    return ret;
  }

  /**
   * Creates a required exploded tuple parameter. Exploded parameters looks like <code>parameterName=item1&parameterName=item2</code>
   * @param parameterName 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory explodedParam(java.lang.String parameterName, io.vertx.json.schema.common.dsl.TupleSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.explodedParam(parameterName, schemaBuilder));
    return ret;
  }

  /**
   * Creates an optional exploded tuple parameter. Exploded parameters looks like <code>parameterName=item1&parameterName=item2</code>
   * @param parameterName 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory optionalExplodedParam(java.lang.String parameterName, io.vertx.json.schema.common.dsl.TupleSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.optionalExplodedParam(parameterName, schemaBuilder));
    return ret;
  }

  /**
   * Creates a required exploded object parameter. Exploded parameters looks like <code>key1=value1&key2=value2</code>
   * @param parameterName 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory explodedParam(java.lang.String parameterName, io.vertx.json.schema.common.dsl.ObjectSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.explodedParam(parameterName, schemaBuilder));
    return ret;
  }

  /**
   * Creates an optional exploded object parameter. Exploded parameters looks like <code>key1=value1&key2=value2</code>
   * @param parameterName 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory optionalExplodedParam(java.lang.String parameterName, io.vertx.json.schema.common.dsl.ObjectSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.optionalExplodedParam(parameterName, schemaBuilder));
    return ret;
  }

  /**
   * Creates a required deep object parameter. Deep object parameters looks like <code>parameterName[key1]=value1&parameterName[key2]=value2</code>
   * @param parameterName 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory deepObjectParam(java.lang.String parameterName, io.vertx.json.schema.common.dsl.ObjectSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.deepObjectParam(parameterName, schemaBuilder));
    return ret;
  }

  /**
   * Creates an optional deep object parameter. Deep object parameters looks like <code>parameterName[key1]=value1&parameterName[key2]=value2</code>
   * @param parameterName 
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory optionalDeepObjectParam(java.lang.String parameterName, io.vertx.json.schema.common.dsl.ObjectSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory ret = io.vertx.rxjava3.ext.web.validation.builder.StyledParameterProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory)io.vertx.ext.web.validation.builder.Parameters.optionalDeepObjectParam(parameterName, schemaBuilder));
    return ret;
  }

  public static Parameters newInstance(io.vertx.ext.web.validation.builder.Parameters arg) {
    return arg != null ? new Parameters(arg) : null;
  }

}
