/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.validation;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Request predicate
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.validation.RequestPredicate original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.validation.RequestPredicate.class)
public class RequestPredicate implements Function<io.vertx.rxjava3.ext.web.RoutingContext, io.vertx.rxjava3.ext.web.validation.RequestPredicateResult> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RequestPredicate that = (RequestPredicate) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  @Override
  public io.vertx.rxjava3.ext.web.validation.RequestPredicateResult apply(io.vertx.rxjava3.ext.web.RoutingContext in) {
    io.vertx.ext.web.validation.RequestPredicateResult ret;
    ret = getDelegate().apply(in.getDelegate());
    Function<io.vertx.ext.web.validation.RequestPredicateResult, io.vertx.rxjava3.ext.web.validation.RequestPredicateResult> outConv = io.vertx.rxjava3.ext.web.validation.RequestPredicateResult::newInstance;
    return outConv.apply(ret);
  }

  public static final TypeArg<RequestPredicate> __TYPE_ARG = new TypeArg<>(    obj -> new RequestPredicate((io.vertx.ext.web.validation.RequestPredicate) obj),
    RequestPredicate::getDelegate
  );

  private final io.vertx.ext.web.validation.RequestPredicate delegate;
  
  public RequestPredicate(io.vertx.ext.web.validation.RequestPredicate delegate) {
    this.delegate = delegate;
  }

  public RequestPredicate(Object delegate) {
    this.delegate = (io.vertx.ext.web.validation.RequestPredicate)delegate;
  }

  public io.vertx.ext.web.validation.RequestPredicate getDelegate() {
    return delegate;
  }

  /**
   * Generate request predicate that checks if a particular multipart file upload with <code>propertyName</code> and matching <code>contentTypePattern</code> exists
   * @param propertyName 
   * @param contentTypePattern 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.validation.RequestPredicate multipartFileUploadExists(java.lang.String propertyName, java.lang.String contentTypePattern) { 
    io.vertx.rxjava3.ext.web.validation.RequestPredicate ret = io.vertx.rxjava3.ext.web.validation.RequestPredicate.newInstance((io.vertx.ext.web.validation.RequestPredicate)io.vertx.ext.web.validation.RequestPredicate.multipartFileUploadExists(propertyName, contentTypePattern));
    return ret;
  }

  /**
   * Request predicate that checks if body exists or not
   */
  public static final io.vertx.rxjava3.ext.web.validation.RequestPredicate BODY_REQUIRED = io.vertx.rxjava3.ext.web.validation.RequestPredicate.newInstance((io.vertx.ext.web.validation.RequestPredicate)io.vertx.ext.web.validation.RequestPredicate.BODY_REQUIRED);
  public static RequestPredicate newInstance(io.vertx.ext.web.validation.RequestPredicate arg) {
    return arg != null ? new RequestPredicate(arg) : null;
  }

}
