/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.sstore;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A session store is used to store sessions for an Vert.x-Web web app
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.sstore.SessionStore original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.sstore.SessionStore.class)
public class SessionStore {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SessionStore that = (SessionStore) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SessionStore> __TYPE_ARG = new TypeArg<>(    obj -> new SessionStore((io.vertx.ext.web.sstore.SessionStore) obj),
    SessionStore::getDelegate
  );

  private final io.vertx.ext.web.sstore.SessionStore delegate;
  
  public SessionStore(io.vertx.ext.web.sstore.SessionStore delegate) {
    this.delegate = delegate;
  }

  public SessionStore(Object delegate) {
    this.delegate = (io.vertx.ext.web.sstore.SessionStore)delegate;
  }

  public io.vertx.ext.web.sstore.SessionStore getDelegate() {
    return delegate;
  }

  /**
   * Create a Session store given a backend and configuration JSON.
   * @param vertx vertx instance
   * @return the store or runtime exception
   */
  public static io.vertx.rxjava3.ext.web.sstore.SessionStore create(io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.ext.web.sstore.SessionStore ret = io.vertx.rxjava3.ext.web.sstore.SessionStore.newInstance((io.vertx.ext.web.sstore.SessionStore)io.vertx.ext.web.sstore.SessionStore.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a Session store given a backend and configuration JSON.
   * @param vertx vertx instance
   * @param options extra options for initialization
   * @return the store or runtime exception
   */
  public static io.vertx.rxjava3.ext.web.sstore.SessionStore create(io.vertx.rxjava3.core.Vertx vertx, io.vertx.core.json.JsonObject options) { 
    io.vertx.rxjava3.ext.web.sstore.SessionStore ret = io.vertx.rxjava3.ext.web.sstore.SessionStore.newInstance((io.vertx.ext.web.sstore.SessionStore)io.vertx.ext.web.sstore.SessionStore.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Initialize this store.
   * @param vertx the vertx instance
   * @param options optional Json with extra configuration options
   * @return self
   */
  public io.vertx.rxjava3.ext.web.sstore.SessionStore init(io.vertx.rxjava3.core.Vertx vertx, io.vertx.core.json.JsonObject options) { 
    delegate.init(vertx.getDelegate(), options);
    return this;
  }

  /**
   * The retry timeout value in milli seconds used by the session handler when it retrieves a value from the store.<p/>
   *
   * A non positive value means there is no retry at all.
   * @return the timeout value, in ms
   */
  public long retryTimeout() { 
    long ret = delegate.retryTimeout();
    return ret;
  }

  /**
   * Create a new session using the default min length.
   * @param timeout - the session timeout, in ms
   * @return the session
   */
  public io.vertx.rxjava3.ext.web.Session createSession(long timeout) { 
    io.vertx.rxjava3.ext.web.Session ret = io.vertx.rxjava3.ext.web.Session.newInstance((io.vertx.ext.web.Session)delegate.createSession(timeout));
    return ret;
  }

  /**
   * Create a new session.
   * @param timeout - the session timeout, in ms
   * @param length - the required length for the session id
   * @return the session
   */
  public io.vertx.rxjava3.ext.web.Session createSession(long timeout, int length) { 
    io.vertx.rxjava3.ext.web.Session ret = io.vertx.rxjava3.ext.web.Session.newInstance((io.vertx.ext.web.Session)delegate.createSession(timeout, length));
    return ret;
  }

  /**
   * Get the session with the specified ID.
   * @param cookieValue the unique ID of the session
   * @return 
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.ext.web.Session> get(java.lang.String cookieValue) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.ext.web.Session> ret = rxGet(cookieValue);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Get the session with the specified ID.
   * @param cookieValue the unique ID of the session
   * @return 
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.ext.web.Session> rxGet(java.lang.String cookieValue) { 
    return AsyncResultMaybe.toMaybe( resultHandler -> {
      delegate.get(cookieValue, new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.rxjava3.ext.web.Session.newInstance((io.vertx.ext.web.Session)event))));
    });
  }

  /**
   * Delete the session with the specified ID.
   * @param id the session id
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable delete(java.lang.String id) { 
    io.reactivex.rxjava3.core.Completable ret = rxDelete(id);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Delete the session with the specified ID.
   * @param id the session id
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxDelete(java.lang.String id) { 
    return AsyncResultCompletable.toCompletable( resultHandler -> {
      delegate.delete(id, resultHandler);
    });
  }

  /**
   * Add a session with the specified ID.
   * @param session the session
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable put(io.vertx.rxjava3.ext.web.Session session) { 
    io.reactivex.rxjava3.core.Completable ret = rxPut(session);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Add a session with the specified ID.
   * @param session the session
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxPut(io.vertx.rxjava3.ext.web.Session session) { 
    return AsyncResultCompletable.toCompletable( resultHandler -> {
      delegate.put(session.getDelegate(), resultHandler);
    });
  }

  /**
   * Remove all sessions from the store.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable clear() { 
    io.reactivex.rxjava3.core.Completable ret = rxClear();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Remove all sessions from the store.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxClear() { 
    return AsyncResultCompletable.toCompletable( resultHandler -> {
      delegate.clear(resultHandler);
    });
  }

  /**
   * Get the number of sessions in the store.
   * <p>
   * Beware of the result which is just an estimate, in particular with distributed session stores.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Integer> size() { 
    io.reactivex.rxjava3.core.Single<java.lang.Integer> ret = rxSize();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Get the number of sessions in the store.
   * <p>
   * Beware of the result which is just an estimate, in particular with distributed session stores.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Integer> rxSize() { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.size(resultHandler);
    });
  }

  /**
   * Close the store
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Default length for a session id.
   * More info: https://www.owasp.org/index.php/Session_Management_Cheat_Sheet
   */
  public static final int DEFAULT_SESSIONID_LENGTH = io.vertx.ext.web.sstore.SessionStore.DEFAULT_SESSIONID_LENGTH;
  public static SessionStore newInstance(io.vertx.ext.web.sstore.SessionStore arg) {
    return arg != null ? new SessionStore(arg) : null;
  }

}
