/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.handler.graphql;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A handler for GraphQL requests sent over Apollo's <code>subscriptions-transport-ws</code> transport.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.graphql.ApolloWSHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.graphql.ApolloWSHandler.class)
public class ApolloWSHandler implements io.vertx.rxjava3.ext.web.handler.ProtocolUpgradeHandler, Handler<io.vertx.rxjava3.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApolloWSHandler that = (ApolloWSHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ApolloWSHandler> __TYPE_ARG = new TypeArg<>(    obj -> new ApolloWSHandler((io.vertx.ext.web.handler.graphql.ApolloWSHandler) obj),
    ApolloWSHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.graphql.ApolloWSHandler delegate;
  
  public ApolloWSHandler(io.vertx.ext.web.handler.graphql.ApolloWSHandler delegate) {
    this.delegate = delegate;
  }

  public ApolloWSHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.graphql.ApolloWSHandler)delegate;
  }

  public io.vertx.ext.web.handler.graphql.ApolloWSHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  @Deprecated()
  public void handle(io.vertx.rxjava3.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Customize the connection .
   * This handler will be called at the beginning of each websocket connection.
   * @param connectionHandler 
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSHandler connectionHandler(io.vertx.core.Handler<io.vertx.rxjava3.core.http.ServerWebSocket> connectionHandler) { 
    delegate.connectionHandler(new io.vertx.lang.rx.DelegatingHandler<>(connectionHandler, event -> io.vertx.rxjava3.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)event)));
    return this;
  }

  /**
   * Customize the connection init .
   * This handler will be called when the  message is received.
   * @param connectionInitHandler 
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSHandler connectionInitHandler(io.vertx.core.Handler<io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSConnectionInitEvent> connectionInitHandler) { 
    delegate.connectionInitHandler(new io.vertx.lang.rx.DelegatingHandler<>(connectionInitHandler, event -> io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSConnectionInitEvent.newInstance((io.vertx.ext.web.handler.graphql.ApolloWSConnectionInitEvent)event)));
    return this;
  }

  /**
   * Customize the message .
   * This handler will be called for each {@link io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSMessage} received.
   * @param messageHandler 
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSHandler messageHandler(io.vertx.core.Handler<io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSMessage> messageHandler) { 
    delegate.messageHandler(new io.vertx.lang.rx.DelegatingHandler<>(messageHandler, event -> io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSMessage.newInstance((io.vertx.ext.web.handler.graphql.ApolloWSMessage)event)));
    return this;
  }

  /**
   * Customize the end .
   * This handler will be called at the end of each websocket connection.
   * @param endHandler 
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSHandler endHandler(io.vertx.core.Handler<io.vertx.rxjava3.core.http.ServerWebSocket> endHandler) { 
    delegate.endHandler(new io.vertx.lang.rx.DelegatingHandler<>(endHandler, event -> io.vertx.rxjava3.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)event)));
    return this;
  }

  /**
   * Customize the query context object.
   * The provided <code>factory</code> method will be invoked for each incoming GraphQL request.
   * @param factory 
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSHandler queryContext(java.util.function.Function<io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSMessage,java.lang.Object> factory) { 
    delegate.queryContext(new Function<io.vertx.ext.web.handler.graphql.ApolloWSMessage,java.lang.Object>() {
      public java.lang.Object apply(io.vertx.ext.web.handler.graphql.ApolloWSMessage arg) {
        java.lang.Object ret = factory.apply(io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSMessage.newInstance((io.vertx.ext.web.handler.graphql.ApolloWSMessage)arg));
        return ret;
      }
    });
    return this;
  }

  /**
   * Set a callback to invoke before executing a GraphQL query.
   * @param config the callback to invoke
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSHandler beforeExecute(io.vertx.core.Handler<io.vertx.rxjava3.ext.web.handler.graphql.ExecutionInputBuilderWithContext<io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSMessage>> config) { 
    delegate.beforeExecute(new io.vertx.lang.rx.DelegatingHandler<>(config, event -> io.vertx.rxjava3.ext.web.handler.graphql.ExecutionInputBuilderWithContext.newInstance((io.vertx.ext.web.handler.graphql.ExecutionInputBuilderWithContext)event, new TypeArg<io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSMessage>(o0 -> io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSMessage.newInstance((io.vertx.ext.web.handler.graphql.ApolloWSMessage)o0), o0 -> o0.getDelegate()))));
    return this;
  }

  /**
   * Create a new {@link io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSHandler} that will use the provided <code>graphQL</code> object to execute requests.
   * <p>
   * The handler will be configured with the default {@link io.vertx.ext.web.handler.graphql.ApolloWSOptions}.
   * @param graphQL 
   * @return 
   */
  @Deprecated()
  public static io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSHandler create(graphql.GraphQL graphQL) { 
    io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSHandler ret = io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSHandler.newInstance((io.vertx.ext.web.handler.graphql.ApolloWSHandler)io.vertx.ext.web.handler.graphql.ApolloWSHandler.create(graphQL));
    return ret;
  }

  /**
   * Create a new {@link io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSHandler} that will use the provided <code>graphQL</code> object to execute requests.
   * <p>
   * The handler will be configured with the given <code>options</code>.
   * @param graphQL 
   * @param options options for configuring the {@link io.vertx.ext.web.handler.graphql.ApolloWSOptions}
   * @return 
   */
  @Deprecated()
  public static io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSHandler create(graphql.GraphQL graphQL, io.vertx.ext.web.handler.graphql.ApolloWSOptions options) { 
    io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSHandler ret = io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSHandler.newInstance((io.vertx.ext.web.handler.graphql.ApolloWSHandler)io.vertx.ext.web.handler.graphql.ApolloWSHandler.create(graphQL, options));
    return ret;
  }

  /**
   * Retrieves the {@link io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSMessage} from the .
   * @param graphQlContext the GraphQL context object
   * @return the {@link io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSMessage}
   */
  @Deprecated()
  public static io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSMessage getMessage(graphql.GraphQLContext graphQlContext) { 
    io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSMessage ret = io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSMessage.newInstance((io.vertx.ext.web.handler.graphql.ApolloWSMessage)io.vertx.ext.web.handler.graphql.ApolloWSHandler.getMessage(graphQlContext));
    return ret;
  }

  /**
   * Customize the .
   * The provided <code>factory</code> method will be invoked for each incoming GraphQL request.
   * @param factory 
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSHandler dataLoaderRegistry(java.util.function.Function<io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSMessage,org.dataloader.DataLoaderRegistry> factory) { 
    delegate.dataLoaderRegistry(new Function<io.vertx.ext.web.handler.graphql.ApolloWSMessage,org.dataloader.DataLoaderRegistry>() {
      public org.dataloader.DataLoaderRegistry apply(io.vertx.ext.web.handler.graphql.ApolloWSMessage arg) {
        org.dataloader.DataLoaderRegistry ret = factory.apply(io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSMessage.newInstance((io.vertx.ext.web.handler.graphql.ApolloWSMessage)arg));
        return ret;
      }
    });
    return this;
  }

  /**
   * Customize the  passed to the GraphQL execution engine.
   * The provided <code>factory</code> method will be invoked for each incoming GraphQL request.
   * @param factory 
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSHandler locale(java.util.function.Function<io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSMessage,java.util.Locale> factory) { 
    delegate.locale(new Function<io.vertx.ext.web.handler.graphql.ApolloWSMessage,java.util.Locale>() {
      public java.util.Locale apply(io.vertx.ext.web.handler.graphql.ApolloWSMessage arg) {
        java.util.Locale ret = factory.apply(io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSMessage.newInstance((io.vertx.ext.web.handler.graphql.ApolloWSMessage)arg));
        return ret;
      }
    });
    return this;
  }

  public static ApolloWSHandler newInstance(io.vertx.ext.web.handler.graphql.ApolloWSHandler arg) {
    return arg != null ? new ApolloWSHandler(arg) : null;
  }

}
