/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.shell.command;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A resolver for commands, so the shell can discover commands.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.command.CommandResolver original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.shell.command.CommandResolver.class)
public class CommandResolver {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CommandResolver that = (CommandResolver) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<CommandResolver> __TYPE_ARG = new TypeArg<>(    obj -> new CommandResolver((io.vertx.ext.shell.command.CommandResolver) obj),
    CommandResolver::getDelegate
  );

  private final io.vertx.ext.shell.command.CommandResolver delegate;
  
  public CommandResolver(io.vertx.ext.shell.command.CommandResolver delegate) {
    this.delegate = delegate;
  }

  public CommandResolver(Object delegate) {
    this.delegate = (io.vertx.ext.shell.command.CommandResolver)delegate;
  }

  public io.vertx.ext.shell.command.CommandResolver getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava3.ext.shell.command.Command> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.ext.shell.command.Command>(o1 -> io.vertx.rxjava3.ext.shell.command.Command.newInstance((io.vertx.ext.shell.command.Command)o1), o1 -> o1.getDelegate());

  /**
   * @param vertx 
   * @return the base commands of Vert.x Shell.
   */
  public static io.vertx.rxjava3.ext.shell.command.CommandResolver baseCommands(io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.ext.shell.command.CommandResolver ret = io.vertx.rxjava3.ext.shell.command.CommandResolver.newInstance((io.vertx.ext.shell.command.CommandResolver)io.vertx.ext.shell.command.CommandResolver.baseCommands(vertx.getDelegate()));
    return ret;
  }

  /**
   * @return the current commands
   */
  public java.util.List<io.vertx.rxjava3.ext.shell.command.Command> commands() { 
    java.util.List<io.vertx.rxjava3.ext.shell.command.Command> ret = delegate.commands().stream().map(elt -> io.vertx.rxjava3.ext.shell.command.Command.newInstance((io.vertx.ext.shell.command.Command)elt)).collect(Collectors.toList());
    return ret;
  }

  /**
   * Returns a single command by its name.
   * @param name the command name
   * @return the commad or null
   */
  public io.vertx.rxjava3.ext.shell.command.Command getCommand(java.lang.String name) { 
    io.vertx.rxjava3.ext.shell.command.Command ret = io.vertx.rxjava3.ext.shell.command.Command.newInstance((io.vertx.ext.shell.command.Command)delegate.getCommand(name));
    return ret;
  }

  public static CommandResolver newInstance(io.vertx.ext.shell.command.CommandResolver arg) {
    return arg != null ? new CommandResolver(arg) : null;
  }

}
