/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.auth.oauth2.providers;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Simplified factory to create an  for Stripe.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.StripeAuth original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.oauth2.providers.StripeAuth.class)
public class StripeAuth {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StripeAuth that = (StripeAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<StripeAuth> __TYPE_ARG = new TypeArg<>(    obj -> new StripeAuth((io.vertx.ext.auth.oauth2.providers.StripeAuth) obj),
    StripeAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.StripeAuth delegate;
  
  public StripeAuth(io.vertx.ext.auth.oauth2.providers.StripeAuth delegate) {
    this.delegate = delegate;
  }

  public StripeAuth(Object delegate) {
    this.delegate = (io.vertx.ext.auth.oauth2.providers.StripeAuth)delegate;
  }

  public io.vertx.ext.auth.oauth2.providers.StripeAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a OAuth2Auth provider for Stripe
   * @param vertx 
   * @param clientId the client id given to you by Stripe
   * @param clientSecret the client secret given to you by Stripe
   * @return 
   */
  public static io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth create(io.vertx.rxjava3.core.Vertx vertx, java.lang.String clientId, java.lang.String clientSecret) { 
    io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth ret = io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.StripeAuth.create(vertx.getDelegate(), clientId, clientSecret));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for Stripe
   * @param vertx 
   * @param clientId the client id given to you by Stripe
   * @param clientSecret the client secret given to you by Stripe
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth create(io.vertx.rxjava3.core.Vertx vertx, java.lang.String clientId, java.lang.String clientSecret, io.vertx.core.http.HttpClientOptions httpClientOptions) { 
    io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth ret = io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.StripeAuth.create(vertx.getDelegate(), clientId, clientSecret, httpClientOptions));
    return ret;
  }

  public static StripeAuth newInstance(io.vertx.ext.auth.oauth2.providers.StripeAuth arg) {
    return arg != null ? new StripeAuth(arg) : null;
  }

}
