/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.auth.mongo;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Utility to create users/roles/permissions. This is a helper class and not intended to be a full user
 * management utility. While the standard authentication and authorization interfaces will require usually
 * read only access to the database, in order to use this API a full read/write access must be granted.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.mongo.MongoUserUtil original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.mongo.MongoUserUtil.class)
public class MongoUserUtil {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MongoUserUtil that = (MongoUserUtil) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MongoUserUtil> __TYPE_ARG = new TypeArg<>(    obj -> new MongoUserUtil((io.vertx.ext.auth.mongo.MongoUserUtil) obj),
    MongoUserUtil::getDelegate
  );

  private final io.vertx.ext.auth.mongo.MongoUserUtil delegate;
  
  public MongoUserUtil(io.vertx.ext.auth.mongo.MongoUserUtil delegate) {
    this.delegate = delegate;
  }

  public MongoUserUtil(Object delegate) {
    this.delegate = (io.vertx.ext.auth.mongo.MongoUserUtil)delegate;
  }

  public io.vertx.ext.auth.mongo.MongoUserUtil getDelegate() {
    return delegate;
  }

  /**
   * Create an instance of the user helper.
   * @param client the client with write rights to the database.
   * @return the instance
   */
  public static io.vertx.rxjava3.ext.auth.mongo.MongoUserUtil create(io.vertx.rxjava3.ext.mongo.MongoClient client) { 
    io.vertx.rxjava3.ext.auth.mongo.MongoUserUtil ret = io.vertx.rxjava3.ext.auth.mongo.MongoUserUtil.newInstance((io.vertx.ext.auth.mongo.MongoUserUtil)io.vertx.ext.auth.mongo.MongoUserUtil.create(client.getDelegate()));
    return ret;
  }

  /**
   * Create an instance of the user helper with custom queries.
   * @param client the client with write rights to the database.
   * @param authenticationOptions 
   * @param authorizationOptions 
   * @return the instance
   */
  public static io.vertx.rxjava3.ext.auth.mongo.MongoUserUtil create(io.vertx.rxjava3.ext.mongo.MongoClient client, io.vertx.ext.auth.mongo.MongoAuthenticationOptions authenticationOptions, io.vertx.ext.auth.mongo.MongoAuthorizationOptions authorizationOptions) { 
    io.vertx.rxjava3.ext.auth.mongo.MongoUserUtil ret = io.vertx.rxjava3.ext.auth.mongo.MongoUserUtil.newInstance((io.vertx.ext.auth.mongo.MongoUserUtil)io.vertx.ext.auth.mongo.MongoUserUtil.create(client.getDelegate(), authenticationOptions, authorizationOptions));
    return ret;
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param password the password in clear text, will be adapted following the definitions of the defined strategy
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Single<java.lang.String> createUser(java.lang.String username, java.lang.String password) { 
    io.reactivex.rxjava3.core.Single<java.lang.String> ret = rxCreateUser(username, password);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param password the password in clear text, will be adapted following the definitions of the defined strategy
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Single<java.lang.String> rxCreateUser(java.lang.String username, java.lang.String password) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.createUser(username, password, resultHandler);
    });
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param hash the password hash, as result of {@link io.vertx.rxjava3.ext.auth.HashingStrategy#hash}
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Single<java.lang.String> createHashedUser(java.lang.String username, java.lang.String hash) { 
    io.reactivex.rxjava3.core.Single<java.lang.String> ret = rxCreateHashedUser(username, hash);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param hash the password hash, as result of {@link io.vertx.rxjava3.ext.auth.HashingStrategy#hash}
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Single<java.lang.String> rxCreateHashedUser(java.lang.String username, java.lang.String hash) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.createHashedUser(username, hash, resultHandler);
    });
  }

  /**
   * Insert a user role into a database.
   * @param username the username to be set
   * @param roles a to be set
   * @param permissions a to be set
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Single<java.lang.String> createUserRolesAndPermissions(java.lang.String username, java.util.List<java.lang.String> roles, java.util.List<java.lang.String> permissions) { 
    io.reactivex.rxjava3.core.Single<java.lang.String> ret = rxCreateUserRolesAndPermissions(username, roles, permissions);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Insert a user role into a database.
   * @param username the username to be set
   * @param roles a to be set
   * @param permissions a to be set
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Single<java.lang.String> rxCreateUserRolesAndPermissions(java.lang.String username, java.util.List<java.lang.String> roles, java.util.List<java.lang.String> permissions) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.createUserRolesAndPermissions(username, roles, permissions, resultHandler);
    });
  }

  public static MongoUserUtil newInstance(io.vertx.ext.auth.mongo.MongoUserUtil arg) {
    return arg != null ? new MongoUserUtil(arg) : null;
  }

}
