/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.core.net;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A combination of host and port.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.HostAndPort original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.net.HostAndPort.class)
public class HostAndPort {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HostAndPort that = (HostAndPort) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HostAndPort> __TYPE_ARG = new TypeArg<>(    obj -> new HostAndPort((io.vertx.core.net.HostAndPort) obj),
    HostAndPort::getDelegate
  );

  private final io.vertx.core.net.HostAndPort delegate;
  
  public HostAndPort(io.vertx.core.net.HostAndPort delegate) {
    this.delegate = delegate;
  }

  public HostAndPort(Object delegate) {
    this.delegate = (io.vertx.core.net.HostAndPort)delegate;
  }

  public io.vertx.core.net.HostAndPort getDelegate() {
    return delegate;
  }

  /**
   * Create an instance.
   * @param host the host value
   * @param port the port value
   * @return the instance.
   */
  public static io.vertx.rxjava3.core.net.HostAndPort create(java.lang.String host, int port) { 
    io.vertx.rxjava3.core.net.HostAndPort ret = io.vertx.rxjava3.core.net.HostAndPort.newInstance((io.vertx.core.net.HostAndPort)io.vertx.core.net.HostAndPort.create(host, port));
    return ret;
  }

  /**
   * @return the host value
   */
  public java.lang.String host() { 
    java.lang.String ret = delegate.host();
    return ret;
  }

  /**
   * @return the port value
   */
  public int port() { 
    int ret = delegate.port();
    return ret;
  }

  public static HostAndPort newInstance(io.vertx.core.net.HostAndPort arg) {
    return arg != null ? new HostAndPort(arg) : null;
  }

}
