/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.core.http;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents an HTTP connection.
 * <p/>
 * HTTP/1.x connection provides an limited implementation, the following methods are implemented:
 * <ul>
 *   <li>{@link io.vertx.rxjava3.core.http.HttpConnection#close}</li>
 *   <li>{@link io.vertx.rxjava3.core.http.HttpConnection#closeHandler}</li>
 *   <li>{@link io.vertx.rxjava3.core.http.HttpConnection#exceptionHandler}</li>
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpConnection original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.http.HttpConnection.class)
public class HttpConnection {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpConnection that = (HttpConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HttpConnection> __TYPE_ARG = new TypeArg<>(    obj -> new HttpConnection((io.vertx.core.http.HttpConnection) obj),
    HttpConnection::getDelegate
  );

  private final io.vertx.core.http.HttpConnection delegate;
  
  public HttpConnection(io.vertx.core.http.HttpConnection delegate) {
    this.delegate = delegate;
  }

  public HttpConnection(Object delegate) {
    this.delegate = (io.vertx.core.http.HttpConnection)delegate;
  }

  public io.vertx.core.http.HttpConnection getDelegate() {
    return delegate;
  }

  /**
   * @return the current connection window size or <code>-1</code> for HTTP/1.x
   */
  public int getWindowSize() { 
    int ret = delegate.getWindowSize();
    return ret;
  }

  /**
   * Update the current connection wide window size to a new size.
   * <p/>
   * Increasing this value, gives better performance when several data streams are multiplexed
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param windowSize the new window size
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.http.HttpConnection setWindowSize(int windowSize) { 
    delegate.setWindowSize(windowSize);
    return this;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.http.HttpConnection#goAway} with a last stream id <code>-1</code> which means to disallow any new stream creation.
   * @param errorCode 
   * @return 
   */
  public io.vertx.rxjava3.core.http.HttpConnection goAway(long errorCode) { 
    delegate.goAway(errorCode);
    return this;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.http.HttpConnection#goAway} with no buffer.
   * @param errorCode 
   * @param lastStreamId 
   * @return 
   */
  public io.vertx.rxjava3.core.http.HttpConnection goAway(long errorCode, int lastStreamId) { 
    delegate.goAway(errorCode, lastStreamId);
    return this;
  }

  /**
   * Send a go away frame to the remote endpoint of the connection.
   * <p/>
   * <ul>
   *   <li>a  frame is sent to the to the remote endpoint with the <code>errorCode</code> and <code>debugData</code></li>
   *   <li>any stream created after the stream identified by <code>lastStreamId</code> will be closed</li>
   *   <li>for an  is different than <code>0</code> when all the remaining streams are closed this connection will be closed automatically</li>
   * </ul>
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param errorCode the  error code
   * @param lastStreamId the last stream id
   * @param debugData additional debug data sent to the remote endpoint
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.http.HttpConnection goAway(long errorCode, int lastStreamId, io.vertx.rxjava3.core.buffer.Buffer debugData) { 
    delegate.goAway(errorCode, lastStreamId, debugData.getDelegate());
    return this;
  }

  /**
   * Set an handler called when a  frame is received.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.http.HttpConnection goAwayHandler(io.vertx.core.Handler<io.vertx.core.http.GoAway> handler) { 
    delegate.goAwayHandler(handler);
    return this;
  }

  /**
   * Set an handler called when a  frame has been sent or received and all connections are closed.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.http.HttpConnection shutdownHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.shutdownHandler(handler);
    return this;
  }

  /**
   * Initiate a graceful connection shutdown, the connection is taken out of service and closed when all current requests
   * are processed, otherwise after 30 seconds the connection will be closed. Client connection are immediately removed
   * from the pool.
   *
   * <ul>
   *   <li>HTTP/2 connections will send a go away frame immediately to signal the other side the connection will close</li>
   *   <li>HTTP/1.x client connection supports this feature</li>
   *   <li>HTTP/1.x server connections do not support this feature</li>
   * </ul>
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable shutdown() { 
    io.reactivex.rxjava3.core.Completable ret = rxShutdown();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Initiate a graceful connection shutdown, the connection is taken out of service and closed when all current requests
   * are processed, otherwise after 30 seconds the connection will be closed. Client connection are immediately removed
   * from the pool.
   *
   * <ul>
   *   <li>HTTP/2 connections will send a go away frame immediately to signal the other side the connection will close</li>
   *   <li>HTTP/1.x client connection supports this feature</li>
   *   <li>HTTP/1.x server connections do not support this feature</li>
   * </ul>
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxShutdown() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.shutdown(handler);
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.http.HttpConnection#shutdown} but with a specific <code>timeout</code> in milliseconds.
   * @param timeout 
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable shutdown(long timeout) { 
    io.reactivex.rxjava3.core.Completable ret = rxShutdown(timeout);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.http.HttpConnection#shutdown} but with a specific <code>timeout</code> in milliseconds.
   * @param timeout 
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxShutdown(long timeout) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.shutdown(timeout, handler);
    });
  }

  /**
   * Set a close handler. The handler will get notified when the connection is closed.
   * @param handler the handler to be notified
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.http.HttpConnection closeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Close the connection and all the currently active streams.
   * <p/>
   * An HTTP/2 connection will send a  frame before.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable close() { 
    io.reactivex.rxjava3.core.Completable ret = rxClose();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Close the connection and all the currently active streams.
   * <p/>
   * An HTTP/2 connection will send a  frame before.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.close(handler);
    });
  }

  /**
   * @return the latest server settings acknowledged by the remote endpoint - this is not implemented for HTTP/1.x
   */
  public io.vertx.core.http.Http2Settings settings() { 
    io.vertx.core.http.Http2Settings ret = delegate.settings();
    return ret;
  }

  /**
   * Send to the remote endpoint an update of this endpoint settings
   * <p/>
   * The <code>completionHandler</code> will be notified when the remote endpoint has acknowledged the settings.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param settings the new settings
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Completable updateSettings(io.vertx.core.http.Http2Settings settings) { 
    io.reactivex.rxjava3.core.Completable ret = rxUpdateSettings(settings);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Send to the remote endpoint an update of this endpoint settings
   * <p/>
   * The <code>completionHandler</code> will be notified when the remote endpoint has acknowledged the settings.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param settings the new settings
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Completable rxUpdateSettings(io.vertx.core.http.Http2Settings settings) { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.updateSettings(settings, completionHandler);
    });
  }

  /**
   * @return the current remote endpoint settings for this connection - this is not implemented for HTTP/1.x
   */
  public io.vertx.core.http.Http2Settings remoteSettings() { 
    io.vertx.core.http.Http2Settings ret = delegate.remoteSettings();
    return ret;
  }

  /**
   * Set an handler that is called when remote endpoint {@link io.vertx.core.http.Http2Settings} are updated.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param handler the handler for remote endpoint settings
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.http.HttpConnection remoteSettingsHandler(io.vertx.core.Handler<io.vertx.core.http.Http2Settings> handler) { 
    delegate.remoteSettingsHandler(handler);
    return this;
  }

  /**
   * Send a  frame to the remote endpoint.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param data the 8 bytes data of the frame
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.buffer.Buffer> ping(io.vertx.rxjava3.core.buffer.Buffer data) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.buffer.Buffer> ret = rxPing(data);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Send a  frame to the remote endpoint.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param data the 8 bytes data of the frame
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.buffer.Buffer> rxPing(io.vertx.rxjava3.core.buffer.Buffer data) { 
    return AsyncResultSingle.toSingle( pongHandler -> {
      delegate.ping(data.getDelegate(), new io.vertx.lang.rx.DelegatingHandler<>(pongHandler, ar -> ar.map(event -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event))));
    });
  }

  /**
   * Set an handler notified when a  frame is received from the remote endpoint.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param handler the handler to be called when a  is received
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.http.HttpConnection pingHandler(io.vertx.core.Handler<io.vertx.rxjava3.core.buffer.Buffer> handler) { 
    delegate.pingHandler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event)));
    return this;
  }

  /**
   * Set an handler called when a connection error happens
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.http.HttpConnection exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket). If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the actual connecting client.
   */
  public io.vertx.rxjava3.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.rxjava3.core.net.SocketAddress ret = io.vertx.rxjava3.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.http.HttpConnection#remoteAddress} but returns the proxy remote address when <code>real</code> is <code>true</code>
   * @param real 
   * @return 
   */
  public io.vertx.rxjava3.core.net.SocketAddress remoteAddress(boolean real) { 
    io.vertx.rxjava3.core.net.SocketAddress ret = io.vertx.rxjava3.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.remoteAddress(real));
    return ret;
  }

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket) If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the proxy.
   */
  public io.vertx.rxjava3.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.rxjava3.core.net.SocketAddress ret = io.vertx.rxjava3.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.http.HttpConnection#localAddress} ()} but returns the server local address when <code>real</code> is <code>true</code>
   * @param real 
   * @return 
   */
  public io.vertx.rxjava3.core.net.SocketAddress localAddress(boolean real) { 
    io.vertx.rxjava3.core.net.SocketAddress ret = io.vertx.rxjava3.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress(real));
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.rxjava3.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * Returns the SNI server name presented during the SSL handshake by the client.
   * @return the indicated server name
   */
  public java.lang.String indicatedServerName() { 
    java.lang.String ret = delegate.indicatedServerName();
    return ret;
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public javax.net.ssl.SSLSession sslSession() { 
    javax.net.ssl.SSLSession ret = delegate.sslSession();
    return ret;
  }

  private io.vertx.rxjava3.core.net.SocketAddress cached_0;
  private io.vertx.rxjava3.core.net.SocketAddress cached_1;
  public static HttpConnection newInstance(io.vertx.core.http.HttpConnection arg) {
    return arg != null ? new HttpConnection(arg) : null;
  }

}
