/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.core.eventbus;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * Encapsulates a message being delivered by Vert.x as well as providing control over the message delivery.
 * <p/>
 * Used with event bus interceptors.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.DeliveryContext original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.eventbus.DeliveryContext.class)
public class DeliveryContext<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DeliveryContext that = (DeliveryContext) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<DeliveryContext> __TYPE_ARG = new TypeArg<>(    obj -> new DeliveryContext((io.vertx.core.eventbus.DeliveryContext) obj),
    DeliveryContext::getDelegate
  );

  private final io.vertx.core.eventbus.DeliveryContext<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public DeliveryContext(io.vertx.core.eventbus.DeliveryContext delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public DeliveryContext(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.core.eventbus.DeliveryContext)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.core.eventbus.DeliveryContext getDelegate() {
    return delegate;
  }


  /**
   * @return The message being delivered
   */
  public io.vertx.rxjava3.core.eventbus.Message<T> message() { 
    io.vertx.rxjava3.core.eventbus.Message<T> ret = io.vertx.rxjava3.core.eventbus.Message.newInstance((io.vertx.core.eventbus.Message)delegate.message(), __typeArg_0);
    return ret;
  }

  /**
   * Call the next interceptor
   */
  public void next() { 
    delegate.next();
  }

  /**
   * @return true if the message is being sent (point to point) or False if the message is being published
   */
  public boolean send() { 
    boolean ret = delegate.send();
    return ret;
  }

  /**
   * @return the value delivered by the message (before or after being processed by the codec)
   */
  public java.lang.Object body() { 
    java.lang.Object ret = (Object) delegate.body();
    return ret;
  }

  public static <T> DeliveryContext<T> newInstance(io.vertx.core.eventbus.DeliveryContext arg) {
    return arg != null ? new DeliveryContext<T>(arg) : null;
  }

  public static <T> DeliveryContext<T> newInstance(io.vertx.core.eventbus.DeliveryContext arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new DeliveryContext<T>(arg, __typeArg_T) : null;
  }

}
