/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.redis.client;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * <b>Auto generated</b> Redis API client wrapper.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.RedisAPI original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.redis.client.RedisAPI.class)
public class RedisAPI {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedisAPI that = (RedisAPI) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RedisAPI> __TYPE_ARG = new TypeArg<>(    obj -> new RedisAPI((io.vertx.redis.client.RedisAPI) obj),
    RedisAPI::getDelegate
  );

  private final io.vertx.redis.client.RedisAPI delegate;
  
  public RedisAPI(io.vertx.redis.client.RedisAPI delegate) {
    this.delegate = delegate;
  }

  public RedisAPI(Object delegate) {
    this.delegate = (io.vertx.redis.client.RedisAPI)delegate;
  }

  public io.vertx.redis.client.RedisAPI getDelegate() {
    return delegate;
  }

  public void close() { 
    delegate.close();
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.ADD">ftAdd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftAdd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtAdd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.ADD">ftAdd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftAdd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.AGGREGATE">ftAggregate</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftAggregate(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtAggregate(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.AGGREGATE">ftAggregate</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtAggregate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftAggregate(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.ALIASADD">ftAliasadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftAliasadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtAliasadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.ALIASADD">ftAliasadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtAliasadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftAliasadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.ALIASDEL">ftAliasdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftAliasdel(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtAliasdel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.ALIASDEL">ftAliasdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtAliasdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftAliasdel(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.ALIASUPDATE">ftAliasupdate</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftAliasupdate(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtAliasupdate(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.ALIASUPDATE">ftAliasupdate</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtAliasupdate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftAliasupdate(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.ALTER">ftAlter</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftAlter(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtAlter(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.ALTER">ftAlter</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtAlter(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftAlter(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.CONFIG">ftConfig</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftConfig(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtConfig(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.CONFIG">ftConfig</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtConfig(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftConfig(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.CREATE">ftCreate</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftCreate(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtCreate(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.CREATE">ftCreate</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtCreate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftCreate(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.CURSOR">ftCursor</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftCursor(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtCursor(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.CURSOR">ftCursor</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtCursor(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftCursor(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DEBUG">ftDebug</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftDebug(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtDebug(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DEBUG">ftDebug</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftDebug(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DEL">ftDel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftDel(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtDel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DEL">ftDel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtDel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftDel(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DICTADD">ftDictadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftDictadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtDictadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DICTADD">ftDictadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtDictadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftDictadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DICTDEL">ftDictdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftDictdel(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtDictdel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DICTDEL">ftDictdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtDictdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftDictdel(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DICTDUMP">ftDictdump</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftDictdump(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtDictdump(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DICTDUMP">ftDictdump</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtDictdump(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftDictdump(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DROP">ftDrop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftDrop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtDrop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DROP">ftDrop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtDrop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftDrop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DROPINDEX">ftDropindex</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftDropindex(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtDropindex(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DROPINDEX">ftDropindex</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtDropindex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftDropindex(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.EXPLAIN">ftExplain</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftExplain(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtExplain(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.EXPLAIN">ftExplain</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtExplain(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftExplain(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.EXPLAINCLI">ftExplaincli</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftExplaincli(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtExplaincli(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.EXPLAINCLI">ftExplaincli</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtExplaincli(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftExplaincli(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.GET">ftGet</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftGet(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtGet(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.GET">ftGet</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtGet(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftGet(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.INFO">ftInfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftInfo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtInfo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.INFO">ftInfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftInfo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.MGET">ftMget</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftMget(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtMget(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.MGET">ftMget</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtMget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftMget(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.PROFILE">ftProfile</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftProfile(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtProfile(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.PROFILE">ftProfile</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtProfile(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftProfile(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SAFEADD">ftSafeadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftSafeadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtSafeadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SAFEADD">ftSafeadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtSafeadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftSafeadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SEARCH">ftSearch</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftSearch(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtSearch(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SEARCH">ftSearch</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtSearch(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftSearch(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SPELLCHECK">ftSpellcheck</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftSpellcheck(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtSpellcheck(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SPELLCHECK">ftSpellcheck</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtSpellcheck(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftSpellcheck(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SUGADD">ftSugadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftSugadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtSugadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SUGADD">ftSugadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtSugadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftSugadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SUGDEL">ftSugdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftSugdel(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtSugdel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SUGDEL">ftSugdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtSugdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftSugdel(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SUGGET">ftSugget</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftSugget(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtSugget(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SUGGET">ftSugget</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtSugget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftSugget(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SUGLEN">ftSuglen</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftSuglen(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtSuglen(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SUGLEN">ftSuglen</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtSuglen(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftSuglen(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SYNADD">ftSynadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftSynadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtSynadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SYNADD">ftSynadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtSynadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftSynadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SYNDUMP">ftSyndump</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftSyndump(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtSyndump(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SYNDUMP">ftSyndump</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtSyndump(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftSyndump(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SYNUPDATE">ftSynupdate</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftSynupdate(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtSynupdate(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SYNUPDATE">ftSynupdate</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtSynupdate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftSynupdate(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.TAGVALS">ftTagvals</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftTagvals(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtTagvals(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.TAGVALS">ftTagvals</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtTagvals(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftTagvals(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._ALIASADDIFNX">ftAliasaddifnx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftAliasaddifnx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtAliasaddifnx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._ALIASADDIFNX">ftAliasaddifnx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtAliasaddifnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftAliasaddifnx(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._ALIASDELIFX">ftAliasdelifx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftAliasdelifx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtAliasdelifx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._ALIASDELIFX">ftAliasdelifx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtAliasdelifx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftAliasdelifx(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._ALTERIFNX">ftAlterifnx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftAlterifnx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtAlterifnx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._ALTERIFNX">ftAlterifnx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtAlterifnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftAlterifnx(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._CREATEIFNX">ftCreateifnx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftCreateifnx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtCreateifnx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._CREATEIFNX">ftCreateifnx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtCreateifnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftCreateifnx(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._DROPIFX">ftDropifx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftDropifx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtDropifx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._DROPIFX">ftDropifx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtDropifx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftDropifx(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._DROPINDEXIFX">ftDropindexifx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftDropindexifx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtDropindexifx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._DROPINDEXIFX">ftDropindexifx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtDropindexifx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftDropindexifx(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._LIST">ftList</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ftList(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFtList(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._LIST">ftList</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFtList(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ftList(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/acl">acl</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> acl(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxAcl(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/acl">acl</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxAcl(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.acl(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/append">append</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> append(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxAppend(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/append">append</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxAppend(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.append(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/asking">asking</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> asking() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxAsking();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/asking">asking</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxAsking() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.asking(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/auth">auth</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> auth(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxAuth(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/auth">auth</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxAuth(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.auth(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.add">bfAdd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bfAdd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBfAdd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.add">bfAdd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBfAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bfAdd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.debug">bfDebug</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bfDebug(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBfDebug(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.debug">bfDebug</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBfDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bfDebug(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.exists">bfExists</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bfExists(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBfExists(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.exists">bfExists</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBfExists(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bfExists(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.info">bfInfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bfInfo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBfInfo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.info">bfInfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBfInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bfInfo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.insert">bfInsert</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bfInsert(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBfInsert(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.insert">bfInsert</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBfInsert(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bfInsert(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.loadchunk">bfLoadchunk</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bfLoadchunk(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBfLoadchunk(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.loadchunk">bfLoadchunk</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBfLoadchunk(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bfLoadchunk(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.madd">bfMadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bfMadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBfMadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.madd">bfMadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBfMadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bfMadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.mexists">bfMexists</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bfMexists(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBfMexists(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.mexists">bfMexists</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBfMexists(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bfMexists(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.reserve">bfReserve</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bfReserve(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBfReserve(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.reserve">bfReserve</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBfReserve(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bfReserve(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.scandump">bfScandump</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bfScandump(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBfScandump(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.scandump">bfScandump</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBfScandump(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bfScandump(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgrewriteaof">bgrewriteaof</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bgrewriteaof() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBgrewriteaof();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgrewriteaof">bgrewriteaof</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBgrewriteaof() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bgrewriteaof(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgsave">bgsave</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bgsave(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBgsave(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgsave">bgsave</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBgsave(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bgsave(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitcount">bitcount</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bitcount(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBitcount(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitcount">bitcount</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBitcount(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bitcount(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield">bitfield</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bitfield(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBitfield(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield">bitfield</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBitfield(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bitfield(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield_ro">bitfieldRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bitfieldRo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBitfieldRo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield_ro">bitfieldRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBitfieldRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bitfieldRo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitop">bitop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bitop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBitop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitop">bitop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBitop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bitop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitpos">bitpos</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bitpos(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBitpos(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitpos">bitpos</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBitpos(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bitpos(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/blmove">blmove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param arg4 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> blmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBlmove(arg0, arg1, arg2, arg3, arg4);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/blmove">blmove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param arg4 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBlmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.blmove(arg0, arg1, arg2, arg3, arg4, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/blmpop">blmpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> blmpop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBlmpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/blmpop">blmpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBlmpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.blmpop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/blpop">blpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> blpop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBlpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/blpop">blpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBlpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.blpop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpop">brpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> brpop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBrpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpop">brpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBrpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.brpop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpoplpush">brpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> brpoplpush(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBrpoplpush(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpoplpush">brpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBrpoplpush(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.brpoplpush(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzmpop">bzmpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bzmpop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBzmpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzmpop">bzmpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBzmpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bzmpop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmax">bzpopmax</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bzpopmax(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBzpopmax(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmax">bzpopmax</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBzpopmax(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bzpopmax(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmin">bzpopmin</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bzpopmin(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBzpopmin(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmin">bzpopmin</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBzpopmin(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bzpopmin(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.add">cfAdd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfAdd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfAdd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.add">cfAdd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfAdd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.addnx">cfAddnx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfAddnx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfAddnx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.addnx">cfAddnx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfAddnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfAddnx(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.compact">cfCompact</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfCompact(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfCompact(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.compact">cfCompact</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfCompact(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfCompact(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.count">cfCount</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfCount(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfCount(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.count">cfCount</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfCount(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfCount(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.debug">cfDebug</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfDebug(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfDebug(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.debug">cfDebug</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfDebug(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.del">cfDel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfDel(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfDel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.del">cfDel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfDel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfDel(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.exists">cfExists</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfExists(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfExists(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.exists">cfExists</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfExists(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfExists(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.info">cfInfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfInfo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfInfo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.info">cfInfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfInfo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insert">cfInsert</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfInsert(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfInsert(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insert">cfInsert</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfInsert(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfInsert(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insertnx">cfInsertnx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfInsertnx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfInsertnx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insertnx">cfInsertnx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfInsertnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfInsertnx(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.loadchunk">cfLoadchunk</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfLoadchunk(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfLoadchunk(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.loadchunk">cfLoadchunk</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfLoadchunk(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfLoadchunk(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.mexists">cfMexists</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfMexists(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfMexists(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.mexists">cfMexists</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfMexists(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfMexists(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.reserve">cfReserve</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfReserve(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfReserve(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.reserve">cfReserve</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfReserve(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfReserve(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.scandump">cfScandump</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cfScandump(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCfScandump(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.scandump">cfScandump</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCfScandump(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cfScandump(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/client">client</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> client(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxClient(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/client">client</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxClient(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.client(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cluster">cluster</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cluster(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCluster(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cluster">cluster</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCluster(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cluster(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.incrby">cmsIncrby</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cmsIncrby(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCmsIncrby(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.incrby">cmsIncrby</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCmsIncrby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cmsIncrby(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.info">cmsInfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cmsInfo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCmsInfo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.info">cmsInfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCmsInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cmsInfo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbydim">cmsInitbydim</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cmsInitbydim(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCmsInitbydim(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbydim">cmsInitbydim</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCmsInitbydim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cmsInitbydim(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbyprob">cmsInitbyprob</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cmsInitbyprob(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCmsInitbyprob(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbyprob">cmsInitbyprob</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCmsInitbyprob(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cmsInitbyprob(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.merge">cmsMerge</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cmsMerge(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCmsMerge(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.merge">cmsMerge</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCmsMerge(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cmsMerge(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.query">cmsQuery</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cmsQuery(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCmsQuery(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.query">cmsQuery</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCmsQuery(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cmsQuery(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/command">command</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> command(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCommand(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/command">command</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCommand(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.command(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/config">config</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> config(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxConfig(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/config">config</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxConfig(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.config(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/copy">copy</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> copy(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCopy(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/copy">copy</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCopy(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.copy(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/dbsize">dbsize</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> dbsize() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxDbsize();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/dbsize">dbsize</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxDbsize() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.dbsize(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/debug">debug</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> debug(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxDebug(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/debug">debug</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.debug(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/decr">decr</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> decr(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxDecr(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/decr">decr</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxDecr(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.decr(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/decrby">decrby</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> decrby(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxDecrby(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/decrby">decrby</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxDecrby(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.decrby(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/del">del</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> del(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxDel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/del">del</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxDel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.del(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/discard">discard</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> discard() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxDiscard();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/discard">discard</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxDiscard() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.discard(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/dump">dump</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> dump(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxDump(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/dump">dump</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxDump(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.dump(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/echo">echo</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> echo(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxEcho(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/echo">echo</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxEcho(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.echo(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/eval">eval</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> eval(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxEval(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/eval">eval</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxEval(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.eval(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/eval_ro">evalRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> evalRo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxEvalRo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/eval_ro">evalRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxEvalRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.evalRo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/evalsha">evalsha</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> evalsha(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxEvalsha(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/evalsha">evalsha</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxEvalsha(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.evalsha(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/evalsha_ro">evalshaRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> evalshaRo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxEvalshaRo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/evalsha_ro">evalshaRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxEvalshaRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.evalshaRo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/exec">exec</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> exec() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxExec();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/exec">exec</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxExec() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.exec(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/exists">exists</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> exists(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxExists(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/exists">exists</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxExists(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.exists(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/expire">expire</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> expire(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxExpire(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/expire">expire</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxExpire(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.expire(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/expireat">expireat</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> expireat(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxExpireat(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/expireat">expireat</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxExpireat(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.expireat(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/expiretime">expiretime</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> expiretime(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxExpiretime(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/expiretime">expiretime</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxExpiretime(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.expiretime(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/failover">failover</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> failover(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFailover(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/failover">failover</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFailover(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.failover(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/fcall">fcall</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> fcall(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFcall(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/fcall">fcall</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFcall(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.fcall(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/fcall_ro">fcallRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> fcallRo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFcallRo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/fcall_ro">fcallRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFcallRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.fcallRo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushall">flushall</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> flushall(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFlushall(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushall">flushall</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFlushall(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.flushall(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushdb">flushdb</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> flushdb(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFlushdb(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushdb">flushdb</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFlushdb(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.flushdb(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/function">function</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> function(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFunction(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/function">function</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFunction(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.function(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/geoadd">geoadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> geoadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeoadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geoadd">geoadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeoadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.geoadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/geodist">geodist</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> geodist(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeodist(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geodist">geodist</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeodist(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.geodist(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/geohash">geohash</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> geohash(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeohash(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geohash">geohash</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeohash(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.geohash(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/geopos">geopos</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> geopos(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeopos(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geopos">geopos</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeopos(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.geopos(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius">georadius</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> georadius(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeoradius(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius">georadius</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeoradius(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.georadius(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius_ro">georadiusRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> georadiusRo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeoradiusRo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius_ro">georadiusRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeoradiusRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.georadiusRo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember">georadiusbymember</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> georadiusbymember(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeoradiusbymember(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember">georadiusbymember</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeoradiusbymember(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.georadiusbymember(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro">georadiusbymemberRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> georadiusbymemberRo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeoradiusbymemberRo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro">georadiusbymemberRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeoradiusbymemberRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.georadiusbymemberRo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/geosearch">geosearch</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> geosearch(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeosearch(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geosearch">geosearch</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeosearch(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.geosearch(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/geosearchstore">geosearchstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> geosearchstore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeosearchstore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geosearchstore">geosearchstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeosearchstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.geosearchstore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/get">get</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> get(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGet(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/get">get</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGet(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.get(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/getbit">getbit</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> getbit(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGetbit(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getbit">getbit</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGetbit(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.getbit(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/getdel">getdel</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> getdel(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGetdel(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getdel">getdel</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGetdel(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.getdel(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/getex">getex</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> getex(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGetex(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getex">getex</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGetex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.getex(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/getrange">getrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> getrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGetrange(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getrange">getrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGetrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.getrange(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/getset">getset</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> getset(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGetset(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getset">getset</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGetset(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.getset(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.BULK">graphBulk</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> graphBulk(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGraphBulk(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.BULK">graphBulk</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGraphBulk(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.graphBulk(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.CONFIG">graphConfig</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> graphConfig(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGraphConfig(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.CONFIG">graphConfig</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGraphConfig(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.graphConfig(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.DEBUG">graphDebug</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> graphDebug(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGraphDebug(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.DEBUG">graphDebug</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGraphDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.graphDebug(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.DELETE">graphDelete</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> graphDelete(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGraphDelete(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.DELETE">graphDelete</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGraphDelete(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.graphDelete(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.EXPLAIN">graphExplain</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> graphExplain(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGraphExplain(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.EXPLAIN">graphExplain</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGraphExplain(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.graphExplain(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.LIST">graphList</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> graphList(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGraphList(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.LIST">graphList</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGraphList(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.graphList(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.PROFILE">graphProfile</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> graphProfile(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGraphProfile(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.PROFILE">graphProfile</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGraphProfile(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.graphProfile(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.QUERY">graphQuery</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> graphQuery(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGraphQuery(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.QUERY">graphQuery</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGraphQuery(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.graphQuery(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.RO_QUERY">graphRoQuery</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> graphRoQuery(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGraphRoQuery(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.RO_QUERY">graphRoQuery</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGraphRoQuery(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.graphRoQuery(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.SLOWLOG">graphSlowlog</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> graphSlowlog(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGraphSlowlog(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.SLOWLOG">graphSlowlog</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGraphSlowlog(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.graphSlowlog(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hdel">hdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hdel(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHdel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hdel">hdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hdel(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hello">hello</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hello(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHello(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hello">hello</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHello(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hello(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hexists">hexists</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hexists(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHexists(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hexists">hexists</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHexists(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hexists(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hget">hget</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hget(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHget(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hget">hget</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHget(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hget(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hgetall">hgetall</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hgetall(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHgetall(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hgetall">hgetall</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHgetall(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hgetall(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrby">hincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHincrby(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrby">hincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hincrby(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrbyfloat">hincrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hincrbyfloat(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHincrbyfloat(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrbyfloat">hincrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHincrbyfloat(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hincrbyfloat(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hkeys">hkeys</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hkeys(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHkeys(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hkeys">hkeys</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHkeys(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hkeys(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hlen">hlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hlen(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHlen(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hlen">hlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hlen(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmget">hmget</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hmget(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHmget(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmget">hmget</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHmget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hmget(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmset">hmset</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hmset(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHmset(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmset">hmset</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHmset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hmset(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hrandfield">hrandfield</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hrandfield(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHrandfield(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hrandfield">hrandfield</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHrandfield(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hrandfield(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hscan">hscan</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hscan(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHscan(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hscan">hscan</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHscan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hscan(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hset">hset</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hset(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHset(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hset">hset</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hset(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hsetnx">hsetnx</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hsetnx(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHsetnx(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hsetnx">hsetnx</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHsetnx(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hsetnx(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hstrlen">hstrlen</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hstrlen(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHstrlen(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hstrlen">hstrlen</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHstrlen(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hstrlen(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hvals">hvals</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hvals(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHvals(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hvals">hvals</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHvals(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hvals(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/incr">incr</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> incr(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxIncr(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/incr">incr</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxIncr(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.incr(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrby">incrby</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> incrby(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxIncrby(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrby">incrby</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxIncrby(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.incrby(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrbyfloat">incrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> incrbyfloat(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxIncrbyfloat(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrbyfloat">incrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxIncrbyfloat(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.incrbyfloat(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/info">info</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> info(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxInfo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/info">info</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.info(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrappend">jsonArrappend</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonArrappend(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonArrappend(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrappend">jsonArrappend</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonArrappend(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonArrappend(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrindex">jsonArrindex</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonArrindex(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonArrindex(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrindex">jsonArrindex</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonArrindex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonArrindex(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrinsert">jsonArrinsert</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonArrinsert(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonArrinsert(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrinsert">jsonArrinsert</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonArrinsert(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonArrinsert(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrlen">jsonArrlen</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonArrlen(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonArrlen(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrlen">jsonArrlen</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonArrlen(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonArrlen(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrpop">jsonArrpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonArrpop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonArrpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrpop">jsonArrpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonArrpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonArrpop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrtrim">jsonArrtrim</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonArrtrim(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonArrtrim(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrtrim">jsonArrtrim</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonArrtrim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonArrtrim(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.clear">jsonClear</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonClear(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonClear(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.clear">jsonClear</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonClear(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonClear(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.debug">jsonDebug</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonDebug(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonDebug(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.debug">jsonDebug</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonDebug(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.del">jsonDel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonDel(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonDel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.del">jsonDel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonDel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonDel(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.forget">jsonForget</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonForget(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonForget(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.forget">jsonForget</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonForget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonForget(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.get">jsonGet</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonGet(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonGet(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.get">jsonGet</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonGet(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonGet(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.mget">jsonMget</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonMget(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonMget(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.mget">jsonMget</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonMget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonMget(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numincrby">jsonNumincrby</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonNumincrby(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonNumincrby(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numincrby">jsonNumincrby</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonNumincrby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonNumincrby(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.nummultby">jsonNummultby</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonNummultby(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonNummultby(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.nummultby">jsonNummultby</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonNummultby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonNummultby(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numpowby">jsonNumpowby</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonNumpowby(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonNumpowby(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numpowby">jsonNumpowby</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonNumpowby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonNumpowby(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objkeys">jsonObjkeys</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonObjkeys(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonObjkeys(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objkeys">jsonObjkeys</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonObjkeys(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonObjkeys(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objlen">jsonObjlen</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonObjlen(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonObjlen(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objlen">jsonObjlen</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonObjlen(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonObjlen(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.resp">jsonResp</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonResp(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonResp(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.resp">jsonResp</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonResp(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonResp(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.set">jsonSet</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonSet(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonSet(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.set">jsonSet</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonSet(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonSet(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strappend">jsonStrappend</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonStrappend(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonStrappend(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strappend">jsonStrappend</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonStrappend(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonStrappend(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strlen">jsonStrlen</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonStrlen(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonStrlen(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strlen">jsonStrlen</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonStrlen(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonStrlen(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.toggle">jsonToggle</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonToggle(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonToggle(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.toggle">jsonToggle</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonToggle(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonToggle(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.type">jsonType</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> jsonType(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxJsonType(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.type">jsonType</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxJsonType(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.jsonType(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/keys">keys</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> keys(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxKeys(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/keys">keys</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxKeys(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.keys(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lastsave">lastsave</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lastsave() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLastsave();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lastsave">lastsave</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLastsave() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lastsave(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/latency">latency</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> latency(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLatency(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/latency">latency</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLatency(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.latency(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lcs">lcs</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lcs(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLcs(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lcs">lcs</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLcs(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lcs(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lindex">lindex</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lindex(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLindex(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lindex">lindex</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLindex(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lindex(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/linsert">linsert</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> linsert(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLinsert(arg0, arg1, arg2, arg3);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/linsert">linsert</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLinsert(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.linsert(arg0, arg1, arg2, arg3, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/llen">llen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> llen(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLlen(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/llen">llen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.llen(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lmove">lmove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLmove(arg0, arg1, arg2, arg3);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lmove">lmove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lmove(arg0, arg1, arg2, arg3, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lmpop">lmpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lmpop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLmpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lmpop">lmpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLmpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lmpop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lolwut">lolwut</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lolwut(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLolwut(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lolwut">lolwut</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLolwut(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lolwut(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpop">lpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lpop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpop">lpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lpop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpos">lpos</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lpos(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLpos(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpos">lpos</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLpos(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lpos(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpush">lpush</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lpush(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLpush(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpush">lpush</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLpush(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lpush(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpushx">lpushx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lpushx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLpushx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpushx">lpushx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLpushx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lpushx(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrange">lrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLrange(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrange">lrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lrange(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrem">lrem</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lrem(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLrem(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrem">lrem</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLrem(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lrem(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lset">lset</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lset(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLset(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lset">lset</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLset(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lset(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ltrim">ltrim</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ltrim(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLtrim(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ltrim">ltrim</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLtrim(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ltrim(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/memory">memory</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> memory(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMemory(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/memory">memory</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMemory(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.memory(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/mget">mget</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> mget(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMget(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/mget">mget</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.mget(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/migrate">migrate</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> migrate(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMigrate(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/migrate">migrate</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMigrate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.migrate(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/module">module</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> module(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxModule(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/module">module</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxModule(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.module(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/monitor">monitor</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> monitor() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMonitor();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/monitor">monitor</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMonitor() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.monitor(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/move">move</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> move(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMove(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/move">move</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMove(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.move(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/mset">mset</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> mset(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMset(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/mset">mset</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.mset(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/msetnx">msetnx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> msetnx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMsetnx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/msetnx">msetnx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMsetnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.msetnx(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/multi">multi</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> multi() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMulti();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/multi">multi</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMulti() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.multi(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/object">object</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> object(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxObject(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/object">object</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxObject(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.object(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/persist">persist</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> persist(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPersist(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/persist">persist</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPersist(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.persist(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpire">pexpire</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pexpire(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPexpire(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpire">pexpire</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPexpire(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pexpire(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpireat">pexpireat</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pexpireat(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPexpireat(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpireat">pexpireat</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPexpireat(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pexpireat(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpiretime">pexpiretime</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pexpiretime(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPexpiretime(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpiretime">pexpiretime</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPexpiretime(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pexpiretime(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfadd">pfadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pfadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPfadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfadd">pfadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPfadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pfadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfcount">pfcount</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pfcount(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPfcount(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfcount">pfcount</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPfcount(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pfcount(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfdebug">pfdebug</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pfdebug(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPfdebug(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfdebug">pfdebug</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPfdebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pfdebug(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfmerge">pfmerge</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pfmerge(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPfmerge(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfmerge">pfmerge</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPfmerge(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pfmerge(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfselftest">pfselftest</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pfselftest() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPfselftest();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfselftest">pfselftest</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPfselftest() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pfselftest(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ping">ping</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ping(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPing(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ping">ping</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPing(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ping(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/psetex">psetex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> psetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPsetex(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/psetex">psetex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPsetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.psetex(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/psubscribe">psubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> psubscribe(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPsubscribe(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/psubscribe">psubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.psubscribe(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/psync">psync</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> psync(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPsync(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/psync">psync</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPsync(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.psync(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pttl">pttl</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pttl(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPttl(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pttl">pttl</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPttl(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pttl(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/publish">publish</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> publish(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPublish(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/publish">publish</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPublish(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.publish(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pubsub">pubsub</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pubsub(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPubsub(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pubsub">pubsub</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPubsub(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pubsub(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/punsubscribe">punsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> punsubscribe(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPunsubscribe(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/punsubscribe">punsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPunsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.punsubscribe(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/quit">quit</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> quit(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxQuit(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/quit">quit</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxQuit(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.quit(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/randomkey">randomkey</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> randomkey() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRandomkey();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/randomkey">randomkey</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRandomkey() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.randomkey(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/readonly">readonly</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> readonly() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxReadonly();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/readonly">readonly</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxReadonly() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.readonly(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/readwrite">readwrite</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> readwrite() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxReadwrite();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/readwrite">readwrite</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxReadwrite() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.readwrite(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rename">rename</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rename(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRename(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rename">rename</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRename(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.rename(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/renamenx">renamenx</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> renamenx(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRenamenx(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/renamenx">renamenx</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRenamenx(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.renamenx(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/replconf">replconf</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> replconf(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxReplconf(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/replconf">replconf</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxReplconf(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.replconf(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/replicaof">replicaof</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> replicaof(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxReplicaof(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/replicaof">replicaof</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxReplicaof(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.replicaof(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/reset">reset</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> reset() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxReset();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/reset">reset</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxReset() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.reset(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore">restore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> restore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRestore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore">restore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRestore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.restore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore-asking">restoreAsking</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> restoreAsking(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRestoreAsking(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore-asking">restoreAsking</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRestoreAsking(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.restoreAsking(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/role">role</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> role() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRole();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/role">role</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRole() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.role(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpop">rpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rpop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpop">rpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.rpop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpoplpush">rpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rpoplpush(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRpoplpush(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpoplpush">rpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRpoplpush(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.rpoplpush(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpush">rpush</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rpush(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRpush(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpush">rpush</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRpush(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.rpush(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpushx">rpushx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rpushx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRpushx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpushx">rpushx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRpushx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.rpushx(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sadd">sadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sadd">sadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/save">save</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> save() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSave();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/save">save</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSave() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.save(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/scan">scan</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> scan(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxScan(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/scan">scan</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxScan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.scan(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/scard">scard</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> scard(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxScard(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/scard">scard</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxScard(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.scard(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/script">script</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> script(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxScript(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/script">script</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxScript(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.script(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiff">sdiff</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sdiff(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSdiff(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiff">sdiff</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSdiff(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sdiff(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiffstore">sdiffstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sdiffstore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSdiffstore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiffstore">sdiffstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSdiffstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sdiffstore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/select">select</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> select(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSelect(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/select">select</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSelect(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.select(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/set">set</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> set(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSet(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/set">set</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSet(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.set(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/setbit">setbit</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> setbit(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSetbit(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setbit">setbit</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSetbit(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.setbit(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/setex">setex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> setex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSetex(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setex">setex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.setex(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/setnx">setnx</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> setnx(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSetnx(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setnx">setnx</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSetnx(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.setnx(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/setrange">setrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> setrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSetrange(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setrange">setrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSetrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.setrange(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/shutdown">shutdown</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> shutdown(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxShutdown(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/shutdown">shutdown</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxShutdown(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.shutdown(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinter">sinter</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sinter(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSinter(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinter">sinter</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSinter(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sinter(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sintercard">sintercard</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sintercard(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSintercard(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sintercard">sintercard</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSintercard(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sintercard(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinterstore">sinterstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sinterstore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSinterstore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinterstore">sinterstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSinterstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sinterstore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sismember">sismember</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sismember(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSismember(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sismember">sismember</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSismember(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sismember(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/slaveof">slaveof</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> slaveof(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSlaveof(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/slaveof">slaveof</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSlaveof(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.slaveof(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/slowlog">slowlog</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> slowlog(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSlowlog(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/slowlog">slowlog</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSlowlog(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.slowlog(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/smembers">smembers</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> smembers(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSmembers(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/smembers">smembers</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSmembers(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.smembers(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/smismember">smismember</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> smismember(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSmismember(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/smismember">smismember</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSmismember(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.smismember(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/smove">smove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> smove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSmove(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/smove">smove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.smove(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sort">sort</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sort(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSort(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sort">sort</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSort(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sort(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sort_ro">sortRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sortRo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSortRo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sort_ro">sortRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSortRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sortRo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/spop">spop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> spop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/spop">spop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.spop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/spublish">spublish</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> spublish(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSpublish(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/spublish">spublish</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSpublish(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.spublish(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/srandmember">srandmember</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> srandmember(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSrandmember(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/srandmember">srandmember</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSrandmember(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.srandmember(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/srem">srem</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> srem(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSrem(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/srem">srem</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSrem(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.srem(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sscan">sscan</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sscan(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSscan(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sscan">sscan</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSscan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sscan(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ssubscribe">ssubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ssubscribe(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSsubscribe(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ssubscribe">ssubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ssubscribe(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/strlen">strlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> strlen(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxStrlen(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/strlen">strlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxStrlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.strlen(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/subscribe">subscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> subscribe(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSubscribe(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/subscribe">subscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.subscribe(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/substr">substr</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> substr(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSubstr(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/substr">substr</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSubstr(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.substr(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunion">sunion</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sunion(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSunion(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunion">sunion</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSunion(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sunion(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunionstore">sunionstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sunionstore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSunionstore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunionstore">sunionstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSunionstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sunionstore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunsubscribe">sunsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sunsubscribe(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSunsubscribe(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunsubscribe">sunsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSunsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sunsubscribe(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/swapdb">swapdb</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> swapdb(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSwapdb(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/swapdb">swapdb</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSwapdb(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.swapdb(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sync">sync</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sync() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSync();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sync">sync</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSync() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sync(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/time">time</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> time() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTime();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/time">time</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTime() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.time(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.CLUSTERSET">timeseriesClusterset</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> timeseriesClusterset(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTimeseriesClusterset(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.CLUSTERSET">timeseriesClusterset</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTimeseriesClusterset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.timeseriesClusterset(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.CLUSTERSETFROMSHARD">timeseriesClustersetfromshard</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> timeseriesClustersetfromshard(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTimeseriesClustersetfromshard(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.CLUSTERSETFROMSHARD">timeseriesClustersetfromshard</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTimeseriesClustersetfromshard(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.timeseriesClustersetfromshard(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.HELLO">timeseriesHello</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> timeseriesHello(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTimeseriesHello(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.HELLO">timeseriesHello</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTimeseriesHello(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.timeseriesHello(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.INFOCLUSTER">timeseriesInfocluster</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> timeseriesInfocluster(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTimeseriesInfocluster(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.INFOCLUSTER">timeseriesInfocluster</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTimeseriesInfocluster(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.timeseriesInfocluster(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.INNERCOMMUNICATION">timeseriesInnercommunication</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> timeseriesInnercommunication(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTimeseriesInnercommunication(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.INNERCOMMUNICATION">timeseriesInnercommunication</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTimeseriesInnercommunication(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.timeseriesInnercommunication(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.NETWORKTEST">timeseriesNetworktest</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> timeseriesNetworktest(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTimeseriesNetworktest(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.NETWORKTEST">timeseriesNetworktest</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTimeseriesNetworktest(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.timeseriesNetworktest(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.REFRESHCLUSTER">timeseriesRefreshcluster</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> timeseriesRefreshcluster(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTimeseriesRefreshcluster(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.REFRESHCLUSTER">timeseriesRefreshcluster</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTimeseriesRefreshcluster(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.timeseriesRefreshcluster(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.add">topkAdd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> topkAdd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTopkAdd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.add">topkAdd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTopkAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.topkAdd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.count">topkCount</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> topkCount(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTopkCount(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.count">topkCount</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTopkCount(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.topkCount(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.incrby">topkIncrby</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> topkIncrby(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTopkIncrby(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.incrby">topkIncrby</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTopkIncrby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.topkIncrby(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.info">topkInfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> topkInfo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTopkInfo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.info">topkInfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTopkInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.topkInfo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.list">topkList</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> topkList(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTopkList(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.list">topkList</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTopkList(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.topkList(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.query">topkQuery</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> topkQuery(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTopkQuery(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.query">topkQuery</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTopkQuery(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.topkQuery(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.reserve">topkReserve</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> topkReserve(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTopkReserve(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.reserve">topkReserve</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTopkReserve(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.topkReserve(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/touch">touch</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> touch(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTouch(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/touch">touch</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTouch(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.touch(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.add">tsAdd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsAdd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsAdd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.add">tsAdd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsAdd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.alter">tsAlter</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsAlter(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsAlter(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.alter">tsAlter</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsAlter(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsAlter(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.create">tsCreate</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsCreate(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsCreate(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.create">tsCreate</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsCreate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsCreate(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.createrule">tsCreaterule</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsCreaterule(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsCreaterule(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.createrule">tsCreaterule</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsCreaterule(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsCreaterule(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.decrby">tsDecrby</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsDecrby(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsDecrby(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.decrby">tsDecrby</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsDecrby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsDecrby(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.del">tsDel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsDel(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsDel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.del">tsDel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsDel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsDel(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.deleterule">tsDeleterule</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsDeleterule(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsDeleterule(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.deleterule">tsDeleterule</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsDeleterule(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsDeleterule(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.get">tsGet</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsGet(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsGet(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.get">tsGet</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsGet(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsGet(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.incrby">tsIncrby</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsIncrby(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsIncrby(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.incrby">tsIncrby</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsIncrby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsIncrby(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.info">tsInfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsInfo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsInfo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.info">tsInfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsInfo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.madd">tsMadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsMadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsMadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.madd">tsMadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsMadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsMadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mget">tsMget</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsMget(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsMget(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mget">tsMget</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsMget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsMget(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrange">tsMrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsMrange(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsMrange(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrange">tsMrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsMrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsMrange(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrevrange">tsMrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsMrevrange(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsMrevrange(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrevrange">tsMrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsMrevrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsMrevrange(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.queryindex">tsQueryindex</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsQueryindex(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsQueryindex(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.queryindex">tsQueryindex</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsQueryindex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsQueryindex(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.range">tsRange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsRange(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsRange(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.range">tsRange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsRange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsRange(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.revrange">tsRevrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> tsRevrange(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTsRevrange(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.revrange">tsRevrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTsRevrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.tsRevrange(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ttl">ttl</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ttl(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTtl(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ttl">ttl</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTtl(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ttl(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/type">type</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> type(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxType(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/type">type</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxType(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.type(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/unlink">unlink</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> unlink(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxUnlink(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/unlink">unlink</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxUnlink(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.unlink(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/unsubscribe">unsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> unsubscribe(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxUnsubscribe(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/unsubscribe">unsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxUnsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.unsubscribe(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/unwatch">unwatch</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> unwatch() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxUnwatch();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/unwatch">unwatch</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxUnwatch() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.unwatch(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/wait">wait</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> wait(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxWait(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/wait">wait</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxWait(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.wait(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/watch">watch</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> watch(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxWatch(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/watch">watch</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxWatch(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.watch(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xack">xack</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xack(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXack(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xack">xack</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXack(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xack(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xadd">xadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xadd">xadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xautoclaim">xautoclaim</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xautoclaim(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXautoclaim(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xautoclaim">xautoclaim</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXautoclaim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xautoclaim(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xclaim">xclaim</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xclaim(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXclaim(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xclaim">xclaim</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXclaim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xclaim(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xdel">xdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xdel(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXdel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xdel">xdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xdel(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xgroup">xgroup</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xgroup(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXgroup(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xgroup">xgroup</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXgroup(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xgroup(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xinfo">xinfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xinfo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXinfo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xinfo">xinfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXinfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xinfo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xlen">xlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xlen(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXlen(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xlen">xlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xlen(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xpending">xpending</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xpending(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXpending(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xpending">xpending</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXpending(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xpending(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrange">xrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xrange(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXrange(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrange">xrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xrange(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xread">xread</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xread(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXread(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xread">xread</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXread(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xread(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xreadgroup">xreadgroup</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xreadgroup(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXreadgroup(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xreadgroup">xreadgroup</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXreadgroup(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xreadgroup(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrevrange">xrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xrevrange(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXrevrange(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrevrange">xrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXrevrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xrevrange(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xsetid">xsetid</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xsetid(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXsetid(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xsetid">xsetid</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXsetid(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xsetid(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xtrim">xtrim</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xtrim(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXtrim(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xtrim">xtrim</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXtrim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xtrim(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zadd">zadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zadd">zadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcard">zcard</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zcard(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZcard(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcard">zcard</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZcard(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zcard(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcount">zcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZcount(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcount">zcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zcount(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zdiff">zdiff</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zdiff(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZdiff(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zdiff">zdiff</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZdiff(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zdiff(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zdiffstore">zdiffstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zdiffstore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZdiffstore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zdiffstore">zdiffstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZdiffstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zdiffstore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zincrby">zincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZincrby(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zincrby">zincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zincrby(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zinter">zinter</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zinter(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZinter(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zinter">zinter</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZinter(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zinter(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zintercard">zintercard</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zintercard(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZintercard(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zintercard">zintercard</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZintercard(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zintercard(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zinterstore">zinterstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zinterstore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZinterstore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zinterstore">zinterstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZinterstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zinterstore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zlexcount">zlexcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zlexcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZlexcount(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zlexcount">zlexcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZlexcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zlexcount(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zmpop">zmpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zmpop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZmpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zmpop">zmpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZmpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zmpop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zmscore">zmscore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zmscore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZmscore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zmscore">zmscore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZmscore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zmscore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmax">zpopmax</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zpopmax(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZpopmax(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmax">zpopmax</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZpopmax(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zpopmax(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmin">zpopmin</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zpopmin(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZpopmin(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmin">zpopmin</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZpopmin(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zpopmin(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrandmember">zrandmember</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrandmember(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrandmember(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrandmember">zrandmember</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrandmember(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrandmember(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrange">zrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrange(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrange(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrange">zrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrange(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebylex">zrangebylex</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrangebylex(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrangebylex(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebylex">zrangebylex</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrangebylex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrangebylex(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebyscore">zrangebyscore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrangebyscore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrangebyscore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebyscore">zrangebyscore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrangebyscore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrangebyscore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangestore">zrangestore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrangestore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrangestore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangestore">zrangestore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrangestore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrangestore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrank">zrank</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrank(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrank(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrank">zrank</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrank(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrank(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrem">zrem</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrem(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrem(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrem">zrem</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrem(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrem(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebylex">zremrangebylex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zremrangebylex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZremrangebylex(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebylex">zremrangebylex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZremrangebylex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zremrangebylex(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyrank">zremrangebyrank</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zremrangebyrank(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZremrangebyrank(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyrank">zremrangebyrank</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZremrangebyrank(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zremrangebyrank(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyscore">zremrangebyscore</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zremrangebyscore(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZremrangebyscore(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyscore">zremrangebyscore</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZremrangebyscore(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zremrangebyscore(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrange">zrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrevrange(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrevrange(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrange">zrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrevrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrevrange(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebylex">zrevrangebylex</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrevrangebylex(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrevrangebylex(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebylex">zrevrangebylex</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrevrangebylex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrevrangebylex(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore">zrevrangebyscore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrevrangebyscore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrevrangebyscore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore">zrevrangebyscore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrevrangebyscore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrevrangebyscore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrank">zrevrank</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrevrank(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrevrank(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrank">zrevrank</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrevrank(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrevrank(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscan">zscan</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zscan(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZscan(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscan">zscan</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZscan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zscan(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscore">zscore</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zscore(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZscore(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscore">zscore</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZscore(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zscore(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zunion">zunion</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zunion(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZunion(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zunion">zunion</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZunion(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zunion(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zunionstore">zunionstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zunionstore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZunionstore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zunionstore">zunionstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZunionstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zunionstore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  public static io.vertx.rxjava3.redis.client.RedisAPI api(io.vertx.rxjava3.redis.client.Redis client) { 
    io.vertx.rxjava3.redis.client.RedisAPI ret = io.vertx.rxjava3.redis.client.RedisAPI.newInstance((io.vertx.redis.client.RedisAPI)io.vertx.redis.client.RedisAPI.api(client.getDelegate()));
    return ret;
  }

  public static io.vertx.rxjava3.redis.client.RedisAPI api(io.vertx.rxjava3.redis.client.RedisConnection connection) { 
    io.vertx.rxjava3.redis.client.RedisAPI ret = io.vertx.rxjava3.redis.client.RedisAPI.newInstance((io.vertx.redis.client.RedisAPI)io.vertx.redis.client.RedisAPI.api(connection.getDelegate()));
    return ret;
  }

  public static RedisAPI newInstance(io.vertx.redis.client.RedisAPI arg) {
    return arg != null ? new RedisAPI(arg) : null;
  }

}
