/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.mqtt.messages;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents an MQTT PUBCOMP message
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.messages.MqttPubCompMessage original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.mqtt.messages.MqttPubCompMessage.class)
public class MqttPubCompMessage {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttPubCompMessage that = (MqttPubCompMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MqttPubCompMessage> __TYPE_ARG = new TypeArg<>(    obj -> new MqttPubCompMessage((io.vertx.mqtt.messages.MqttPubCompMessage) obj),
    MqttPubCompMessage::getDelegate
  );

  private final io.vertx.mqtt.messages.MqttPubCompMessage delegate;
  
  public MqttPubCompMessage(io.vertx.mqtt.messages.MqttPubCompMessage delegate) {
    this.delegate = delegate;
  }

  public MqttPubCompMessage(Object delegate) {
    this.delegate = (io.vertx.mqtt.messages.MqttPubCompMessage)delegate;
  }

  public io.vertx.mqtt.messages.MqttPubCompMessage getDelegate() {
    return delegate;
  }

  public int messageId() { 
    if (cached_0 != null) {
      return cached_0;
    }
    int ret = delegate.messageId();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return reason code from the pubcomp message
   */
  public io.vertx.mqtt.messages.codes.MqttPubCompReasonCode code() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mqtt.messages.codes.MqttPubCompReasonCode ret = delegate.code();
    cached_1 = ret;
    return ret;
  }

  /**
   * Create a concrete instance of a Vert.x pubcomp message
   * @param messageId message Id
   * @param code return code from the pubcomp
   * @param properties MQTT properties of the pubcomp message
   * @return 
   */
  public static io.vertx.rxjava3.mqtt.messages.MqttPubCompMessage create(int messageId, io.vertx.mqtt.messages.codes.MqttPubCompReasonCode code, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    io.vertx.rxjava3.mqtt.messages.MqttPubCompMessage ret = io.vertx.rxjava3.mqtt.messages.MqttPubCompMessage.newInstance((io.vertx.mqtt.messages.MqttPubCompMessage)io.vertx.mqtt.messages.MqttPubCompMessage.create(messageId, code, properties));
    return ret;
  }

  /**
   * @return MQTT properties
   */
  public io.netty.handler.codec.mqtt.MqttProperties properties() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.netty.handler.codec.mqtt.MqttProperties ret = delegate.properties();
    cached_2 = ret;
    return ret;
  }

  private java.lang.Integer cached_0;
  private io.vertx.mqtt.messages.codes.MqttPubCompReasonCode cached_1;
  private io.netty.handler.codec.mqtt.MqttProperties cached_2;
  public static MqttPubCompMessage newInstance(io.vertx.mqtt.messages.MqttPubCompMessage arg) {
    return arg != null ? new MqttPubCompMessage(arg) : null;
  }

}
