/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.kafka.client.producer;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Vert.x Kafka producer.
 * <p>
 * The {@link io.vertx.rxjava3.core.streams.WriteStream#write} provides global control over writing a record.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.client.producer.KafkaProducer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.kafka.client.producer.KafkaProducer.class)
public class KafkaProducer<K,V> implements io.vertx.rxjava3.core.streams.WriteStream<io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V>> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaProducer that = (KafkaProducer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<KafkaProducer> __TYPE_ARG = new TypeArg<>(    obj -> new KafkaProducer((io.vertx.kafka.client.producer.KafkaProducer) obj),
    KafkaProducer::getDelegate
  );

  private final io.vertx.kafka.client.producer.KafkaProducer<K,V> delegate;
  public final TypeArg<K> __typeArg_0;
  public final TypeArg<V> __typeArg_1;
  
  public KafkaProducer(io.vertx.kafka.client.producer.KafkaProducer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();    this.__typeArg_1 = TypeArg.unknown();  }

  public KafkaProducer(Object delegate, TypeArg<K> typeArg_0, TypeArg<V> typeArg_1) {
    this.delegate = (io.vertx.kafka.client.producer.KafkaProducer)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  public io.vertx.kafka.client.producer.KafkaProducer getDelegate() {
    return delegate;
  }

  private WriteStreamObserver<io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V>> observer;
  private WriteStreamSubscriber<io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V>> subscriber;

  public synchronized WriteStreamObserver<io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V>> toObserver() {
    if (observer == null) {
      Function<io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord, io.vertx.kafka.client.producer.KafkaProducerRecord<K,V>> conv = io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V>::getDelegate;
      observer = RxHelper.toObserver(getDelegate(), conv);
    }
    return observer;
  }

  public synchronized WriteStreamSubscriber<io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V>> toSubscriber() {
    if (subscriber == null) {
      Function<io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord, io.vertx.kafka.client.producer.KafkaProducerRecord<K,V>> conv = io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V>::getDelegate;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }


  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable write(io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V> data) { 
    io.reactivex.rxjava3.core.Completable ret = rxWrite(data);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxWrite(io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V> data) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.write(data.getDelegate(), handler);
    });
  }

  /**
   * Same as {@link io.vertx.rxjava3.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable end() { 
    io.reactivex.rxjava3.core.Completable ret = rxEnd();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Same as {@link io.vertx.rxjava3.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxEnd() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.end(handler);
    });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable end(io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V> data) { 
    io.reactivex.rxjava3.core.Completable ret = rxEnd(data);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxEnd(io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V> data) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.end(data.getDelegate(), handler);
    });
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava3.kafka.client.producer.KafkaProducer#setWriteQueueMaxSize}
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Get or create a KafkaProducer instance which shares its stream with any other KafkaProducer created with the same <code>name</code>
   * <p>
   * When <code>close</code> has been called for each shared producer the resources will be released.
   * Calling <code>end</code> closes all shared producers.
   * @param vertx Vert.x instance to use
   * @param name the producer name to identify it
   * @param config Kafka producer configuration
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.rxjava3.kafka.client.producer.KafkaProducer<K,V> createShared(io.vertx.rxjava3.core.Vertx vertx, java.lang.String name, java.util.Map<java.lang.String,java.lang.String> config) { 
    io.vertx.rxjava3.kafka.client.producer.KafkaProducer<K,V> ret = io.vertx.rxjava3.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.createShared(vertx.getDelegate(), name, config), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * Get or create a KafkaProducer instance which shares its stream with any other KafkaProducer created with the same <code>name</code>
   * <p>
   * When <code>close</code> has been called for each shared producer the resources will be released.
   * Calling <code>end</code> closes all shared producers.
   * @param vertx Vert.x instance to use
   * @param name the producer name to identify it
   * @param options Kafka producer options
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.rxjava3.kafka.client.producer.KafkaProducer<K,V> createShared(io.vertx.rxjava3.core.Vertx vertx, java.lang.String name, io.vertx.kafka.client.common.KafkaClientOptions options) { 
    io.vertx.rxjava3.kafka.client.producer.KafkaProducer<K,V> ret = io.vertx.rxjava3.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.createShared(vertx.getDelegate(), name, options), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * Get or create a KafkaProducer instance which shares its stream with any other KafkaProducer created with the same <code>name</code>
   * <p>
   * When <code>close</code> has been called for each shared producer the resources will be released.
   * Calling <code>end</code> closes all shared producers.
   * @param vertx Vert.x instance to use
   * @param name the producer name to identify it
   * @param config Kafka producer configuration
   * @param keyType class type for the key serialization
   * @param valueType class type for the value serialization
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.rxjava3.kafka.client.producer.KafkaProducer<K,V> createShared(io.vertx.rxjava3.core.Vertx vertx, java.lang.String name, java.util.Map<java.lang.String,java.lang.String> config, java.lang.Class<K> keyType, java.lang.Class<V> valueType) { 
    io.vertx.rxjava3.kafka.client.producer.KafkaProducer<K,V> ret = io.vertx.rxjava3.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.createShared(vertx.getDelegate(), name, config, io.vertx.lang.rxjava3.Helper.unwrap(keyType), io.vertx.lang.rxjava3.Helper.unwrap(valueType)), TypeArg.of(keyType), TypeArg.of(valueType));
    return ret;
  }

  /**
   * Get or create a KafkaProducer instance which shares its stream with any other KafkaProducer created with the same <code>name</code>
   * <p>
   * When <code>close</code> has been called for each shared producer the resources will be released.
   * Calling <code>end</code> closes all shared producers.
   * @param vertx Vert.x instance to use
   * @param name the producer name to identify it
   * @param options Kafka producer options
   * @param keyType class type for the key serialization
   * @param valueType class type for the value serialization
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.rxjava3.kafka.client.producer.KafkaProducer<K,V> createShared(io.vertx.rxjava3.core.Vertx vertx, java.lang.String name, io.vertx.kafka.client.common.KafkaClientOptions options, java.lang.Class<K> keyType, java.lang.Class<V> valueType) { 
    io.vertx.rxjava3.kafka.client.producer.KafkaProducer<K,V> ret = io.vertx.rxjava3.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.createShared(vertx.getDelegate(), name, options, io.vertx.lang.rxjava3.Helper.unwrap(keyType), io.vertx.lang.rxjava3.Helper.unwrap(valueType)), TypeArg.of(keyType), TypeArg.of(valueType));
    return ret;
  }

  /**
   * Create a new KafkaProducer instance
   * @param vertx Vert.x instance to use
   * @param config Kafka producer configuration
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.rxjava3.kafka.client.producer.KafkaProducer<K,V> create(io.vertx.rxjava3.core.Vertx vertx, java.util.Map<java.lang.String,java.lang.String> config) { 
    io.vertx.rxjava3.kafka.client.producer.KafkaProducer<K,V> ret = io.vertx.rxjava3.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.create(vertx.getDelegate(), config), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * Create a new KafkaProducer instance
   * @param vertx Vert.x instance to use
   * @param config Kafka producer configuration
   * @param keyType class type for the key serialization
   * @param valueType class type for the value serialization
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.rxjava3.kafka.client.producer.KafkaProducer<K,V> create(io.vertx.rxjava3.core.Vertx vertx, java.util.Map<java.lang.String,java.lang.String> config, java.lang.Class<K> keyType, java.lang.Class<V> valueType) { 
    io.vertx.rxjava3.kafka.client.producer.KafkaProducer<K,V> ret = io.vertx.rxjava3.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.create(vertx.getDelegate(), config, io.vertx.lang.rxjava3.Helper.unwrap(keyType), io.vertx.lang.rxjava3.Helper.unwrap(valueType)), TypeArg.of(keyType), TypeArg.of(valueType));
    return ret;
  }

  /**
   * Initializes the underlying kafka transactional producer. See {@link io.vertx.rxjava3.kafka.client.producer.KafkaProducer#initTransactions} ()}
   * @return current KafkaWriteStream instance
   */
  public io.reactivex.rxjava3.core.Completable initTransactions() { 
    io.reactivex.rxjava3.core.Completable ret = rxInitTransactions();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Initializes the underlying kafka transactional producer. See {@link io.vertx.rxjava3.kafka.client.producer.KafkaProducer#initTransactions} ()}
   * @return current KafkaWriteStream instance
   */
  public io.reactivex.rxjava3.core.Completable rxInitTransactions() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.initTransactions(handler);
    });
  }

  /**
   * Starts a new kafka transaction. See {@link io.vertx.rxjava3.kafka.client.producer.KafkaProducer#beginTransaction}
   * @return current KafkaWriteStream instance
   */
  public io.reactivex.rxjava3.core.Completable beginTransaction() { 
    io.reactivex.rxjava3.core.Completable ret = rxBeginTransaction();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Starts a new kafka transaction. See {@link io.vertx.rxjava3.kafka.client.producer.KafkaProducer#beginTransaction}
   * @return current KafkaWriteStream instance
   */
  public io.reactivex.rxjava3.core.Completable rxBeginTransaction() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.beginTransaction(handler);
    });
  }

  /**
   * Commits the ongoing transaction. See {@link io.vertx.rxjava3.kafka.client.producer.KafkaProducer#commitTransaction}
   * @return current KafkaWriteStream instance
   */
  public io.reactivex.rxjava3.core.Completable commitTransaction() { 
    io.reactivex.rxjava3.core.Completable ret = rxCommitTransaction();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Commits the ongoing transaction. See {@link io.vertx.rxjava3.kafka.client.producer.KafkaProducer#commitTransaction}
   * @return current KafkaWriteStream instance
   */
  public io.reactivex.rxjava3.core.Completable rxCommitTransaction() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.commitTransaction(handler);
    });
  }

  /**
   * Aborts the ongoing transaction. See {@link org.apache.kafka.clients.producer.KafkaProducer}
   * @return current KafkaWriteStream instance
   */
  public io.reactivex.rxjava3.core.Completable abortTransaction() { 
    io.reactivex.rxjava3.core.Completable ret = rxAbortTransaction();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Aborts the ongoing transaction. See {@link org.apache.kafka.clients.producer.KafkaProducer}
   * @return current KafkaWriteStream instance
   */
  public io.reactivex.rxjava3.core.Completable rxAbortTransaction() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.abortTransaction(handler);
    });
  }

  public io.vertx.rxjava3.kafka.client.producer.KafkaProducer<K,V> exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava3.kafka.client.producer.KafkaProducer<K,V> setWriteQueueMaxSize(int i) { 
    delegate.setWriteQueueMaxSize(i);
    return this;
  }

  public io.vertx.rxjava3.kafka.client.producer.KafkaProducer<K,V> drainHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * Asynchronously write a record to a topic
   * @param record record to write
   * @return current KafkaWriteStream instance
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.kafka.client.producer.RecordMetadata> send(io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V> record) { 
    io.reactivex.rxjava3.core.Single<io.vertx.kafka.client.producer.RecordMetadata> ret = rxSend(record);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Asynchronously write a record to a topic
   * @param record record to write
   * @return current KafkaWriteStream instance
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.kafka.client.producer.RecordMetadata> rxSend(io.vertx.rxjava3.kafka.client.producer.KafkaProducerRecord<K,V> record) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.send(record.getDelegate(), handler);
    });
  }

  /**
   * Get the partition metadata for the give topic.
   * @param topic topic partition for which getting partitions info
   * @return current KafkaProducer instance
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<io.vertx.kafka.client.common.PartitionInfo>> partitionsFor(java.lang.String topic) { 
    io.reactivex.rxjava3.core.Single<java.util.List<io.vertx.kafka.client.common.PartitionInfo>> ret = rxPartitionsFor(topic);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Get the partition metadata for the give topic.
   * @param topic topic partition for which getting partitions info
   * @return current KafkaProducer instance
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<io.vertx.kafka.client.common.PartitionInfo>> rxPartitionsFor(java.lang.String topic) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.partitionsFor(topic, handler);
    });
  }

  /**
   * Invoking this method makes all buffered records immediately available to write
   * @return current KafkaProducer instance
   */
  public io.reactivex.rxjava3.core.Completable flush() { 
    io.reactivex.rxjava3.core.Completable ret = rxFlush();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Invoking this method makes all buffered records immediately available to write
   * @return current KafkaProducer instance
   */
  public io.reactivex.rxjava3.core.Completable rxFlush() { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.flush(completionHandler);
    });
  }

  /**
   * Close the producer
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable close() { 
    io.reactivex.rxjava3.core.Completable ret = rxClose();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Close the producer
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.close(completionHandler);
    });
  }

  /**
   * Close the producer
   * @param timeout timeout to wait for closing
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable close(long timeout) { 
    io.reactivex.rxjava3.core.Completable ret = rxClose(timeout);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Close the producer
   * @param timeout timeout to wait for closing
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxClose(long timeout) { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.close(timeout, completionHandler);
    });
  }

  public static <K,V> KafkaProducer<K,V> newInstance(io.vertx.kafka.client.producer.KafkaProducer arg) {
    return arg != null ? new KafkaProducer<K,V>(arg) : null;
  }

  public static <K,V> KafkaProducer<K,V> newInstance(io.vertx.kafka.client.producer.KafkaProducer arg, TypeArg<K> __typeArg_K, TypeArg<V> __typeArg_V) {
    return arg != null ? new KafkaProducer<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }

}
