/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.json.schema;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A Json-Schema holder.
 *
 * There are 2 kinds of Json-Schema's:
 *
 * <ul>
 *   <li>JSON Object based</li>
 *   <li>Boolean based</li>
 * </ul>
 *
 * This is a common interface to handle all kinds of schemas.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.json.schema.JsonSchema original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.json.schema.JsonSchema.class)
public class JsonSchema {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JsonSchema that = (JsonSchema) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<JsonSchema> __TYPE_ARG = new TypeArg<>(    obj -> new JsonSchema((io.vertx.json.schema.JsonSchema) obj),
    JsonSchema::getDelegate
  );

  private final io.vertx.json.schema.JsonSchema delegate;
  
  public JsonSchema(io.vertx.json.schema.JsonSchema delegate) {
    this.delegate = delegate;
  }

  public JsonSchema(Object delegate) {
    this.delegate = (io.vertx.json.schema.JsonSchema)delegate;
  }

  public io.vertx.json.schema.JsonSchema getDelegate() {
    return delegate;
  }


  /**
   * Factory method to create a {@link io.vertx.rxjava3.json.schema.JsonSchema} from a .
   * @param json a JSON Object.
   * @return a wrapper for the input object.
   */
  public static io.vertx.rxjava3.json.schema.JsonSchema of(io.vertx.core.json.JsonObject json) { 
    io.vertx.rxjava3.json.schema.JsonSchema ret = io.vertx.rxjava3.json.schema.JsonSchema.newInstance((io.vertx.json.schema.JsonSchema)io.vertx.json.schema.JsonSchema.of(json));
    return ret;
  }

  /**
   * Factory method to create a {@link io.vertx.rxjava3.json.schema.JsonSchema} from a .
   * @param id will force the given id as the schema $id.
   * @param json a JSON Object.
   * @return a wrapper for the input object.
   */
  public static io.vertx.rxjava3.json.schema.JsonSchema of(java.lang.String id, io.vertx.core.json.JsonObject json) { 
    io.vertx.rxjava3.json.schema.JsonSchema ret = io.vertx.rxjava3.json.schema.JsonSchema.newInstance((io.vertx.json.schema.JsonSchema)io.vertx.json.schema.JsonSchema.of(id, json));
    return ret;
  }

  /**
   * Factory method to create a {@link io.vertx.rxjava3.json.schema.JsonSchema} from a {@link java.lang.Boolean}.
   * @param bool a boolean.
   * @return a wrapper for the input object.
   */
  public static io.vertx.rxjava3.json.schema.JsonSchema of(boolean bool) { 
    io.vertx.rxjava3.json.schema.JsonSchema ret = io.vertx.rxjava3.json.schema.JsonSchema.newInstance((io.vertx.json.schema.JsonSchema)io.vertx.json.schema.JsonSchema.of(bool));
    return ret;
  }

  /**
   * Annotates the schema. An annotation is a extra key-value added to the schema that are not relevant for
   * validation but can be used to store pre-computed state.
   * @param key a key
   * @param value a value
   * @return 
   */
  public io.vertx.rxjava3.json.schema.JsonSchema annotate(java.lang.String key, java.lang.String value) { 
    delegate.annotate(key, value);
    return this;
  }

  /**
   * Get a type casted value by key.
   * @param key a key
   * @return the value or <code>null</code>
   */
  public <R> R get(java.lang.String key) { 
    R ret = (R) delegate.get(key);
    return ret;
  }

  /**
   * Get a type casted value by key. If the key is missing, then the fallback value is returned.
   * @param key a key
   * @param fallback fallback when key is not present
   * @return the value or <code>null</code>
   */
  public <R> R get(java.lang.String key, R fallback) { 
    R ret = (R) delegate.get(key, fallback);
    return ret;
  }

  /**
   * Checks if the given key is present in the schema object.
   * @param key a key
   * @return <code>true</code> if present
   */
  public boolean containsKey(java.lang.String key) { 
    boolean ret = delegate.containsKey(key);
    return ret;
  }

  /**
   * Returns the field names on the underlying object.
   * @return field names
   */
  public java.util.Set<java.lang.String> fieldNames() { 
    java.util.Set<java.lang.String> ret = delegate.fieldNames();
    return ret;
  }

  /**
   * Tries to resolve all internal references. External references are not resolved.
   *
   * The result is an object where all references have been resolved. Resolution of references is shallow.
   * This should normally not be a problem for this use case.
   * @return a new  representing the schema with <code>$ref</code>s replaced by their value.
   */
  public io.vertx.core.json.JsonObject resolve() { 
    io.vertx.core.json.JsonObject ret = delegate.resolve();
    return ret;
  }

  public static JsonSchema newInstance(io.vertx.json.schema.JsonSchema arg) {
    return arg != null ? new JsonSchema(arg) : null;
  }

}
