/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.httpproxy;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A controller for proxy interception.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.httpproxy.ProxyContext original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.httpproxy.ProxyContext.class)
public class ProxyContext {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProxyContext that = (ProxyContext) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ProxyContext> __TYPE_ARG = new TypeArg<>(    obj -> new ProxyContext((io.vertx.httpproxy.ProxyContext) obj),
    ProxyContext::getDelegate
  );

  private final io.vertx.httpproxy.ProxyContext delegate;
  
  public ProxyContext(io.vertx.httpproxy.ProxyContext delegate) {
    this.delegate = delegate;
  }

  public ProxyContext(Object delegate) {
    this.delegate = (io.vertx.httpproxy.ProxyContext)delegate;
  }

  public io.vertx.httpproxy.ProxyContext getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava3.httpproxy.ProxyResponse> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.httpproxy.ProxyResponse>(o1 -> io.vertx.rxjava3.httpproxy.ProxyResponse.newInstance((io.vertx.httpproxy.ProxyResponse)o1), o1 -> o1.getDelegate());

  /**
   * @return the proxy request
   */
  public io.vertx.rxjava3.httpproxy.ProxyRequest request() { 
    io.vertx.rxjava3.httpproxy.ProxyRequest ret = io.vertx.rxjava3.httpproxy.ProxyRequest.newInstance((io.vertx.httpproxy.ProxyRequest)delegate.request());
    return ret;
  }

  /**
   * @return the proxy response, it might be <code>null</code> if the response has not been sent
   */
  public io.vertx.rxjava3.httpproxy.ProxyResponse response() { 
    io.vertx.rxjava3.httpproxy.ProxyResponse ret = io.vertx.rxjava3.httpproxy.ProxyResponse.newInstance((io.vertx.httpproxy.ProxyResponse)delegate.response());
    return ret;
  }

  /**
   *
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.httpproxy.ProxyResponse> sendRequest() { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.httpproxy.ProxyResponse> ret = rxSendRequest();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   *
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.httpproxy.ProxyResponse> rxSendRequest() { 
    return AsyncResultSingle.toSingle(delegate.sendRequest(), __value -> io.vertx.rxjava3.httpproxy.ProxyResponse.newInstance((io.vertx.httpproxy.ProxyResponse)__value));
  }

  /**
   *
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable sendResponse() { 
    io.reactivex.rxjava3.core.Completable ret = rxSendResponse();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   *
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxSendResponse() { 
    return AsyncResultCompletable.toCompletable(delegate.sendResponse());
  }

  /**
   * Attach a payload to the context
   * @param name the payload name
   * @param value any payload value
   */
  public void set(java.lang.String name, java.lang.Object value) { 
    delegate.set(name, value);
  }

  /**
   * Get a payload attached to this context
   * @param name the payload name
   * @param type the expected payload type
   * @return the attached payload
   */
  public <T> T get(java.lang.String name, java.lang.Class<T> type) { 
    T ret = (T)TypeArg.of(type).wrap(delegate.get(name, io.vertx.lang.rxjava3.Helper.unwrap(type)));
    return ret;
  }

  public static ProxyContext newInstance(io.vertx.httpproxy.ProxyContext arg) {
    return arg != null ? new ProxyContext(arg) : null;
  }

}
