/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.templ.pebble;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A template engine that uses the Pebble library.
 * The {@link io.vertx.rxjava3.ext.web.common.template.TemplateEngine#unwrap} shall return an object of class 
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.templ.pebble.PebbleTemplateEngine original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.templ.pebble.PebbleTemplateEngine.class)
public class PebbleTemplateEngine extends io.vertx.rxjava3.ext.web.common.template.TemplateEngine {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PebbleTemplateEngine that = (PebbleTemplateEngine) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<PebbleTemplateEngine> __TYPE_ARG = new TypeArg<>(    obj -> new PebbleTemplateEngine((io.vertx.ext.web.templ.pebble.PebbleTemplateEngine) obj),
    PebbleTemplateEngine::getDelegate
  );

  private final io.vertx.ext.web.templ.pebble.PebbleTemplateEngine delegate;
  
  public PebbleTemplateEngine(io.vertx.ext.web.templ.pebble.PebbleTemplateEngine delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public PebbleTemplateEngine(Object delegate) {
    super((io.vertx.ext.web.templ.pebble.PebbleTemplateEngine)delegate);
    this.delegate = (io.vertx.ext.web.templ.pebble.PebbleTemplateEngine)delegate;
  }

  public io.vertx.ext.web.templ.pebble.PebbleTemplateEngine getDelegate() {
    return delegate;
  }

  /**
   * Create a template engine using defaults
   * @param vertx 
   * @return the engine
   */
  public static io.vertx.rxjava3.ext.web.templ.pebble.PebbleTemplateEngine create(io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.ext.web.templ.pebble.PebbleTemplateEngine ret = io.vertx.rxjava3.ext.web.templ.pebble.PebbleTemplateEngine.newInstance((io.vertx.ext.web.templ.pebble.PebbleTemplateEngine)io.vertx.ext.web.templ.pebble.PebbleTemplateEngine.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a template engine using defaults
   * @param vertx 
   * @param extension 
   * @return the engine
   */
  public static io.vertx.rxjava3.ext.web.templ.pebble.PebbleTemplateEngine create(io.vertx.rxjava3.core.Vertx vertx, java.lang.String extension) { 
    io.vertx.rxjava3.ext.web.templ.pebble.PebbleTemplateEngine ret = io.vertx.rxjava3.ext.web.templ.pebble.PebbleTemplateEngine.newInstance((io.vertx.ext.web.templ.pebble.PebbleTemplateEngine)io.vertx.ext.web.templ.pebble.PebbleTemplateEngine.create(vertx.getDelegate(), extension));
    return ret;
  }

  /**
   * Create a template engine using a custom Builder, e.g. if
   * you want use custom Filters or Functions.
   * @param vertx 
   * @param engine 
   * @return the engine
   */
  public static io.vertx.rxjava3.ext.web.templ.pebble.PebbleTemplateEngine create(io.vertx.rxjava3.core.Vertx vertx, com.mitchellbosecke.pebble.PebbleEngine engine) { 
    io.vertx.rxjava3.ext.web.templ.pebble.PebbleTemplateEngine ret = io.vertx.rxjava3.ext.web.templ.pebble.PebbleTemplateEngine.newInstance((io.vertx.ext.web.templ.pebble.PebbleTemplateEngine)io.vertx.ext.web.templ.pebble.PebbleTemplateEngine.create(vertx.getDelegate(), engine));
    return ret;
  }

  /**
   * Create a template engine using a custom Builder, e.g. if
   * you want use custom Filters or Functions.
   * @param vertx 
   * @param extension 
   * @param engine 
   * @return the engine
   */
  public static io.vertx.rxjava3.ext.web.templ.pebble.PebbleTemplateEngine create(io.vertx.rxjava3.core.Vertx vertx, java.lang.String extension, com.mitchellbosecke.pebble.PebbleEngine engine) { 
    io.vertx.rxjava3.ext.web.templ.pebble.PebbleTemplateEngine ret = io.vertx.rxjava3.ext.web.templ.pebble.PebbleTemplateEngine.newInstance((io.vertx.ext.web.templ.pebble.PebbleTemplateEngine)io.vertx.ext.web.templ.pebble.PebbleTemplateEngine.create(vertx.getDelegate(), extension, engine));
    return ret;
  }

  /**
   * Default template extension
   */
  public static final java.lang.String DEFAULT_TEMPLATE_EXTENSION = io.vertx.ext.web.templ.pebble.PebbleTemplateEngine.DEFAULT_TEMPLATE_EXTENSION;
  public static PebbleTemplateEngine newInstance(io.vertx.ext.web.templ.pebble.PebbleTemplateEngine arg) {
    return arg != null ? new PebbleTemplateEngine(arg) : null;
  }

}
