/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.sstore.cookie;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A SessionStore that uses a Cookie to store the session data. All data is stored in
 * plain sight and signed using a HMAC using the given secret.
 *
 * The signature ensures that the cookie payload is not tampered when returning from
 * the user agent (browser) back to the server.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.sstore.cookie.CookieSessionStore original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.sstore.cookie.CookieSessionStore.class)
public class CookieSessionStore extends io.vertx.rxjava3.ext.web.sstore.SessionStore {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CookieSessionStore that = (CookieSessionStore) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<CookieSessionStore> __TYPE_ARG = new TypeArg<>(    obj -> new CookieSessionStore((io.vertx.ext.web.sstore.cookie.CookieSessionStore) obj),
    CookieSessionStore::getDelegate
  );

  private final io.vertx.ext.web.sstore.cookie.CookieSessionStore delegate;
  
  public CookieSessionStore(io.vertx.ext.web.sstore.cookie.CookieSessionStore delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public CookieSessionStore(Object delegate) {
    super((io.vertx.ext.web.sstore.cookie.CookieSessionStore)delegate);
    this.delegate = (io.vertx.ext.web.sstore.cookie.CookieSessionStore)delegate;
  }

  public io.vertx.ext.web.sstore.cookie.CookieSessionStore getDelegate() {
    return delegate;
  }

  /**
   * Creates a CookieSessionStore.
   *
   * Cookie data will be signed using the given secret. The secret as the name
   * reflects, should never leave the server, otherwise user agents could tamper
   * with the payload.
   * @param vertx a vert.x instance
   * @param secret a secret to feed the HMAC algorithm
   * @return the store
   */
  public static io.vertx.rxjava3.ext.web.sstore.cookie.CookieSessionStore create(io.vertx.rxjava3.core.Vertx vertx, java.lang.String secret) { 
    io.vertx.rxjava3.ext.web.sstore.cookie.CookieSessionStore ret = io.vertx.rxjava3.ext.web.sstore.cookie.CookieSessionStore.newInstance((io.vertx.ext.web.sstore.cookie.CookieSessionStore)io.vertx.ext.web.sstore.cookie.CookieSessionStore.create(vertx.getDelegate(), secret));
    return ret;
  }

  /**
   * Default length for a session id.
   * More info: https://www.owasp.org/index.php/Session_Management_Cheat_Sheet
   */
  public static final int DEFAULT_SESSIONID_LENGTH = io.vertx.ext.web.sstore.cookie.CookieSessionStore.DEFAULT_SESSIONID_LENGTH;
  public static CookieSessionStore newInstance(io.vertx.ext.web.sstore.cookie.CookieSessionStore arg) {
    return arg != null ? new CookieSessionStore(arg) : null;
  }

}
