/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.handler.graphql.ws;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A handler for the <a href="https://github.com/enisdenjo/graphql-ws/blob/master/PROTOCOL.md">GraphQL over WebSocket Protocol</a>.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandler.class)
public class GraphQLWSHandler implements io.vertx.rxjava3.ext.web.handler.ProtocolUpgradeHandler, Handler<io.vertx.rxjava3.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GraphQLWSHandler that = (GraphQLWSHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GraphQLWSHandler> __TYPE_ARG = new TypeArg<>(    obj -> new GraphQLWSHandler((io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandler) obj),
    GraphQLWSHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandler delegate;
  
  public GraphQLWSHandler(io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandler delegate) {
    this.delegate = delegate;
  }

  public GraphQLWSHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandler)delegate;
  }

  public io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.rxjava3.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Customize the connection init .
   * This handler will be called when the  message is received.
   * @param connectionInitHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.ext.web.handler.graphql.ws.GraphQLWSHandler connectionInitHandler(io.vertx.core.Handler<io.vertx.rxjava3.ext.web.handler.graphql.ws.ConnectionInitEvent> connectionInitHandler) { 
    delegate.connectionInitHandler(new io.vertx.lang.rx.DelegatingHandler<>(connectionInitHandler, event -> io.vertx.rxjava3.ext.web.handler.graphql.ws.ConnectionInitEvent.newInstance((io.vertx.ext.web.handler.graphql.ws.ConnectionInitEvent)event)));
    return this;
  }

  /**
   * Set a callback to invoke before executing a GraphQL query.
   * @param config the callback to invoke
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.ext.web.handler.graphql.ws.GraphQLWSHandler beforeExecute(io.vertx.core.Handler<io.vertx.rxjava3.ext.web.handler.graphql.ExecutionInputBuilderWithContext<io.vertx.rxjava3.ext.web.handler.graphql.ws.Message>> config) { 
    delegate.beforeExecute(new io.vertx.lang.rx.DelegatingHandler<>(config, event -> io.vertx.rxjava3.ext.web.handler.graphql.ExecutionInputBuilderWithContext.newInstance((io.vertx.ext.web.handler.graphql.ExecutionInputBuilderWithContext)event, new TypeArg<io.vertx.rxjava3.ext.web.handler.graphql.ws.Message>(o0 -> io.vertx.rxjava3.ext.web.handler.graphql.ws.Message.newInstance((io.vertx.ext.web.handler.graphql.ws.Message)o0), o0 -> o0.getDelegate()))));
    return this;
  }

  /**
   * Create a new {@link io.vertx.rxjava3.ext.web.handler.graphql.ws.GraphQLWSHandler} that will use the provided <code>graphQL</code> object to execute requests.
   * <p>
   * The handler will be configured with the default {@link io.vertx.ext.web.handler.graphql.ws.GraphQLWSOptions}.
   * @param graphQL 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.handler.graphql.ws.GraphQLWSHandler create(graphql.GraphQL graphQL) { 
    io.vertx.rxjava3.ext.web.handler.graphql.ws.GraphQLWSHandler ret = io.vertx.rxjava3.ext.web.handler.graphql.ws.GraphQLWSHandler.newInstance((io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandler)io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandler.create(graphQL));
    return ret;
  }

  /**
   * Create a new {@link io.vertx.rxjava3.ext.web.handler.graphql.ws.GraphQLWSHandler} that will use the provided <code>graphQL</code> object to execute requests.
   * <p>
   * The handler will be configured with the given <code>options</code>.
   * @param graphQL 
   * @param options options for configuring the {@link io.vertx.ext.web.handler.graphql.ws.GraphQLWSOptions}
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.handler.graphql.ws.GraphQLWSHandler create(graphql.GraphQL graphQL, io.vertx.ext.web.handler.graphql.ws.GraphQLWSOptions options) { 
    io.vertx.rxjava3.ext.web.handler.graphql.ws.GraphQLWSHandler ret = io.vertx.rxjava3.ext.web.handler.graphql.ws.GraphQLWSHandler.newInstance((io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandler)io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandler.create(graphQL, options));
    return ret;
  }

  public static GraphQLWSHandler newInstance(io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandler arg) {
    return arg != null ? new GraphQLWSHandler(arg) : null;
  }

}
