/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.handler.graphql.dataloader;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A  that works well with Vert.x callback and  based APIs.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.graphql.dataloader.VertxMappedBatchLoader original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.graphql.dataloader.VertxMappedBatchLoader.class)
public class VertxMappedBatchLoader<K,V> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    VertxMappedBatchLoader that = (VertxMappedBatchLoader) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<VertxMappedBatchLoader> __TYPE_ARG = new TypeArg<>(    obj -> new VertxMappedBatchLoader((io.vertx.ext.web.handler.graphql.dataloader.VertxMappedBatchLoader) obj),
    VertxMappedBatchLoader::getDelegate
  );

  private final io.vertx.ext.web.handler.graphql.dataloader.VertxMappedBatchLoader<K,V> delegate;
  public final TypeArg<K> __typeArg_0;
  public final TypeArg<V> __typeArg_1;
  
  public VertxMappedBatchLoader(io.vertx.ext.web.handler.graphql.dataloader.VertxMappedBatchLoader delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();    this.__typeArg_1 = TypeArg.unknown();  }

  public VertxMappedBatchLoader(Object delegate, TypeArg<K> typeArg_0, TypeArg<V> typeArg_1) {
    this.delegate = (io.vertx.ext.web.handler.graphql.dataloader.VertxMappedBatchLoader)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  public io.vertx.ext.web.handler.graphql.dataloader.VertxMappedBatchLoader getDelegate() {
    return delegate;
  }

  public static <K,V> VertxMappedBatchLoader<K,V> newInstance(io.vertx.ext.web.handler.graphql.dataloader.VertxMappedBatchLoader arg) {
    return arg != null ? new VertxMappedBatchLoader<K,V>(arg) : null;
  }

  public static <K,V> VertxMappedBatchLoader<K,V> newInstance(io.vertx.ext.web.handler.graphql.dataloader.VertxMappedBatchLoader arg, TypeArg<K> __typeArg_K, TypeArg<V> __typeArg_V) {
    return arg != null ? new VertxMappedBatchLoader<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }

}
