/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.api.contract;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Base interface for HTTP request validation with API specification
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.api.contract.HTTPOperationRequestValidationHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.api.contract.HTTPOperationRequestValidationHandler.class)
public interface HTTPOperationRequestValidationHandler extends io.vertx.rxjava3.ext.web.api.validation.ValidationHandler, Handler<io.vertx.rxjava3.ext.web.RoutingContext> {

  io.vertx.ext.web.api.contract.HTTPOperationRequestValidationHandler getDelegate();

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  @Deprecated()
  public void handle(io.vertx.rxjava3.ext.web.RoutingContext event);

  /**
   * Function that parse the operation specification and generate validation rules
   */
  @Deprecated()
  public void parseOperationSpec();

  public static HTTPOperationRequestValidationHandler newInstance(io.vertx.ext.web.api.contract.HTTPOperationRequestValidationHandler arg) {
    return arg != null ? new HTTPOperationRequestValidationHandlerImpl(arg) : null;
  }

}

class HTTPOperationRequestValidationHandlerImpl implements HTTPOperationRequestValidationHandler {
  private final io.vertx.ext.web.api.contract.HTTPOperationRequestValidationHandler delegate;
  
  public HTTPOperationRequestValidationHandlerImpl(io.vertx.ext.web.api.contract.HTTPOperationRequestValidationHandler delegate) {
    this.delegate = delegate;
  }

  public HTTPOperationRequestValidationHandlerImpl(Object delegate) {
    this.delegate = (io.vertx.ext.web.api.contract.HTTPOperationRequestValidationHandler)delegate;
  }

  public io.vertx.ext.web.api.contract.HTTPOperationRequestValidationHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  @Deprecated()
  public void handle(io.vertx.rxjava3.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Function that parse the operation specification and generate validation rules
   */
  @Deprecated()
  public void parseOperationSpec() { 
    delegate.parseOperationSpec();
  }

}
