/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.api;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Container for request parameters
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.api.RequestParameters original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.api.RequestParameters.class)
public class RequestParameters {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RequestParameters that = (RequestParameters) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RequestParameters> __TYPE_ARG = new TypeArg<>(    obj -> new RequestParameters((io.vertx.ext.web.api.RequestParameters) obj),
    RequestParameters::getDelegate
  );

  private final io.vertx.ext.web.api.RequestParameters delegate;
  
  public RequestParameters(io.vertx.ext.web.api.RequestParameters delegate) {
    this.delegate = delegate;
  }

  public RequestParameters(Object delegate) {
    this.delegate = (io.vertx.ext.web.api.RequestParameters)delegate;
  }

  public io.vertx.ext.web.api.RequestParameters getDelegate() {
    return delegate;
  }


  /**
   * Get list of all parameter names inside path
   * @return 
   */
  @Deprecated()
  public java.util.List<java.lang.String> pathParametersNames() { 
    java.util.List<java.lang.String> ret = delegate.pathParametersNames();
    return ret;
  }

  /**
   * Get path parameter by name
   * @param name Parameter name
   * @return 
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.RequestParameter pathParameter(java.lang.String name) { 
    io.vertx.rxjava3.ext.web.api.RequestParameter ret = io.vertx.rxjava3.ext.web.api.RequestParameter.newInstance((io.vertx.ext.web.api.RequestParameter)delegate.pathParameter(name));
    return ret;
  }

  /**
   * Get list of all parameter names inside query
   * @return 
   */
  @Deprecated()
  public java.util.List<java.lang.String> queryParametersNames() { 
    java.util.List<java.lang.String> ret = delegate.queryParametersNames();
    return ret;
  }

  /**
   * Get query parameter by name
   * @param name Parameter name
   * @return 
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.RequestParameter queryParameter(java.lang.String name) { 
    io.vertx.rxjava3.ext.web.api.RequestParameter ret = io.vertx.rxjava3.ext.web.api.RequestParameter.newInstance((io.vertx.ext.web.api.RequestParameter)delegate.queryParameter(name));
    return ret;
  }

  /**
   * Get list of all parameter names inside header
   * @return 
   */
  @Deprecated()
  public java.util.List<java.lang.String> headerParametersNames() { 
    java.util.List<java.lang.String> ret = delegate.headerParametersNames();
    return ret;
  }

  /**
   * Get header parameter by name
   * @param name Parameter name
   * @return 
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.RequestParameter headerParameter(java.lang.String name) { 
    io.vertx.rxjava3.ext.web.api.RequestParameter ret = io.vertx.rxjava3.ext.web.api.RequestParameter.newInstance((io.vertx.ext.web.api.RequestParameter)delegate.headerParameter(name));
    return ret;
  }

  /**
   * Get list of all parameter names inside cookie
   * @return 
   */
  @Deprecated()
  public java.util.List<java.lang.String> cookieParametersNames() { 
    java.util.List<java.lang.String> ret = delegate.cookieParametersNames();
    return ret;
  }

  /**
   * Get cookie parameter by name
   * @param name Parameter name
   * @return 
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.RequestParameter cookieParameter(java.lang.String name) { 
    io.vertx.rxjava3.ext.web.api.RequestParameter ret = io.vertx.rxjava3.ext.web.api.RequestParameter.newInstance((io.vertx.ext.web.api.RequestParameter)delegate.cookieParameter(name));
    return ret;
  }

  /**
   * Get list of all parameter names inside body form
   * @return 
   */
  @Deprecated()
  public java.util.List<java.lang.String> formParametersNames() { 
    java.util.List<java.lang.String> ret = delegate.formParametersNames();
    return ret;
  }

  /**
   * Get form parameter by name
   * @param name Parameter name
   * @return 
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.RequestParameter formParameter(java.lang.String name) { 
    io.vertx.rxjava3.ext.web.api.RequestParameter ret = io.vertx.rxjava3.ext.web.api.RequestParameter.newInstance((io.vertx.ext.web.api.RequestParameter)delegate.formParameter(name));
    return ret;
  }

  /**
   * Return request body
   * @return 
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.RequestParameter body() { 
    io.vertx.rxjava3.ext.web.api.RequestParameter ret = io.vertx.rxjava3.ext.web.api.RequestParameter.newInstance((io.vertx.ext.web.api.RequestParameter)delegate.body());
    return ret;
  }

  /**
   * This method converts RequestParameters in an unique JsonObject with 6 fields: cookie, path, query, header, form, body<br/>
   *
   * cookie, path, query, header, form are JsonObject where keys are param names and values are param values, while body depends on body's shape and may not exist
   * @return 
   */
  @Deprecated()
  public io.vertx.core.json.JsonObject toJson() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.core.json.JsonObject ret = delegate.toJson();
    cached_0 = ret;
    return ret;
  }

  private io.vertx.core.json.JsonObject cached_0;
  public static RequestParameters newInstance(io.vertx.ext.web.api.RequestParameters arg) {
    return arg != null ? new RequestParameters(arg) : null;
  }

}
