/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.shell.session;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A shell session.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.session.Session original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.shell.session.Session.class)
public class Session {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Session that = (Session) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Session> __TYPE_ARG = new TypeArg<>(    obj -> new Session((io.vertx.ext.shell.session.Session) obj),
    Session::getDelegate
  );

  private final io.vertx.ext.shell.session.Session delegate;
  
  public Session(io.vertx.ext.shell.session.Session delegate) {
    this.delegate = delegate;
  }

  public Session(Object delegate) {
    this.delegate = (io.vertx.ext.shell.session.Session)delegate;
  }

  public io.vertx.ext.shell.session.Session getDelegate() {
    return delegate;
  }

  /**
   * Create a new empty session.
   * @return the created session
   */
  public static io.vertx.rxjava3.ext.shell.session.Session create() { 
    io.vertx.rxjava3.ext.shell.session.Session ret = io.vertx.rxjava3.ext.shell.session.Session.newInstance((io.vertx.ext.shell.session.Session)io.vertx.ext.shell.session.Session.create());
    return ret;
  }

  /**
   * Put some data in a session
   * @param key the key for the data
   * @param obj the data
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.ext.shell.session.Session put(java.lang.String key, java.lang.Object obj) { 
    delegate.put(key, obj);
    return this;
  }

  /**
   * Get some data from the session
   * @param key the key of the data
   * @return the data
   */
  public <T> T get(java.lang.String key) { 
    T ret = (T) delegate.get(key);
    return ret;
  }

  /**
   * Remove some data from the session
   * @param key the key of the data
   * @return the data that was there or null if none there
   */
  public <T> T remove(java.lang.String key) { 
    T ret = (T) delegate.remove(key);
    return ret;
  }

  public static Session newInstance(io.vertx.ext.shell.session.Session arg) {
    return arg != null ? new Session(arg) : null;
  }

}
