/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.mail;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * SMTP mail client for Vert.x
 * <p>
 * A simple asynchronous API for sending mails from Vert.x applications
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.mail.MailClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.mail.MailClient.class)
public class MailClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MailClient that = (MailClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MailClient> __TYPE_ARG = new TypeArg<>(    obj -> new MailClient((io.vertx.ext.mail.MailClient) obj),
    MailClient::getDelegate
  );

  private final io.vertx.ext.mail.MailClient delegate;
  
  public MailClient(io.vertx.ext.mail.MailClient delegate) {
    this.delegate = delegate;
  }

  public MailClient(Object delegate) {
    this.delegate = (io.vertx.ext.mail.MailClient)delegate;
  }

  public io.vertx.ext.mail.MailClient getDelegate() {
    return delegate;
  }

  /**
   * Create a non shared instance of the mail client.
   * @param vertx the Vertx instance the operation will be run in
   * @param config MailConfig configuration to be used for sending mails
   * @return MailClient instance that can then be used to send multiple mails
   */
  public static io.vertx.rxjava3.ext.mail.MailClient create(io.vertx.rxjava3.core.Vertx vertx, io.vertx.ext.mail.MailConfig config) { 
    io.vertx.rxjava3.ext.mail.MailClient ret = io.vertx.rxjava3.ext.mail.MailClient.newInstance((io.vertx.ext.mail.MailClient)io.vertx.ext.mail.MailClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Create a Mail client which shares its connection pool with any other Mail clients created with the same
   * pool name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @param poolName the pool name
   * @return the client
   */
  public static io.vertx.rxjava3.ext.mail.MailClient createShared(io.vertx.rxjava3.core.Vertx vertx, io.vertx.ext.mail.MailConfig config, java.lang.String poolName) { 
    io.vertx.rxjava3.ext.mail.MailClient ret = io.vertx.rxjava3.ext.mail.MailClient.newInstance((io.vertx.ext.mail.MailClient)io.vertx.ext.mail.MailClient.createShared(vertx.getDelegate(), config, poolName));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.ext.mail.MailClient#createShared} but with the default pool name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static io.vertx.rxjava3.ext.mail.MailClient createShared(io.vertx.rxjava3.core.Vertx vertx, io.vertx.ext.mail.MailConfig config) { 
    io.vertx.rxjava3.ext.mail.MailClient ret = io.vertx.rxjava3.ext.mail.MailClient.newInstance((io.vertx.ext.mail.MailClient)io.vertx.ext.mail.MailClient.createShared(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * send a single mail via MailClient
   * @param email MailMessage object containing the mail text, from/to, attachments etc
   * @return this MailClient instance so the method can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.ext.mail.MailResult> sendMail(io.vertx.ext.mail.MailMessage email) { 
    io.reactivex.rxjava3.core.Single<io.vertx.ext.mail.MailResult> ret = rxSendMail(email);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * send a single mail via MailClient
   * @param email MailMessage object containing the mail text, from/to, attachments etc
   * @return this MailClient instance so the method can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.ext.mail.MailResult> rxSendMail(io.vertx.ext.mail.MailMessage email) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.sendMail(email, resultHandler);
    });
  }

  /**
   * close the MailClient
   */
  public void close() { 
    delegate.close();
  }

  /**
   * The name of the default pool
   */
  public static final java.lang.String DEFAULT_POOL_NAME = io.vertx.ext.mail.MailClient.DEFAULT_POOL_NAME;
  public static MailClient newInstance(io.vertx.ext.mail.MailClient arg) {
    return arg != null ? new MailClient(arg) : null;
  }

}
