/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.auth.htdigest;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An extension of AuthProvider which is using .htdigest file as store
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.htdigest.HtdigestAuth original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.htdigest.HtdigestAuth.class)
public class HtdigestAuth extends io.vertx.rxjava3.ext.auth.authentication.AuthenticationProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HtdigestAuth that = (HtdigestAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HtdigestAuth> __TYPE_ARG = new TypeArg<>(    obj -> new HtdigestAuth((io.vertx.ext.auth.htdigest.HtdigestAuth) obj),
    HtdigestAuth::getDelegate
  );

  private final io.vertx.ext.auth.htdigest.HtdigestAuth delegate;
  
  public HtdigestAuth(io.vertx.ext.auth.htdigest.HtdigestAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public HtdigestAuth(Object delegate) {
    super((io.vertx.ext.auth.htdigest.HtdigestAuth)delegate);
    this.delegate = (io.vertx.ext.auth.htdigest.HtdigestAuth)delegate;
  }

  public io.vertx.ext.auth.htdigest.HtdigestAuth getDelegate() {
    return delegate;
  }

  /**
   * Creates an instance of HtdigestAuth.
   * @param vertx 
   * @return the created instance of {@link io.vertx.rxjava3.ext.auth.htdigest.HtdigestAuth}s
   */
  public static io.vertx.rxjava3.ext.auth.htdigest.HtdigestAuth create(io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.ext.auth.htdigest.HtdigestAuth ret = io.vertx.rxjava3.ext.auth.htdigest.HtdigestAuth.newInstance((io.vertx.ext.auth.htdigest.HtdigestAuth)io.vertx.ext.auth.htdigest.HtdigestAuth.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Creates an instance of HtdigestAuth by using the given htfile file.
   * @param vertx 
   * @param htfile the existing htfile.
   * @return the created instance of {@link io.vertx.rxjava3.ext.auth.htdigest.HtdigestAuth}s
   */
  public static io.vertx.rxjava3.ext.auth.htdigest.HtdigestAuth create(io.vertx.rxjava3.core.Vertx vertx, java.lang.String htfile) { 
    io.vertx.rxjava3.ext.auth.htdigest.HtdigestAuth ret = io.vertx.rxjava3.ext.auth.htdigest.HtdigestAuth.newInstance((io.vertx.ext.auth.htdigest.HtdigestAuth)io.vertx.ext.auth.htdigest.HtdigestAuth.create(vertx.getDelegate(), htfile));
    return ret;
  }

  /**
   * Return the currently used realm
   * @return the realm
   */
  public java.lang.String realm() { 
    java.lang.String ret = delegate.realm();
    return ret;
  }

  /**
   * The property name to be used to set the name of the collection inside the config
   */
  public static final java.lang.String HTDIGEST_FILE = io.vertx.ext.auth.htdigest.HtdigestAuth.HTDIGEST_FILE;
  public static HtdigestAuth newInstance(io.vertx.ext.auth.htdigest.HtdigestAuth arg) {
    return arg != null ? new HtdigestAuth(arg) : null;
  }

}
