/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.auth.authorization;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Interface representing any kind of authorization such as:
 * <ul>
 *   <li>Role based authorization
 *   <li>Permission based authorization
 *   <li>Logical authorization (AND, OR, NOT)
 *   <li>Time based authorization (ie: allow access the last 5 days of the month, from 8am till 10am, etc.)
 *   <li>Context based authorization (ie: allow access if the ip address is 'xxx.xxx.xxx.xxx')
 *   <li>Custom based authorization (ie: based on a script or hard-coded code specific to an application)
 *   <li>etc.
 * </ul>
 * The following implementations are provided out of the box:
 * <ul>
 *   <li>{@link io.vertx.rxjava3.ext.auth.authorization.AndAuthorization}
 *   <li>{@link io.vertx.rxjava3.ext.auth.authorization.NotAuthorization}
 *   <li>{@link io.vertx.rxjava3.ext.auth.authorization.OrAuthorization}
 *   <li>{@link io.vertx.rxjava3.ext.auth.authorization.PermissionBasedAuthorization}
 *   <li>{@link io.vertx.rxjava3.ext.auth.authorization.RoleBasedAuthorization}
 *   <li>{@link io.vertx.rxjava3.ext.auth.authorization.WildcardPermissionBasedAuthorization}
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.authorization.Authorization original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.authorization.Authorization.class)
public class Authorization {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Authorization that = (Authorization) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Authorization> __TYPE_ARG = new TypeArg<>(    obj -> new Authorization((io.vertx.ext.auth.authorization.Authorization) obj),
    Authorization::getDelegate
  );

  private final io.vertx.ext.auth.authorization.Authorization delegate;
  
  public Authorization(io.vertx.ext.auth.authorization.Authorization delegate) {
    this.delegate = delegate;
  }

  public Authorization(Object delegate) {
    this.delegate = (io.vertx.ext.auth.authorization.Authorization)delegate;
  }

  public io.vertx.ext.auth.authorization.Authorization getDelegate() {
    return delegate;
  }

  /**
   * this methods verifies whether or not the authorization match the specified
   * context.
   * @param context the context.
   * @return true if there's a match.
   */
  public boolean match(io.vertx.rxjava3.ext.auth.authorization.AuthorizationContext context) { 
    boolean ret = delegate.match(context.getDelegate());
    return ret;
  }

  /**
   * this method verifies whether or not the authorization implies the specified
   * authorization.
   * </br>Note that it doesn't always mean an exact match. For instance,
   * in the case of a {@link io.vertx.rxjava3.ext.auth.authorization.WildcardPermissionBasedAuthorization}, this method
   * may return true even if the permissions are different
   * </br>WildcardPermissionBasedAuthorization.create('*').verify(WildcardPermissionBasedAuthorization.create('anypermission'))
   * would return true
   * @param authorization the authorization.
   * @return true if implies the argument.
   */
  public boolean verify(io.vertx.rxjava3.ext.auth.authorization.Authorization authorization) { 
    boolean ret = delegate.verify(authorization.getDelegate());
    return ret;
  }

  /**
   * this methods verifies whether or not the authorization match the specified
   * user. Internally a basic context is created with the user and the method
   * delegates to {@link io.vertx.rxjava3.ext.auth.authorization.Authorization#match}
   * @param user the user.
   * @return true if there's a match
   */
  public boolean match(io.vertx.rxjava3.ext.auth.User user) { 
    boolean ret = delegate.match(user.getDelegate());
    return ret;
  }

  public static Authorization newInstance(io.vertx.ext.auth.authorization.Authorization arg) {
    return arg != null ? new Authorization(arg) : null;
  }

}
