/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.core.shareddata;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An asynchronous exclusive lock which can be obtained from any node in the cluster.
 * <p>
 * When the lock is obtained, no-one else in the cluster can obtain the lock with the same name until the lock
 * is released.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.Lock original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.shareddata.Lock.class)
public class Lock {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Lock that = (Lock) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Lock> __TYPE_ARG = new TypeArg<>(    obj -> new Lock((io.vertx.core.shareddata.Lock) obj),
    Lock::getDelegate
  );

  private final io.vertx.core.shareddata.Lock delegate;
  
  public Lock(io.vertx.core.shareddata.Lock delegate) {
    this.delegate = delegate;
  }

  public Lock(Object delegate) {
    this.delegate = (io.vertx.core.shareddata.Lock)delegate;
  }

  public io.vertx.core.shareddata.Lock getDelegate() {
    return delegate;
  }

  /**
   * Release the lock. Once the lock is released another will be able to obtain the lock.
   */
  public void release() { 
    delegate.release();
  }

  public static Lock newInstance(io.vertx.core.shareddata.Lock arg) {
    return arg != null ? new Lock(arg) : null;
  }

}
