/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.core.file;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A lock on a region of an {@link io.vertx.rxjava3.core.file.AsyncFile}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.file.AsyncFileLock original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.file.AsyncFileLock.class)
public class AsyncFileLock {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AsyncFileLock that = (AsyncFileLock) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AsyncFileLock> __TYPE_ARG = new TypeArg<>(    obj -> new AsyncFileLock((io.vertx.core.file.AsyncFileLock) obj),
    AsyncFileLock::getDelegate
  );

  private final io.vertx.core.file.AsyncFileLock delegate;
  
  public AsyncFileLock(io.vertx.core.file.AsyncFileLock delegate) {
    this.delegate = delegate;
  }

  public AsyncFileLock(Object delegate) {
    this.delegate = (io.vertx.core.file.AsyncFileLock)delegate;
  }

  public io.vertx.core.file.AsyncFileLock getDelegate() {
    return delegate;
  }

  /**
   * @return the position of the first byte of the locked region
   */
  public long position() { 
    long ret = delegate.position();
    return ret;
  }

  /**
   * @return the size in bytes of the locked region
   */
  public long size() { 
    long ret = delegate.size();
    return ret;
  }

  /**
   * @return <code>true</code> if this lock is shared, otherwise <code>false</code>
   */
  public boolean isShared() { 
    boolean ret = delegate.isShared();
    return ret;
  }

  /**
   * @param position 
   * @param size 
   * @return <code>true</code> if this lock overlaps with the range described by <code>position</code> and <code>size</code>, otherwise <code>false</code>
   */
  public boolean overlaps(long position, long size) { 
    boolean ret = delegate.overlaps(position, size);
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.file.AsyncFileLock#isValid} but blocking.
   * @return 
   */
  public boolean isValidBlocking() { 
    boolean ret = delegate.isValidBlocking();
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.file.AsyncFileLock#isValid} but the <code>handler</code> will be called when the operation completes or if an error occurs.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Boolean> isValid() { 
    io.reactivex.rxjava3.core.Single<java.lang.Boolean> ret = rxIsValid();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.file.AsyncFileLock#isValid} but the <code>handler</code> will be called when the operation completes or if an error occurs.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Boolean> rxIsValid() { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.isValid(handler);
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.file.AsyncFileLock#release} but blocking.
   */
  public void releaseBlocking() { 
    delegate.releaseBlocking();
  }

  /**
   * Like {@link io.vertx.rxjava3.core.file.AsyncFileLock#release} but the <code>handler</code> will be called when the operation completes or if an error occurs.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable release() { 
    io.reactivex.rxjava3.core.Completable ret = rxRelease();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.file.AsyncFileLock#release} but the <code>handler</code> will be called when the operation completes or if an error occurs.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxRelease() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.release(handler);
    });
  }

  public static AsyncFileLock newInstance(io.vertx.core.file.AsyncFileLock arg) {
    return arg != null ? new AsyncFileLock(arg) : null;
  }

}
