/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.core.file;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a file on the file-system which can be read from, or written to asynchronously.
 * <p>
 * This class also implements {@link io.vertx.rxjava3.core.streams.ReadStream} and
 * {@link io.vertx.rxjava3.core.streams.WriteStream}. This allows the data to be piped to and from
 * other streams, e.g. an {@link io.vertx.rxjava3.core.http.HttpClientRequest} instance,
 * using the {@link io.vertx.rxjava3.core.streams.Pipe} class
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.file.AsyncFile original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.file.AsyncFile.class)
public class AsyncFile implements io.vertx.rxjava3.core.streams.ReadStream<io.vertx.rxjava3.core.buffer.Buffer>, io.vertx.rxjava3.core.streams.WriteStream<io.vertx.rxjava3.core.buffer.Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AsyncFile that = (AsyncFile) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AsyncFile> __TYPE_ARG = new TypeArg<>(    obj -> new AsyncFile((io.vertx.core.file.AsyncFile) obj),
    AsyncFile::getDelegate
  );

  private final io.vertx.core.file.AsyncFile delegate;
  
  public AsyncFile(io.vertx.core.file.AsyncFile delegate) {
    this.delegate = delegate;
  }

  public AsyncFile(Object delegate) {
    this.delegate = (io.vertx.core.file.AsyncFile)delegate;
  }

  public io.vertx.core.file.AsyncFile getDelegate() {
    return delegate;
  }

  private io.reactivex.rxjava3.core.Observable<io.vertx.rxjava3.core.buffer.Buffer> observable;
  private io.reactivex.rxjava3.core.Flowable<io.vertx.rxjava3.core.buffer.Buffer> flowable;

  public synchronized io.reactivex.rxjava3.core.Observable<io.vertx.rxjava3.core.buffer.Buffer> toObservable() {
    if (observable == null) {
      Function<io.vertx.core.buffer.Buffer, io.vertx.rxjava3.core.buffer.Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::newInstance;
      observable = ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.rxjava3.core.Flowable<io.vertx.rxjava3.core.buffer.Buffer> toFlowable() {
    if (flowable == null) {
      Function<io.vertx.core.buffer.Buffer, io.vertx.rxjava3.core.buffer.Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::newInstance;
      flowable = FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }

  private WriteStreamObserver<io.vertx.rxjava3.core.buffer.Buffer> observer;
  private WriteStreamSubscriber<io.vertx.rxjava3.core.buffer.Buffer> subscriber;

  public synchronized WriteStreamObserver<io.vertx.rxjava3.core.buffer.Buffer> toObserver() {
    if (observer == null) {
      Function<io.vertx.rxjava3.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::getDelegate;
      observer = RxHelper.toObserver(getDelegate(), conv);
    }
    return observer;
  }

  public synchronized WriteStreamSubscriber<io.vertx.rxjava3.core.buffer.Buffer> toSubscriber() {
    if (subscriber == null) {
      Function<io.vertx.rxjava3.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::getDelegate;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  private static final TypeArg<io.vertx.rxjava3.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.core.buffer.Buffer>(o1 -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava3.core.streams.Pipe<io.vertx.rxjava3.core.buffer.Buffer> pipe() { 
    io.vertx.rxjava3.core.streams.Pipe<io.vertx.rxjava3.core.buffer.Buffer> ret = io.vertx.rxjava3.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable pipeTo(io.vertx.rxjava3.core.streams.WriteStream<io.vertx.rxjava3.core.buffer.Buffer> dst) { 
    io.reactivex.rxjava3.core.Completable ret = rxPipeTo(dst);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxPipeTo(io.vertx.rxjava3.core.streams.WriteStream<io.vertx.rxjava3.core.buffer.Buffer> dst) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable write(io.vertx.rxjava3.core.buffer.Buffer data) { 
    io.reactivex.rxjava3.core.Completable ret = rxWrite(data);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxWrite(io.vertx.rxjava3.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.write(data.getDelegate(), handler);
    });
  }

  /**
   * Same as {@link io.vertx.rxjava3.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable end() { 
    io.reactivex.rxjava3.core.Completable ret = rxEnd();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Same as {@link io.vertx.rxjava3.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxEnd() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.end(handler);
    });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable end(io.vertx.rxjava3.core.buffer.Buffer data) { 
    io.reactivex.rxjava3.core.Completable ret = rxEnd(data);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxEnd(io.vertx.rxjava3.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.end(data.getDelegate(), handler);
    });
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava3.core.file.AsyncFile#setWriteQueueMaxSize}
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  public io.vertx.rxjava3.core.file.AsyncFile handler(io.vertx.core.Handler<io.vertx.rxjava3.core.buffer.Buffer> handler) { 
    delegate.handler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event)));
    return this;
  }

  public io.vertx.rxjava3.core.file.AsyncFile pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.rxjava3.core.file.AsyncFile resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.rxjava3.core.file.AsyncFile endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.rxjava3.core.file.AsyncFile setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  public io.vertx.rxjava3.core.file.AsyncFile drainHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.rxjava3.core.file.AsyncFile exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava3.core.file.AsyncFile fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * Close the file. The actual close happens asynchronously.
   * The handler will be called when the close is complete, or an error occurs.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable close() { 
    io.reactivex.rxjava3.core.Completable ret = rxClose();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Close the file. The actual close happens asynchronously.
   * The handler will be called when the close is complete, or an error occurs.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.close(handler);
    });
  }

  /**
   * Write a {@link io.vertx.rxjava3.core.buffer.Buffer} to the file at position <code>position</code> in the file, asynchronously.
   * <p>
   * If <code>position</code> lies outside of the current size
   * of the file, the file will be enlarged to encompass it.
   * <p>
   * When multiple writes are invoked on the same file
   * there are no guarantees as to order in which those writes actually occur
   * <p>
   * The handler will be called when the write is complete, or if an error occurs.
   * @param buffer the buffer to write
   * @param position the position in the file to write it at
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable write(io.vertx.rxjava3.core.buffer.Buffer buffer, long position) { 
    io.reactivex.rxjava3.core.Completable ret = rxWrite(buffer, position);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Write a {@link io.vertx.rxjava3.core.buffer.Buffer} to the file at position <code>position</code> in the file, asynchronously.
   * <p>
   * If <code>position</code> lies outside of the current size
   * of the file, the file will be enlarged to encompass it.
   * <p>
   * When multiple writes are invoked on the same file
   * there are no guarantees as to order in which those writes actually occur
   * <p>
   * The handler will be called when the write is complete, or if an error occurs.
   * @param buffer the buffer to write
   * @param position the position in the file to write it at
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxWrite(io.vertx.rxjava3.core.buffer.Buffer buffer, long position) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.write(buffer.getDelegate(), position, handler);
    });
  }

  /**
   * Reads <code>length</code> bytes of data from the file at position <code>position</code> in the file, asynchronously.
   * <p>
   * The read data will be written into the specified <code>Buffer buffer</code> at position <code>offset</code>.
   * <p>
   * If data is read past the end of the file then zero bytes will be read.<p>
   * When multiple reads are invoked on the same file there are no guarantees as to order in which those reads actually occur.
   * <p>
   * The handler will be called when the close is complete, or if an error occurs.
   * @param buffer the buffer to read into
   * @param offset the offset into the buffer where the data will be read
   * @param position the position in the file where to start reading
   * @param length the number of bytes to read
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.buffer.Buffer> read(io.vertx.rxjava3.core.buffer.Buffer buffer, int offset, long position, int length) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.buffer.Buffer> ret = rxRead(buffer, offset, position, length);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Reads <code>length</code> bytes of data from the file at position <code>position</code> in the file, asynchronously.
   * <p>
   * The read data will be written into the specified <code>Buffer buffer</code> at position <code>offset</code>.
   * <p>
   * If data is read past the end of the file then zero bytes will be read.<p>
   * When multiple reads are invoked on the same file there are no guarantees as to order in which those reads actually occur.
   * <p>
   * The handler will be called when the close is complete, or if an error occurs.
   * @param buffer the buffer to read into
   * @param offset the offset into the buffer where the data will be read
   * @param position the position in the file where to start reading
   * @param length the number of bytes to read
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.buffer.Buffer> rxRead(io.vertx.rxjava3.core.buffer.Buffer buffer, int offset, long position, int length) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.read(buffer.getDelegate(), offset, position, length, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event))));
    });
  }

  /**
   * Same as {@link io.vertx.rxjava3.core.file.AsyncFile#flush} but the handler will be called when the flush is complete or if an error occurs
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable flush() { 
    io.reactivex.rxjava3.core.Completable ret = rxFlush();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Same as {@link io.vertx.rxjava3.core.file.AsyncFile#flush} but the handler will be called when the flush is complete or if an error occurs
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxFlush() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.flush(handler);
    });
  }

  /**
   * Sets the position from which data will be read from when using the file as a {@link io.vertx.rxjava3.core.streams.ReadStream}.
   * @param readPos the position in the file
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.file.AsyncFile setReadPos(long readPos) { 
    delegate.setReadPos(readPos);
    return this;
  }

  /**
   * Sets the number of bytes that will be read when using the file as a {@link io.vertx.rxjava3.core.streams.ReadStream}.
   * @param readLength the bytes that will be read from the file
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.file.AsyncFile setReadLength(long readLength) { 
    delegate.setReadLength(readLength);
    return this;
  }

  /**
   * @return the number of bytes that will be read when using the file as a {@link io.vertx.rxjava3.core.streams.ReadStream}
   */
  public long getReadLength() { 
    long ret = delegate.getReadLength();
    return ret;
  }

  /**
   * Sets the position from which data will be written when using the file as a {@link io.vertx.rxjava3.core.streams.WriteStream}.
   * @param writePos the position in the file
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.file.AsyncFile setWritePos(long writePos) { 
    delegate.setWritePos(writePos);
    return this;
  }

  /**
   * @return the current write position the file is at
   */
  public long getWritePos() { 
    long ret = delegate.getWritePos();
    return ret;
  }

  /**
   * Sets the buffer size that will be used to read the data from the file. Changing this value will impact how much
   * the data will be read at a time from the file system.
   * @param readBufferSize the buffer size
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.file.AsyncFile setReadBufferSize(int readBufferSize) { 
    delegate.setReadBufferSize(readBufferSize);
    return this;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.file.AsyncFile#size} but blocking.
   * @return 
   */
  public long sizeBlocking() { 
    long ret = delegate.sizeBlocking();
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.file.AsyncFile#size} but the <code>handler</code> will be called when the operation is complete or if an error occurs.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Long> size() { 
    io.reactivex.rxjava3.core.Single<java.lang.Long> ret = rxSize();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.file.AsyncFile#size} but the <code>handler</code> will be called when the operation is complete or if an error occurs.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Long> rxSize() { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.size(handler);
    });
  }

  /**
   * Try to acquire a non-shared lock on the entire file.
   * @return the lock if it can be acquired immediately, otherwise <code>null</code>
   */
  public io.vertx.rxjava3.core.file.AsyncFileLock tryLock() { 
    io.vertx.rxjava3.core.file.AsyncFileLock ret = io.vertx.rxjava3.core.file.AsyncFileLock.newInstance((io.vertx.core.file.AsyncFileLock)delegate.tryLock());
    return ret;
  }

  /**
   * Try to acquire a lock on a portion of this file.
   * @param position where the region starts
   * @param size the size of the region
   * @param shared whether the lock should be shared
   * @return the lock if it can be acquired immediately, otherwise <code>null</code>
   */
  public io.vertx.rxjava3.core.file.AsyncFileLock tryLock(long position, long size, boolean shared) { 
    io.vertx.rxjava3.core.file.AsyncFileLock ret = io.vertx.rxjava3.core.file.AsyncFileLock.newInstance((io.vertx.core.file.AsyncFileLock)delegate.tryLock(position, size, shared));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.file.AsyncFile#lock} but the <code>handler</code> will be called when the operation is complete or if an error occurs.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.file.AsyncFileLock> lock() { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.file.AsyncFileLock> ret = rxLock();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.file.AsyncFile#lock} but the <code>handler</code> will be called when the operation is complete or if an error occurs.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.file.AsyncFileLock> rxLock() { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.lock(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.core.file.AsyncFileLock.newInstance((io.vertx.core.file.AsyncFileLock)event))));
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.file.AsyncFile#lock} but the <code>handler</code> will be called when the operation is complete or if an error occurs.
   * @param position 
   * @param size 
   * @param shared 
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.file.AsyncFileLock> lock(long position, long size, boolean shared) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.file.AsyncFileLock> ret = rxLock(position, size, shared);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.file.AsyncFile#lock} but the <code>handler</code> will be called when the operation is complete or if an error occurs.
   * @param position 
   * @param size 
   * @param shared 
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.file.AsyncFileLock> rxLock(long position, long size, boolean shared) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.lock(position, size, shared, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.core.file.AsyncFileLock.newInstance((io.vertx.core.file.AsyncFileLock)event))));
    });
  }

  public static AsyncFile newInstance(io.vertx.core.file.AsyncFile arg) {
    return arg != null ? new AsyncFile(arg) : null;
  }

}
