/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.cassandra;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Eclipse Vert.x Cassandra client.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.cassandra.CassandraClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.cassandra.CassandraClient.class)
public class CassandraClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CassandraClient that = (CassandraClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<CassandraClient> __TYPE_ARG = new TypeArg<>(    obj -> new CassandraClient((io.vertx.cassandra.CassandraClient) obj),
    CassandraClient::getDelegate
  );

  private final io.vertx.cassandra.CassandraClient delegate;
  
  public CassandraClient(io.vertx.cassandra.CassandraClient delegate) {
    this.delegate = delegate;
  }

  public CassandraClient(Object delegate) {
    this.delegate = (io.vertx.cassandra.CassandraClient)delegate;
  }

  public io.vertx.cassandra.CassandraClient getDelegate() {
    return delegate;
  }

  /**
   * Like {@link io.vertx.rxjava3.cassandra.CassandraClient#create} with default options.
   * @param vertx 
   * @return 
   */
  public static io.vertx.rxjava3.cassandra.CassandraClient create(io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.cassandra.CassandraClient ret = io.vertx.rxjava3.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a Cassandra client which maintains its own driver session.
   * <p>
   * It is not recommended to create several non shared clients in an application.
   * @param vertx the Vert.x instance
   * @param options the options
   * @return the client
   */
  public static io.vertx.rxjava3.cassandra.CassandraClient create(io.vertx.rxjava3.core.Vertx vertx, io.vertx.cassandra.CassandraClientOptions options) { 
    io.vertx.rxjava3.cassandra.CassandraClient ret = io.vertx.rxjava3.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.cassandra.CassandraClient#createShared} with default options and client name.
   * @param vertx 
   * @return 
   */
  public static io.vertx.rxjava3.cassandra.CassandraClient createShared(io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.cassandra.CassandraClient ret = io.vertx.rxjava3.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.createShared(vertx.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.cassandra.CassandraClient#createShared} with default options.
   * @param vertx 
   * @param clientName 
   * @return 
   */
  public static io.vertx.rxjava3.cassandra.CassandraClient createShared(io.vertx.rxjava3.core.Vertx vertx, java.lang.String clientName) { 
    io.vertx.rxjava3.cassandra.CassandraClient ret = io.vertx.rxjava3.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.createShared(vertx.getDelegate(), clientName));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.cassandra.CassandraClient#createShared} with default client name.
   * @param vertx 
   * @param options 
   * @return 
   */
  public static io.vertx.rxjava3.cassandra.CassandraClient createShared(io.vertx.rxjava3.core.Vertx vertx, io.vertx.cassandra.CassandraClientOptions options) { 
    io.vertx.rxjava3.cassandra.CassandraClient ret = io.vertx.rxjava3.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.createShared(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Create a Cassandra client that shares its driver session with any other client having the same name.
   * @param vertx the Vert.x instance
   * @param clientName the shared client name
   * @param options the options
   * @return the client
   */
  public static io.vertx.rxjava3.cassandra.CassandraClient createShared(io.vertx.rxjava3.core.Vertx vertx, java.lang.String clientName, io.vertx.cassandra.CassandraClientOptions options) { 
    io.vertx.rxjava3.cassandra.CassandraClient ret = io.vertx.rxjava3.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.createShared(vertx.getDelegate(), clientName, options));
    return ret;
  }

  /**
   * @return whether this Cassandra client instance is connected
   */
  public boolean isConnected() { 
    boolean ret = delegate.isConnected();
    return ret;
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param query the query to execute
   * @return current Cassandra client instance
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.cassandra.ResultSet> execute(java.lang.String query) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.cassandra.ResultSet> ret = rxExecute(query);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param query the query to execute
   * @return current Cassandra client instance
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.cassandra.ResultSet> rxExecute(java.lang.String query) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.execute(query, new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.rxjava3.cassandra.ResultSet.newInstance((io.vertx.cassandra.ResultSet)event))));
    });
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return current Cassandra client instance
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.cassandra.CassandraRowStream> queryStream(java.lang.String sql) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.cassandra.CassandraRowStream> ret = rxQueryStream(sql);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return current Cassandra client instance
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.cassandra.CassandraRowStream> rxQueryStream(java.lang.String sql) { 
    return AsyncResultSingle.toSingle( rowStreamHandler -> {
      delegate.queryStream(sql, new io.vertx.lang.rx.DelegatingHandler<>(rowStreamHandler, ar -> ar.map(event -> io.vertx.rxjava3.cassandra.CassandraRowStream.newInstance((io.vertx.cassandra.CassandraRowStream)event))));
    });
  }

  /**
   * Closes this client.
   * @return current Cassandra client instance
   */
  public io.reactivex.rxjava3.core.Completable close() { 
    io.reactivex.rxjava3.core.Completable ret = rxClose();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Closes this client.
   * @return current Cassandra client instance
   */
  public io.reactivex.rxjava3.core.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable( closeHandler -> {
      delegate.close(closeHandler);
    });
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param query the query to execute
   * @return current Cassandra client instance
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<com.datastax.oss.driver.api.core.cql.Row>> executeWithFullFetch(java.lang.String query) { 
    io.reactivex.rxjava3.core.Single<java.util.List<com.datastax.oss.driver.api.core.cql.Row>> ret = rxExecuteWithFullFetch(query);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param query the query to execute
   * @return current Cassandra client instance
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<com.datastax.oss.driver.api.core.cql.Row>> rxExecuteWithFullFetch(java.lang.String query) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.executeWithFullFetch(query, resultHandler);
    });
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param statement the statement to execute
   * @return current Cassandra client instance
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<com.datastax.oss.driver.api.core.cql.Row>> executeWithFullFetch(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    io.reactivex.rxjava3.core.Single<java.util.List<com.datastax.oss.driver.api.core.cql.Row>> ret = rxExecuteWithFullFetch(statement);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param statement the statement to execute
   * @return current Cassandra client instance
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<com.datastax.oss.driver.api.core.cql.Row>> rxExecuteWithFullFetch(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.executeWithFullFetch(statement, resultHandler);
    });
  }

  /**
   * Execute the statement and provide a handler for consuming results.
   * @param statement the statement to execute
   * @return current Cassandra client instance
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.cassandra.ResultSet> execute(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.cassandra.ResultSet> ret = rxExecute(statement);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Execute the statement and provide a handler for consuming results.
   * @param statement the statement to execute
   * @return current Cassandra client instance
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.cassandra.ResultSet> rxExecute(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.execute(statement, new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.rxjava3.cassandra.ResultSet.newInstance((io.vertx.cassandra.ResultSet)event))));
    });
  }

  /**
   * Prepares the provided query string.
   * @param query the query to prepare
   * @return current Cassandra client instance
   */
  public io.reactivex.rxjava3.core.Single<com.datastax.oss.driver.api.core.cql.PreparedStatement> prepare(java.lang.String query) { 
    io.reactivex.rxjava3.core.Single<com.datastax.oss.driver.api.core.cql.PreparedStatement> ret = rxPrepare(query);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Prepares the provided query string.
   * @param query the query to prepare
   * @return current Cassandra client instance
   */
  public io.reactivex.rxjava3.core.Single<com.datastax.oss.driver.api.core.cql.PreparedStatement> rxPrepare(java.lang.String query) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.prepare(query, resultHandler);
    });
  }

  /**
   * Prepares the provided a .
   * @param statement the statement to prepare
   * @return current Cassandra client instance
   */
  public io.reactivex.rxjava3.core.Single<com.datastax.oss.driver.api.core.cql.PreparedStatement> prepare(com.datastax.oss.driver.api.core.cql.SimpleStatement statement) { 
    io.reactivex.rxjava3.core.Single<com.datastax.oss.driver.api.core.cql.PreparedStatement> ret = rxPrepare(statement);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Prepares the provided a .
   * @param statement the statement to prepare
   * @return current Cassandra client instance
   */
  public io.reactivex.rxjava3.core.Single<com.datastax.oss.driver.api.core.cql.PreparedStatement> rxPrepare(com.datastax.oss.driver.api.core.cql.SimpleStatement statement) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.prepare(statement, resultHandler);
    });
  }

  /**
   * Executes the given SQL statement which returns the results of the query as a read stream.
   * @param statement the statement to execute.
   * @return current Cassandra client instance
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.cassandra.CassandraRowStream> queryStream(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.cassandra.CassandraRowStream> ret = rxQueryStream(statement);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Executes the given SQL statement which returns the results of the query as a read stream.
   * @param statement the statement to execute.
   * @return current Cassandra client instance
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.cassandra.CassandraRowStream> rxQueryStream(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    return AsyncResultSingle.toSingle( rowStreamHandler -> {
      delegate.queryStream(statement, new io.vertx.lang.rx.DelegatingHandler<>(rowStreamHandler, ar -> ar.map(event -> io.vertx.rxjava3.cassandra.CassandraRowStream.newInstance((io.vertx.cassandra.CassandraRowStream)event))));
    });
  }

  /**
   * Get  for the session.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<com.datastax.oss.driver.api.core.metadata.Metadata> metadata() { 
    io.reactivex.rxjava3.core.Single<com.datastax.oss.driver.api.core.metadata.Metadata> ret = rxMetadata();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Get  for the session.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<com.datastax.oss.driver.api.core.metadata.Metadata> rxMetadata() { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.metadata(handler);
    });
  }

  /**
   * The default shared client name.
   */
  public static final java.lang.String DEFAULT_SHARED_CLIENT_NAME = io.vertx.cassandra.CassandraClient.DEFAULT_SHARED_CLIENT_NAME;
  public static CassandraClient newInstance(io.vertx.cassandra.CassandraClient arg) {
    return arg != null ? new CassandraClient(arg) : null;
  }

}
