/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.mqtt;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.mqtt.MqttClientOptions;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.core.buffer.Buffer;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.mqtt.messages.MqttConnAckMessage;
import io.vertx.rxjava3.mqtt.messages.MqttPublishMessage;
import io.vertx.rxjava3.mqtt.messages.MqttSubAckMessage;
import java.util.Map;

@RxGen(value=io.vertx.mqtt.MqttClient.class)
public class MqttClient {
    public static final TypeArg<MqttClient> __TYPE_ARG = new TypeArg(obj -> new MqttClient((io.vertx.mqtt.MqttClient)obj), MqttClient::getDelegate);
    private final io.vertx.mqtt.MqttClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttClient that = (MqttClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MqttClient(io.vertx.mqtt.MqttClient delegate) {
        this.delegate = delegate;
    }

    public MqttClient(Object delegate) {
        this.delegate = (io.vertx.mqtt.MqttClient)delegate;
    }

    public io.vertx.mqtt.MqttClient getDelegate() {
        return this.delegate;
    }

    public static MqttClient create(io.vertx.rxjava3.core.Vertx vertx, MqttClientOptions options) {
        MqttClient ret = MqttClient.newInstance(io.vertx.mqtt.MqttClient.create((Vertx)vertx.getDelegate(), (MqttClientOptions)options));
        return ret;
    }

    public static MqttClient create(io.vertx.rxjava3.core.Vertx vertx) {
        MqttClient ret = MqttClient.newInstance(io.vertx.mqtt.MqttClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public Single<MqttConnAckMessage> connect(int port, String host) {
        Single ret = this.rxConnect(port, host);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<MqttConnAckMessage> rxConnect(int port, String host) {
        return AsyncResultSingle.toSingle(connectHandler -> this.delegate.connect(port, host, (Handler)new DelegatingHandler(connectHandler, ar -> ar.map(event -> MqttConnAckMessage.newInstance(event)))));
    }

    public Single<MqttConnAckMessage> connect(int port, String host, String serverName) {
        Single ret = this.rxConnect(port, host, serverName);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<MqttConnAckMessage> rxConnect(int port, String host, String serverName) {
        return AsyncResultSingle.toSingle(connectHandler -> this.delegate.connect(port, host, serverName, (Handler)new DelegatingHandler(connectHandler, ar -> ar.map(event -> MqttConnAckMessage.newInstance(event)))));
    }

    public Completable disconnect() {
        Completable ret = this.rxDisconnect();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxDisconnect() {
        return AsyncResultCompletable.toCompletable(disconnectHandler -> this.delegate.disconnect(disconnectHandler));
    }

    public Single<Integer> publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        Single ret = this.rxPublish(topic, payload, qosLevel, isDup, isRetain);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Integer> rxPublish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        return AsyncResultSingle.toSingle(publishSentHandler -> this.delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain, publishSentHandler));
    }

    public MqttClient publishCompletionHandler(Handler<Integer> publishCompletionHandler) {
        this.delegate.publishCompletionHandler(publishCompletionHandler);
        return this;
    }

    public MqttClient publishCompletionExpirationHandler(Handler<Integer> publishCompletionExpirationHandler) {
        this.delegate.publishCompletionExpirationHandler(publishCompletionExpirationHandler);
        return this;
    }

    public MqttClient publishCompletionUnknownPacketIdHandler(Handler<Integer> publishCompletionPhantomHandler) {
        this.delegate.publishCompletionUnknownPacketIdHandler(publishCompletionPhantomHandler);
        return this;
    }

    public MqttClient publishHandler(Handler<MqttPublishMessage> publishHandler) {
        this.delegate.publishHandler((Handler)new DelegatingHandler(publishHandler, event -> MqttPublishMessage.newInstance(event)));
        return this;
    }

    public MqttClient subscribeCompletionHandler(Handler<MqttSubAckMessage> subscribeCompletionHandler) {
        this.delegate.subscribeCompletionHandler((Handler)new DelegatingHandler(subscribeCompletionHandler, event -> MqttSubAckMessage.newInstance(event)));
        return this;
    }

    public Single<Integer> subscribe(String topic, int qos) {
        Single ret = this.rxSubscribe(topic, qos);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Integer> rxSubscribe(String topic, int qos) {
        return AsyncResultSingle.toSingle(subscribeSentHandler -> this.delegate.subscribe(topic, qos, subscribeSentHandler));
    }

    public Single<Integer> subscribe(Map<String, Integer> topics) {
        Single ret = this.rxSubscribe(topics);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Integer> rxSubscribe(Map<String, Integer> topics) {
        return AsyncResultSingle.toSingle(subscribeSentHandler -> this.delegate.subscribe(topics, subscribeSentHandler));
    }

    public MqttClient unsubscribeCompletionHandler(Handler<Integer> unsubscribeCompletionHandler) {
        this.delegate.unsubscribeCompletionHandler(unsubscribeCompletionHandler);
        return this;
    }

    public Single<Integer> unsubscribe(String topic) {
        Single ret = this.rxUnsubscribe(topic);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Integer> rxUnsubscribe(String topic) {
        return AsyncResultSingle.toSingle(unsubscribeSentHandler -> this.delegate.unsubscribe(topic, unsubscribeSentHandler));
    }

    public MqttClient pingResponseHandler(Handler<Void> pingResponseHandler) {
        this.delegate.pingResponseHandler(pingResponseHandler);
        return this;
    }

    public MqttClient exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public MqttClient closeHandler(Handler<Void> closeHandler) {
        this.delegate.closeHandler(closeHandler);
        return this;
    }

    public MqttClient ping() {
        this.delegate.ping();
        return this;
    }

    public String clientId() {
        String ret = this.delegate.clientId();
        return ret;
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public static MqttClient newInstance(io.vertx.mqtt.MqttClient arg) {
        return arg != null ? new MqttClient(arg) : null;
    }
}

