/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.mysqlclient;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An interface which represents a connection to MySQL server.
 * <P>
 *   The connection object supports all the operations defined in the  interface,
 *   in addition it provides MySQL utility command support:
 *   <ul>
 *     <li>COM_PING</li>
 *     <li>COM_CHANGE_USER</li>
 *     <li>COM_RESET_CONNECTION</li>
 *     <li>COM_DEBUG</li>
 *     <li>COM_INIT_DB</li>
 *     <li>COM_STATISTICS</li>
 *     <li>COM_SET_OPTION</li>
 *   </ul>
 * </P>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mysqlclient.MySQLConnection original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.mysqlclient.MySQLConnection.class)
public class MySQLConnection extends io.vertx.rxjava3.sqlclient.SqlConnection {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MySQLConnection that = (MySQLConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MySQLConnection> __TYPE_ARG = new TypeArg<>(    obj -> new MySQLConnection((io.vertx.mysqlclient.MySQLConnection) obj),
    MySQLConnection::getDelegate
  );

  private final io.vertx.mysqlclient.MySQLConnection delegate;
  
  public MySQLConnection(io.vertx.mysqlclient.MySQLConnection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public MySQLConnection(Object delegate) {
    super((io.vertx.mysqlclient.MySQLConnection)delegate);
    this.delegate = (io.vertx.mysqlclient.MySQLConnection)delegate;
  }

  public io.vertx.mysqlclient.MySQLConnection getDelegate() {
    return delegate;
  }

  /**
   * Create a connection to MySQL server with the given <code>connectOptions</code>.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @return 
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.mysqlclient.MySQLConnection> connect(io.vertx.rxjava3.core.Vertx vertx, io.vertx.mysqlclient.MySQLConnectOptions connectOptions) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.mysqlclient.MySQLConnection> ret = rxConnect(vertx, connectOptions);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Create a connection to MySQL server with the given <code>connectOptions</code>.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @return 
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.mysqlclient.MySQLConnection> rxConnect(io.vertx.rxjava3.core.Vertx vertx, io.vertx.mysqlclient.MySQLConnectOptions connectOptions) { 
    return AsyncResultSingle.toSingle( handler -> {
      io.vertx.mysqlclient.MySQLConnection.connect(vertx.getDelegate(), connectOptions, new Handler<AsyncResult<io.vertx.mysqlclient.MySQLConnection>>() {
      public void handle(AsyncResult<io.vertx.mysqlclient.MySQLConnection> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.mysqlclient.MySQLConnection.newInstance((io.vertx.mysqlclient.MySQLConnection)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.mysqlclient.MySQLConnection#connect} with options built from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.mysqlclient.MySQLConnection> connect(io.vertx.rxjava3.core.Vertx vertx, java.lang.String connectionUri) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.mysqlclient.MySQLConnection> ret = rxConnect(vertx, connectionUri);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.mysqlclient.MySQLConnection#connect} with options built from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.mysqlclient.MySQLConnection> rxConnect(io.vertx.rxjava3.core.Vertx vertx, java.lang.String connectionUri) { 
    return AsyncResultSingle.toSingle( handler -> {
      io.vertx.mysqlclient.MySQLConnection.connect(vertx.getDelegate(), connectionUri, new Handler<AsyncResult<io.vertx.mysqlclient.MySQLConnection>>() {
      public void handle(AsyncResult<io.vertx.mysqlclient.MySQLConnection> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.mysqlclient.MySQLConnection.newInstance((io.vertx.mysqlclient.MySQLConnection)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * 
   * @param sql 
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.sqlclient.PreparedStatement> prepare(java.lang.String sql) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.sqlclient.PreparedStatement> ret = rxPrepare(sql);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * 
   * @param sql 
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.sqlclient.PreparedStatement> rxPrepare(java.lang.String sql) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.prepare(sql, new Handler<AsyncResult<io.vertx.sqlclient.PreparedStatement>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.PreparedStatement> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava3.mysqlclient.MySQLConnection exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava3.mysqlclient.MySQLConnection closeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Send a PING command to check if the server is alive.
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Completable ping() { 
    io.reactivex.rxjava3.core.Completable ret = rxPing();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Send a PING command to check if the server is alive.
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Completable rxPing() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.ping(handler);
    });
  }

  /**
   * Send a INIT_DB command to change the default schema of the connection.
   * @param schemaName name of the schema to change to
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Completable specifySchema(java.lang.String schemaName) { 
    io.reactivex.rxjava3.core.Completable ret = rxSpecifySchema(schemaName);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Send a INIT_DB command to change the default schema of the connection.
   * @param schemaName name of the schema to change to
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Completable rxSpecifySchema(java.lang.String schemaName) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.specifySchema(schemaName, handler);
    });
  }

  /**
   * Send a STATISTICS command to get a human readable string of the server internal status.
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<java.lang.String> getInternalStatistics() { 
    io.reactivex.rxjava3.core.Single<java.lang.String> ret = rxGetInternalStatistics();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Send a STATISTICS command to get a human readable string of the server internal status.
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<java.lang.String> rxGetInternalStatistics() { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.getInternalStatistics(handler);
    });
  }

  /**
   * Send a SET_OPTION command to set options for the current connection.
   * @param option the options to set
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Completable setOption(io.vertx.mysqlclient.MySQLSetOption option) { 
    io.reactivex.rxjava3.core.Completable ret = rxSetOption(option);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Send a SET_OPTION command to set options for the current connection.
   * @param option the options to set
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Completable rxSetOption(io.vertx.mysqlclient.MySQLSetOption option) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.setOption(option, handler);
    });
  }

  /**
   * Send a RESET_CONNECTION command to reset the session state.
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Completable resetConnection() { 
    io.reactivex.rxjava3.core.Completable ret = rxResetConnection();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Send a RESET_CONNECTION command to reset the session state.
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Completable rxResetConnection() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.resetConnection(handler);
    });
  }

  /**
   * Send a DEBUG command to dump debug information to the server's stdout.
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Completable debug() { 
    io.reactivex.rxjava3.core.Completable ret = rxDebug();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Send a DEBUG command to dump debug information to the server's stdout.
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Completable rxDebug() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.debug(handler);
    });
  }

  /**
   * Send a CHANGE_USER command to change the user of the current connection, this operation will also reset connection state.
   * @param options authentication options
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Completable changeUser(io.vertx.mysqlclient.MySQLAuthOptions options) { 
    io.reactivex.rxjava3.core.Completable ret = rxChangeUser(options);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Send a CHANGE_USER command to change the user of the current connection, this operation will also reset connection state.
   * @param options authentication options
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Completable rxChangeUser(io.vertx.mysqlclient.MySQLAuthOptions options) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.changeUser(options, handler);
    });
  }

  /**
   * Cast a  to {@link io.vertx.rxjava3.mysqlclient.MySQLConnection}.
   *
   * This is mostly useful for Vert.x generated APIs like RxJava/Mutiny.
   * @param sqlConnection the connection to cast
   * @return a {@link io.vertx.rxjava3.mysqlclient.MySQLConnection instance}
   */
  public static io.vertx.rxjava3.mysqlclient.MySQLConnection cast(io.vertx.rxjava3.sqlclient.SqlConnection sqlConnection) { 
    io.vertx.rxjava3.mysqlclient.MySQLConnection ret = io.vertx.rxjava3.mysqlclient.MySQLConnection.newInstance((io.vertx.mysqlclient.MySQLConnection)io.vertx.mysqlclient.MySQLConnection.cast(sqlConnection.getDelegate()));
    return ret;
  }

  public static MySQLConnection newInstance(io.vertx.mysqlclient.MySQLConnection arg) {
    return arg != null ? new MySQLConnection(arg) : null;
  }

}
