/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.kafka.client.consumer;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Vert.x Kafka consumer.
 * <p>
 * You receive Kafka records by providing a {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#handler}. As messages arrive the handler
 * will be called with the records.
 * <p>
 * The {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#pause} and {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#resume} provides global control over reading the records from the consumer.
 * <p>
 * The {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#pause} and {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#resume} provides finer grained control over reading records
 * for specific Topic/Partition, these are Kafka's specific operations.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.client.consumer.KafkaConsumer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.kafka.client.consumer.KafkaConsumer.class)
public class KafkaConsumer<K,V> implements io.vertx.rxjava3.core.streams.ReadStream<io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecord<K,V>> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaConsumer that = (KafkaConsumer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<KafkaConsumer> __TYPE_ARG = new TypeArg<>(    obj -> new KafkaConsumer((io.vertx.kafka.client.consumer.KafkaConsumer) obj),
    KafkaConsumer::getDelegate
  );

  private final io.vertx.kafka.client.consumer.KafkaConsumer<K,V> delegate;
  public final TypeArg<K> __typeArg_0;
  public final TypeArg<V> __typeArg_1;
  
  public KafkaConsumer(io.vertx.kafka.client.consumer.KafkaConsumer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();    this.__typeArg_1 = TypeArg.unknown();  }

  public KafkaConsumer(Object delegate, TypeArg<K> typeArg_0, TypeArg<V> typeArg_1) {
    this.delegate = (io.vertx.kafka.client.consumer.KafkaConsumer)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  public io.vertx.kafka.client.consumer.KafkaConsumer getDelegate() {
    return delegate;
  }

  private io.reactivex.rxjava3.core.Observable<io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecord<K,V>> observable;
  private io.reactivex.rxjava3.core.Flowable<io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecord<K,V>> flowable;

  public synchronized io.reactivex.rxjava3.core.Observable<io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecord<K,V>> toObservable() {
    if (observable == null) {
      Function<io.vertx.kafka.client.consumer.KafkaConsumerRecord<K,V>, io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecord<K,V>> conv = io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecord::newInstance;
      observable = ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.rxjava3.core.Flowable<io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecord<K,V>> toFlowable() {
    if (flowable == null) {
      Function<io.vertx.kafka.client.consumer.KafkaConsumerRecord<K,V>, io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecord<K,V>> conv = io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecord::newInstance;
      flowable = FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }


  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava3.core.streams.Pipe<io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecord<K,V>> pipe() { 
    io.vertx.rxjava3.core.streams.Pipe<io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecord<K,V>> ret = io.vertx.rxjava3.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), new TypeArg<io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecord<K,V>>(o0 -> io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecord.newInstance((io.vertx.kafka.client.consumer.KafkaConsumerRecord)o0, __typeArg_0, __typeArg_1), o0 -> o0.getDelegate()));
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable pipeTo(io.vertx.rxjava3.core.streams.WriteStream<io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecord<K,V>> dst) { 
    io.reactivex.rxjava3.core.Completable ret = rxPipeTo(dst);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxPipeTo(io.vertx.rxjava3.core.streams.WriteStream<io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecord<K,V>> dst) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  /**
   * Create a new KafkaConsumer instance
   * @param vertx Vert.x instance to use
   * @param config Kafka consumer configuration
   * @return an instance of the KafkaConsumer
   */
  public static <K, V> io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer<K,V> create(io.vertx.rxjava3.core.Vertx vertx, java.util.Map<java.lang.String,java.lang.String> config) { 
    io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer<K,V> ret = io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer.newInstance((io.vertx.kafka.client.consumer.KafkaConsumer)io.vertx.kafka.client.consumer.KafkaConsumer.create(vertx.getDelegate(), config), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * Create a new KafkaConsumer instance
   * @param vertx Vert.x instance to use
   * @param config Kafka consumer configuration
   * @param keyType class type for the key deserialization
   * @param valueType class type for the value deserialization
   * @return an instance of the KafkaConsumer
   */
  public static <K, V> io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer<K,V> create(io.vertx.rxjava3.core.Vertx vertx, java.util.Map<java.lang.String,java.lang.String> config, java.lang.Class<K> keyType, java.lang.Class<V> valueType) { 
    io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer<K,V> ret = io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer.newInstance((io.vertx.kafka.client.consumer.KafkaConsumer)io.vertx.kafka.client.consumer.KafkaConsumer.create(vertx.getDelegate(), config, io.vertx.lang.rxjava3.Helper.unwrap(keyType), io.vertx.lang.rxjava3.Helper.unwrap(valueType)), TypeArg.of(keyType), TypeArg.of(valueType));
    return ret;
  }

  /**
   * Create a new KafkaConsumer instance
   * @param vertx Vert.x instance to use
   * @param options Kafka consumer options
   * @return an instance of the KafkaConsumer
   */
  public static <K, V> io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer<K,V> create(io.vertx.rxjava3.core.Vertx vertx, io.vertx.kafka.client.common.KafkaClientOptions options) { 
    io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer<K,V> ret = io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer.newInstance((io.vertx.kafka.client.consumer.KafkaConsumer)io.vertx.kafka.client.consumer.KafkaConsumer.create(vertx.getDelegate(), options), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * Create a new KafkaConsumer instance
   * @param vertx Vert.x instance to use
   * @param options Kafka consumer options
   * @param keyType class type for the key deserialization
   * @param valueType class type for the value deserialization
   * @return an instance of the KafkaConsumer
   */
  public static <K, V> io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer<K,V> create(io.vertx.rxjava3.core.Vertx vertx, io.vertx.kafka.client.common.KafkaClientOptions options, java.lang.Class<K> keyType, java.lang.Class<V> valueType) { 
    io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer<K,V> ret = io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer.newInstance((io.vertx.kafka.client.consumer.KafkaConsumer)io.vertx.kafka.client.consumer.KafkaConsumer.create(vertx.getDelegate(), options, io.vertx.lang.rxjava3.Helper.unwrap(keyType), io.vertx.lang.rxjava3.Helper.unwrap(valueType)), TypeArg.of(keyType), TypeArg.of(valueType));
    return ret;
  }

  public io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer<K,V> exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer<K,V> handler(io.vertx.core.Handler<io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecord<K,V>> handler) { 
    delegate.handler(new Handler<io.vertx.kafka.client.consumer.KafkaConsumerRecord<K,V>>() {
      public void handle(io.vertx.kafka.client.consumer.KafkaConsumerRecord<K,V> event) {
        handler.handle(io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecord.newInstance((io.vertx.kafka.client.consumer.KafkaConsumerRecord)event, __typeArg_0, __typeArg_1));
      }
    });
    return this;
  }

  public io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer<K,V> pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer<K,V> resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer<K,V> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer<K,V> endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * Returns the current demand.
   *
   * <ul>
   *   <i>If the stream is in <i>flowing</i> mode will return {@link java.lang.Long}.</i>
   *   <li>If the stream is in <i>fetch</i> mode, will return the current number of elements still to be delivered or 0 if paused.</li>
   * </ul>
   * @return current demand
   */
  public long demand() { 
    long ret = delegate.demand();
    return ret;
  }

  /**
   * Subscribe to the given topic to get dynamically assigned partitions.
   * <p>
   * Due to internal buffering of messages, when changing the subscribed topic
   * the old topic may remain in effect
   * (as observed by the  record handler})
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new topic.
   * @param topic topic to subscribe to
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable subscribe(java.lang.String topic) { 
    io.reactivex.rxjava3.core.Completable ret = rxSubscribe(topic);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Subscribe to the given topic to get dynamically assigned partitions.
   * <p>
   * Due to internal buffering of messages, when changing the subscribed topic
   * the old topic may remain in effect
   * (as observed by the  record handler})
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new topic.
   * @param topic topic to subscribe to
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable rxSubscribe(java.lang.String topic) { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.subscribe(topic, completionHandler);
    });
  }

  /**
   * Subscribe to the given list of topics to get dynamically assigned partitions.
   * <p>
   * Due to internal buffering of messages, when changing the subscribed topics
   * the old set of topics may remain in effect
   * (as observed by the  record handler})
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new set of topics.
   * @param topics topics to subscribe to
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable subscribe(java.util.Set<java.lang.String> topics) { 
    io.reactivex.rxjava3.core.Completable ret = rxSubscribe(topics);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Subscribe to the given list of topics to get dynamically assigned partitions.
   * <p>
   * Due to internal buffering of messages, when changing the subscribed topics
   * the old set of topics may remain in effect
   * (as observed by the  record handler})
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new set of topics.
   * @param topics topics to subscribe to
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable rxSubscribe(java.util.Set<java.lang.String> topics) { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.subscribe(topics, completionHandler);
    });
  }

  /**
   * Manually assign a partition to this consumer.
   * <p>
   * Due to internal buffering of messages, when reassigning
   * the old partition may remain in effect
   * (as observed by the  record handler)}
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new partition.
   * @param topicPartition partition which want assigned
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable assign(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    io.reactivex.rxjava3.core.Completable ret = rxAssign(topicPartition);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Manually assign a partition to this consumer.
   * <p>
   * Due to internal buffering of messages, when reassigning
   * the old partition may remain in effect
   * (as observed by the  record handler)}
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new partition.
   * @param topicPartition partition which want assigned
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable rxAssign(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.assign(topicPartition, completionHandler);
    });
  }

  /**
   * Manually assign a list of partition to this consumer.
   * <p>
   * Due to internal buffering of messages, when reassigning
   * the old set of partitions may remain in effect
   * (as observed by the  record handler)}
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new set of partitions.
   * @param topicPartitions partitions which want assigned
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable assign(java.util.Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    io.reactivex.rxjava3.core.Completable ret = rxAssign(topicPartitions);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Manually assign a list of partition to this consumer.
   * <p>
   * Due to internal buffering of messages, when reassigning
   * the old set of partitions may remain in effect
   * (as observed by the  record handler)}
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new set of partitions.
   * @param topicPartitions partitions which want assigned
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable rxAssign(java.util.Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.assign(topicPartitions, completionHandler);
    });
  }

  /**
   * Get the set of partitions currently assigned to this consumer.
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Single<java.util.Set<io.vertx.kafka.client.common.TopicPartition>> assignment() { 
    io.reactivex.rxjava3.core.Single<java.util.Set<io.vertx.kafka.client.common.TopicPartition>> ret = rxAssignment();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Get the set of partitions currently assigned to this consumer.
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Single<java.util.Set<io.vertx.kafka.client.common.TopicPartition>> rxAssignment() { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.assignment(handler);
    });
  }

  /**
   * Unsubscribe from topics currently subscribed with subscribe.
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable unsubscribe() { 
    io.reactivex.rxjava3.core.Completable ret = rxUnsubscribe();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Unsubscribe from topics currently subscribed with subscribe.
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable rxUnsubscribe() { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.unsubscribe(completionHandler);
    });
  }

  /**
   * Get the current subscription.
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Single<java.util.Set<java.lang.String>> subscription() { 
    io.reactivex.rxjava3.core.Single<java.util.Set<java.lang.String>> ret = rxSubscription();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Get the current subscription.
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Single<java.util.Set<java.lang.String>> rxSubscription() { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.subscription(handler);
    });
  }

  /**
   * Suspend fetching from the requested partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages from the given <code>topicPartition</code>
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#batchHandler} will not see messages
   * from the given <code>topicPartition</code>.
   * @param topicPartition topic partition from which suspend fetching
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable pause(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    io.reactivex.rxjava3.core.Completable ret = rxPause(topicPartition);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Suspend fetching from the requested partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages from the given <code>topicPartition</code>
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#batchHandler} will not see messages
   * from the given <code>topicPartition</code>.
   * @param topicPartition topic partition from which suspend fetching
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable rxPause(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.pause(topicPartition, completionHandler);
    });
  }

  /**
   * Suspend fetching from the requested partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages from the given <code>topicPartitions</code>
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#batchHandler} will not see messages
   * from the given <code>topicPartitions</code>.
   * @param topicPartitions topic partition from which suspend fetching
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable pause(java.util.Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    io.reactivex.rxjava3.core.Completable ret = rxPause(topicPartitions);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Suspend fetching from the requested partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages from the given <code>topicPartitions</code>
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#batchHandler} will not see messages
   * from the given <code>topicPartitions</code>.
   * @param topicPartitions topic partition from which suspend fetching
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable rxPause(java.util.Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.pause(topicPartitions, completionHandler);
    });
  }

  /**
   * Get the set of partitions that were previously paused by a call to pause(Set).
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.util.Set<io.vertx.kafka.client.common.TopicPartition>> paused() { 
    io.reactivex.rxjava3.core.Single<java.util.Set<io.vertx.kafka.client.common.TopicPartition>> ret = rxPaused();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Get the set of partitions that were previously paused by a call to pause(Set).
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.util.Set<io.vertx.kafka.client.common.TopicPartition>> rxPaused() { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.paused(handler);
    });
  }

  /**
   * Resume specified partition which have been paused with pause.
   * @param topicPartition topic partition from which resume fetching
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable resume(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    io.reactivex.rxjava3.core.Completable ret = rxResume(topicPartition);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Resume specified partition which have been paused with pause.
   * @param topicPartition topic partition from which resume fetching
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable rxResume(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.resume(topicPartition, completionHandler);
    });
  }

  /**
   * Resume specified partitions which have been paused with pause.
   * @param topicPartitions topic partition from which resume fetching
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable resume(java.util.Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    io.reactivex.rxjava3.core.Completable ret = rxResume(topicPartitions);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Resume specified partitions which have been paused with pause.
   * @param topicPartitions topic partition from which resume fetching
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable rxResume(java.util.Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.resume(topicPartitions, completionHandler);
    });
  }

  /**
   * Set the handler called when topic partitions are revoked to the consumer
   * @param handler handler called on revoked topic partitions
   * @return current KafkaConsumer instance
   */
  public io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer<K,V> partitionsRevokedHandler(io.vertx.core.Handler<java.util.Set<io.vertx.kafka.client.common.TopicPartition>> handler) { 
    delegate.partitionsRevokedHandler(handler);
    return this;
  }

  /**
   * Set the handler called when topic partitions are assigned to the consumer
   * @param handler handler called on assigned topic partitions
   * @return current KafkaConsumer instance
   */
  public io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer<K,V> partitionsAssignedHandler(io.vertx.core.Handler<java.util.Set<io.vertx.kafka.client.common.TopicPartition>> handler) { 
    delegate.partitionsAssignedHandler(handler);
    return this;
  }

  /**
   * Overrides the fetch offsets that the consumer will use on the next poll.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * @param topicPartition topic partition for which seek
   * @param offset offset to seek inside the topic partition
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable seek(io.vertx.kafka.client.common.TopicPartition topicPartition, long offset) { 
    io.reactivex.rxjava3.core.Completable ret = rxSeek(topicPartition, offset);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Overrides the fetch offsets that the consumer will use on the next poll.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * @param topicPartition topic partition for which seek
   * @param offset offset to seek inside the topic partition
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable rxSeek(io.vertx.kafka.client.common.TopicPartition topicPartition, long offset) { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.seek(topicPartition, offset, completionHandler);
    });
  }

  /**
   * Seek to the first offset for each of the given partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * @param topicPartition topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable seekToBeginning(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    io.reactivex.rxjava3.core.Completable ret = rxSeekToBeginning(topicPartition);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Seek to the first offset for each of the given partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * @param topicPartition topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable rxSeekToBeginning(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.seekToBeginning(topicPartition, completionHandler);
    });
  }

  /**
   * Seek to the first offset for each of the given partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * @param topicPartitions topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable seekToBeginning(java.util.Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    io.reactivex.rxjava3.core.Completable ret = rxSeekToBeginning(topicPartitions);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Seek to the first offset for each of the given partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * @param topicPartitions topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable rxSeekToBeginning(java.util.Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.seekToBeginning(topicPartitions, completionHandler);
    });
  }

  /**
   * Seek to the last offset for each of the given partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * @param topicPartition topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable seekToEnd(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    io.reactivex.rxjava3.core.Completable ret = rxSeekToEnd(topicPartition);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Seek to the last offset for each of the given partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * @param topicPartition topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable rxSeekToEnd(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.seekToEnd(topicPartition, completionHandler);
    });
  }

  /**
   * Seek to the last offset for each of the given partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * @param topicPartitions topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable seekToEnd(java.util.Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    io.reactivex.rxjava3.core.Completable ret = rxSeekToEnd(topicPartitions);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Seek to the last offset for each of the given partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * @param topicPartitions topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Completable rxSeekToEnd(java.util.Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.seekToEnd(topicPartitions, completionHandler);
    });
  }

  /**
   * Commit current offsets for all the subscribed list of topics and partition.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable commit() { 
    io.reactivex.rxjava3.core.Completable ret = rxCommit();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Commit current offsets for all the subscribed list of topics and partition.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxCommit() { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.commit(completionHandler);
    });
  }

  /**
   * Get the last committed offset for the given partition (whether the commit happened by this process or another).
   * @param topicPartition topic partition for getting last committed offset
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.kafka.client.consumer.OffsetAndMetadata> committed(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    io.reactivex.rxjava3.core.Single<io.vertx.kafka.client.consumer.OffsetAndMetadata> ret = rxCommitted(topicPartition);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Get the last committed offset for the given partition (whether the commit happened by this process or another).
   * @param topicPartition topic partition for getting last committed offset
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.kafka.client.consumer.OffsetAndMetadata> rxCommitted(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.committed(topicPartition, handler);
    });
  }

  /**
   * Get metadata about the partitions for a given topic.
   * @param topic topic partition for which getting partitions info
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<io.vertx.kafka.client.common.PartitionInfo>> partitionsFor(java.lang.String topic) { 
    io.reactivex.rxjava3.core.Single<java.util.List<io.vertx.kafka.client.common.PartitionInfo>> ret = rxPartitionsFor(topic);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Get metadata about the partitions for a given topic.
   * @param topic topic partition for which getting partitions info
   * @return current KafkaConsumer instance
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<io.vertx.kafka.client.common.PartitionInfo>> rxPartitionsFor(java.lang.String topic) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.partitionsFor(topic, handler);
    });
  }

  /**
   * Set the handler to be used when batches of messages are fetched
   * from the Kafka server. Batch handlers need to take care not to block
   * the event loop when dealing with large batches. It is better to process
   * records individually using the {@link io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer #handler(Handler) record handler}.
   * @param handler handler called when batches of messages are fetched
   * @return current KafkaConsumer instance
   */
  public io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer<K,V> batchHandler(io.vertx.core.Handler<io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecords<K,V>> handler) { 
    delegate.batchHandler(new Handler<io.vertx.kafka.client.consumer.KafkaConsumerRecords<K,V>>() {
      public void handle(io.vertx.kafka.client.consumer.KafkaConsumerRecords<K,V> event) {
        handler.handle(io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecords.newInstance((io.vertx.kafka.client.consumer.KafkaConsumerRecords)event, __typeArg_0, __typeArg_1));
      }
    });
    return this;
  }

  /**
   * Close the consumer
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable close() { 
    io.reactivex.rxjava3.core.Completable ret = rxClose();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Close the consumer
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.close(completionHandler);
    });
  }

  /**
   * Get the offset of the next record that will be fetched (if a record with that offset exists).
   * @param partition The partition to get the position for
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Long> position(io.vertx.kafka.client.common.TopicPartition partition) { 
    io.reactivex.rxjava3.core.Single<java.lang.Long> ret = rxPosition(partition);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Get the offset of the next record that will be fetched (if a record with that offset exists).
   * @param partition The partition to get the position for
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Long> rxPosition(io.vertx.kafka.client.common.TopicPartition partition) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.position(partition, handler);
    });
  }

  /**
   * Look up the offset for the given partition by timestamp. Note: the result might be null in case
   * for the given timestamp no offset can be found -- e.g., when the timestamp refers to the future
   * @param topicPartition TopicPartition to query.
   * @param timestamp Timestamp to be used in the query.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.kafka.client.consumer.OffsetAndTimestamp> offsetsForTimes(io.vertx.kafka.client.common.TopicPartition topicPartition, java.lang.Long timestamp) { 
    io.reactivex.rxjava3.core.Single<io.vertx.kafka.client.consumer.OffsetAndTimestamp> ret = rxOffsetsForTimes(topicPartition, timestamp);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Look up the offset for the given partition by timestamp. Note: the result might be null in case
   * for the given timestamp no offset can be found -- e.g., when the timestamp refers to the future
   * @param topicPartition TopicPartition to query.
   * @param timestamp Timestamp to be used in the query.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.kafka.client.consumer.OffsetAndTimestamp> rxOffsetsForTimes(io.vertx.kafka.client.common.TopicPartition topicPartition, java.lang.Long timestamp) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.offsetsForTimes(topicPartition, timestamp, handler);
    });
  }

  /**
   * Get the first offset for the given partitions.
   * @param topicPartition the partition to get the earliest offset.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Long> beginningOffsets(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    io.reactivex.rxjava3.core.Single<java.lang.Long> ret = rxBeginningOffsets(topicPartition);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Get the first offset for the given partitions.
   * @param topicPartition the partition to get the earliest offset.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Long> rxBeginningOffsets(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.beginningOffsets(topicPartition, handler);
    });
  }

  /**
   * Get the last offset for the given partition. The last offset of a partition is the offset
   * of the upcoming message, i.e. the offset of the last available message + 1.
   * @param topicPartition the partition to get the end offset.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Long> endOffsets(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    io.reactivex.rxjava3.core.Single<java.lang.Long> ret = rxEndOffsets(topicPartition);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Get the last offset for the given partition. The last offset of a partition is the offset
   * of the upcoming message, i.e. the offset of the last available message + 1.
   * @param topicPartition the partition to get the end offset.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Long> rxEndOffsets(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.endOffsets(topicPartition, handler);
    });
  }

  /**
   * Sets the poll timeout for the underlying native Kafka Consumer. Defaults to 1000ms.
   * Setting timeout to a lower value results in a more 'responsive' client, because it will block for a shorter period
   * if no data is available in the assigned partition and therefore allows subsequent actions to be executed with a shorter
   * delay. At the same time, the client will poll more frequently and thus will potentially create a higher load on the Kafka Broker.
   * @param timeout The time, spent waiting in poll if data is not available in the buffer. If 0, returns immediately with any records that are available currently in the native Kafka consumer's buffer, else returns empty. Must not be negative.
   * @return 
   */
  public io.vertx.rxjava3.kafka.client.consumer.KafkaConsumer<K,V> pollTimeout(java.time.Duration timeout) { 
    delegate.pollTimeout(timeout);
    return this;
  }

  /**
   * Executes a poll for getting messages from Kafka.
   * @param timeout The maximum time to block (must not be greater than {@link java.lang.Long} milliseconds)
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecords<K,V>> poll(java.time.Duration timeout) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecords<K,V>> ret = rxPoll(timeout);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Executes a poll for getting messages from Kafka.
   * @param timeout The maximum time to block (must not be greater than {@link java.lang.Long} milliseconds)
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecords<K,V>> rxPoll(java.time.Duration timeout) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.poll(timeout, new Handler<AsyncResult<io.vertx.kafka.client.consumer.KafkaConsumerRecords<K,V>>>() {
      public void handle(AsyncResult<io.vertx.kafka.client.consumer.KafkaConsumerRecords<K,V>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.kafka.client.consumer.KafkaConsumerRecords.newInstance((io.vertx.kafka.client.consumer.KafkaConsumerRecords)ar.result(), __typeArg_0, __typeArg_1)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  public static <K,V> KafkaConsumer<K,V> newInstance(io.vertx.kafka.client.consumer.KafkaConsumer arg) {
    return arg != null ? new KafkaConsumer<K,V>(arg) : null;
  }

  public static <K,V> KafkaConsumer<K,V> newInstance(io.vertx.kafka.client.consumer.KafkaConsumer arg, TypeArg<K> __typeArg_K, TypeArg<V> __typeArg_V) {
    return arg != null ? new KafkaConsumer<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }

}
