/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.httpproxy;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Handles the HTTP reverse proxy logic between the <i><b>user agent</b></i> and the <i><b>origin</b></i>.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.httpproxy.HttpProxy original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.httpproxy.HttpProxy.class)
public class HttpProxy implements Handler<io.vertx.rxjava3.core.http.HttpServerRequest> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpProxy that = (HttpProxy) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HttpProxy> __TYPE_ARG = new TypeArg<>(    obj -> new HttpProxy((io.vertx.httpproxy.HttpProxy) obj),
    HttpProxy::getDelegate
  );

  private final io.vertx.httpproxy.HttpProxy delegate;
  
  public HttpProxy(io.vertx.httpproxy.HttpProxy delegate) {
    this.delegate = delegate;
  }

  public HttpProxy(Object delegate) {
    this.delegate = (io.vertx.httpproxy.HttpProxy)delegate;
  }

  public io.vertx.httpproxy.HttpProxy getDelegate() {
    return delegate;
  }

  /**
   * Create a new <code>HttpProxy</code> instance.
   * @param client the <code>HttpClient</code> that forwards <i><b>outbound</b></i> requests to the <i><b>origin</b></i>.
   * @return a reference to this, so the API can be used fluently.
   */
  public static io.vertx.rxjava3.httpproxy.HttpProxy reverseProxy(io.vertx.rxjava3.core.http.HttpClient client) { 
    io.vertx.rxjava3.httpproxy.HttpProxy ret = io.vertx.rxjava3.httpproxy.HttpProxy.newInstance((io.vertx.httpproxy.HttpProxy)io.vertx.httpproxy.HttpProxy.reverseProxy(client.getDelegate()));
    return ret;
  }

  /**
   * Create a new <code>HttpProxy</code> instance.
   * @param options 
   * @param client the <code>HttpClient</code> that forwards <i><b>outbound</b></i> requests to the <i><b>origin</b></i>.
   * @return a reference to this, so the API can be used fluently.
   */
  public static io.vertx.rxjava3.httpproxy.HttpProxy reverseProxy(io.vertx.httpproxy.ProxyOptions options, io.vertx.rxjava3.core.http.HttpClient client) { 
    io.vertx.rxjava3.httpproxy.HttpProxy ret = io.vertx.rxjava3.httpproxy.HttpProxy.newInstance((io.vertx.httpproxy.HttpProxy)io.vertx.httpproxy.HttpProxy.reverseProxy(options, client.getDelegate()));
    return ret;
  }

  /**
   * Set the <code>SocketAddress</code> of the <i><b>origin</b></i>.
   * @param address the <code>SocketAddress</code> of the <i><b>origin</b></i>
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.httpproxy.HttpProxy origin(io.vertx.rxjava3.core.net.SocketAddress address) { 
    delegate.origin(address.getDelegate());
    return this;
  }

  /**
   * Set the host name and port number of the <i><b>origin</b></i>.
   * @param port the port number of the <i><b>origin</b></i> server
   * @param host the host name of the <i><b>origin</b></i> server
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.httpproxy.HttpProxy origin(int port, java.lang.String host) { 
    delegate.origin(port, host);
    return this;
  }

  /**
   * Set a selector that resolves the <i><b>origin</b></i> address based on the <i><b>outbound</b></i> request.
   * @param selector the selector
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.httpproxy.HttpProxy originSelector(java.util.function.Function<io.vertx.rxjava3.core.http.HttpServerRequest,io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.net.SocketAddress>> selector) { 
    delegate.originSelector(new Function<io.vertx.core.http.HttpServerRequest,io.vertx.core.Future<io.vertx.core.net.SocketAddress>>() {
      public io.vertx.core.Future<io.vertx.core.net.SocketAddress> apply(io.vertx.core.http.HttpServerRequest arg) {
        io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.net.SocketAddress> ret = selector.apply(io.vertx.rxjava3.core.http.HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)arg));
        return io.vertx.rxjava3.SingleHelper.toFuture(ret, obj -> obj.getDelegate());
      }
    });
    return this;
  }

  /**
   * Add an interceptor to the interceptor chain.
   * @param interceptor 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.httpproxy.HttpProxy addInterceptor(io.vertx.rxjava3.httpproxy.ProxyInterceptor interceptor) { 
    delegate.addInterceptor(interceptor.getDelegate());
    return this;
  }

  /**
   * Handle the <i><b>outbound</b></i> <code>HttpServerRequest</code>.
   * @param outboundRequest the outbound <code>HttpServerRequest</code>
   */
  public void handle(io.vertx.rxjava3.core.http.HttpServerRequest outboundRequest) { 
    delegate.handle(outboundRequest.getDelegate());
  }

  public static HttpProxy newInstance(io.vertx.httpproxy.HttpProxy arg) {
    return arg != null ? new HttpProxy(arg) : null;
  }

}
