/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.validation.builder;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * This interface is used to build body processors. <br/>
 *
 * Look at {@link io.vertx.rxjava3.ext.web.validation.builder.Bodies} for all available factories.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.validation.builder.BodyProcessorFactory original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.validation.builder.BodyProcessorFactory.class)
public class BodyProcessorFactory {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BodyProcessorFactory that = (BodyProcessorFactory) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<BodyProcessorFactory> __TYPE_ARG = new TypeArg<>(    obj -> new BodyProcessorFactory((io.vertx.ext.web.validation.builder.BodyProcessorFactory) obj),
    BodyProcessorFactory::getDelegate
  );

  private final io.vertx.ext.web.validation.builder.BodyProcessorFactory delegate;
  
  public BodyProcessorFactory(io.vertx.ext.web.validation.builder.BodyProcessorFactory delegate) {
    this.delegate = delegate;
  }

  public BodyProcessorFactory(Object delegate) {
    this.delegate = (io.vertx.ext.web.validation.builder.BodyProcessorFactory)delegate;
  }

  public io.vertx.ext.web.validation.builder.BodyProcessorFactory getDelegate() {
    return delegate;
  }

  public io.vertx.ext.web.validation.impl.body.BodyProcessor create(io.vertx.rxjava3.json.schema.SchemaParser parser) { 
    io.vertx.ext.web.validation.impl.body.BodyProcessor ret = delegate.create(parser.getDelegate());
    return ret;
  }

  public static BodyProcessorFactory newInstance(io.vertx.ext.web.validation.builder.BodyProcessorFactory arg) {
    return arg != null ? new BodyProcessorFactory(arg) : null;
  }

}
