/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.sstore;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A session store which is only available on a single node.
 * <p>
 * Can be used when sticky sessions are being used.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.sstore.LocalSessionStore original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.sstore.LocalSessionStore.class)
public class LocalSessionStore extends io.vertx.rxjava3.ext.web.sstore.SessionStore {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LocalSessionStore that = (LocalSessionStore) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<LocalSessionStore> __TYPE_ARG = new TypeArg<>(    obj -> new LocalSessionStore((io.vertx.ext.web.sstore.LocalSessionStore) obj),
    LocalSessionStore::getDelegate
  );

  private final io.vertx.ext.web.sstore.LocalSessionStore delegate;
  
  public LocalSessionStore(io.vertx.ext.web.sstore.LocalSessionStore delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public LocalSessionStore(Object delegate) {
    super((io.vertx.ext.web.sstore.LocalSessionStore)delegate);
    this.delegate = (io.vertx.ext.web.sstore.LocalSessionStore)delegate;
  }

  public io.vertx.ext.web.sstore.LocalSessionStore getDelegate() {
    return delegate;
  }

  /**
   * Create a session store
   * @param vertx the Vert.x instance
   * @return the session store
   */
  public static io.vertx.rxjava3.ext.web.sstore.LocalSessionStore create(io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.ext.web.sstore.LocalSessionStore ret = io.vertx.rxjava3.ext.web.sstore.LocalSessionStore.newInstance((io.vertx.ext.web.sstore.LocalSessionStore)io.vertx.ext.web.sstore.LocalSessionStore.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a session store
   * @param vertx the Vert.x instance
   * @param sessionMapName name for map used to store sessions
   * @return the session store
   */
  public static io.vertx.rxjava3.ext.web.sstore.LocalSessionStore create(io.vertx.rxjava3.core.Vertx vertx, java.lang.String sessionMapName) { 
    io.vertx.rxjava3.ext.web.sstore.LocalSessionStore ret = io.vertx.rxjava3.ext.web.sstore.LocalSessionStore.newInstance((io.vertx.ext.web.sstore.LocalSessionStore)io.vertx.ext.web.sstore.LocalSessionStore.create(vertx.getDelegate(), sessionMapName));
    return ret;
  }

  /**
   * Create a session store
   * @param vertx the Vert.x instance
   * @param sessionMapName name for map used to store sessions
   * @param reaperInterval how often, in ms, to check for expired sessions
   * @return the session store
   */
  public static io.vertx.rxjava3.ext.web.sstore.LocalSessionStore create(io.vertx.rxjava3.core.Vertx vertx, java.lang.String sessionMapName, long reaperInterval) { 
    io.vertx.rxjava3.ext.web.sstore.LocalSessionStore ret = io.vertx.rxjava3.ext.web.sstore.LocalSessionStore.newInstance((io.vertx.ext.web.sstore.LocalSessionStore)io.vertx.ext.web.sstore.LocalSessionStore.create(vertx.getDelegate(), sessionMapName, reaperInterval));
    return ret;
  }

  /**
   * Default length for a session id.
   * More info: https://www.owasp.org/index.php/Session_Management_Cheat_Sheet
   */
  public static final int DEFAULT_SESSIONID_LENGTH = io.vertx.ext.web.sstore.LocalSessionStore.DEFAULT_SESSIONID_LENGTH;
  /**
   * Default of how often, in ms, to check for expired sessions
   */
  public static final long DEFAULT_REAPER_INTERVAL = io.vertx.ext.web.sstore.LocalSessionStore.DEFAULT_REAPER_INTERVAL;
  /**
   * Default name for map used to store sessions
   */
  public static final java.lang.String DEFAULT_SESSION_MAP_NAME = io.vertx.ext.web.sstore.LocalSessionStore.DEFAULT_SESSION_MAP_NAME;
  public static LocalSessionStore newInstance(io.vertx.ext.web.sstore.LocalSessionStore arg) {
    return arg != null ? new LocalSessionStore(arg) : null;
  }

}
