/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.handler;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Handler that handles login from a form on a custom login page.
 * <p>
 * Used in conjunction with the {@link io.vertx.rxjava3.ext.web.handler.RedirectAuthHandler}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.FormLoginHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.FormLoginHandler.class)
public class FormLoginHandler implements Handler<io.vertx.rxjava3.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FormLoginHandler that = (FormLoginHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<FormLoginHandler> __TYPE_ARG = new TypeArg<>(    obj -> new FormLoginHandler((io.vertx.ext.web.handler.FormLoginHandler) obj),
    FormLoginHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.FormLoginHandler delegate;
  
  public FormLoginHandler(io.vertx.ext.web.handler.FormLoginHandler delegate) {
    this.delegate = delegate;
  }

  public FormLoginHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.FormLoginHandler)delegate;
  }

  public io.vertx.ext.web.handler.FormLoginHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.rxjava3.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a handler
   * @param authProvider the auth service to use
   * @return the handler
   */
  public static io.vertx.rxjava3.ext.web.handler.FormLoginHandler create(io.vertx.rxjava3.ext.auth.authentication.AuthenticationProvider authProvider) { 
    io.vertx.rxjava3.ext.web.handler.FormLoginHandler ret = io.vertx.rxjava3.ext.web.handler.FormLoginHandler.newInstance((io.vertx.ext.web.handler.FormLoginHandler)io.vertx.ext.web.handler.FormLoginHandler.create(authProvider.getDelegate()));
    return ret;
  }

  /**
   * Create a handler
   * @param authProvider the auth service to use
   * @param usernameParam the value of the form attribute which will contain the username
   * @param passwordParam the value of the form attribute which will contain the password
   * @param returnURLParam the value of the session attribute which will contain the return url
   * @param directLoggedInOKURL a url to redirect to if the user logs in directly at the url of the form login handler without being redirected here first
   * @return the handler
   */
  public static io.vertx.rxjava3.ext.web.handler.FormLoginHandler create(io.vertx.rxjava3.ext.auth.authentication.AuthenticationProvider authProvider, java.lang.String usernameParam, java.lang.String passwordParam, java.lang.String returnURLParam, java.lang.String directLoggedInOKURL) { 
    io.vertx.rxjava3.ext.web.handler.FormLoginHandler ret = io.vertx.rxjava3.ext.web.handler.FormLoginHandler.newInstance((io.vertx.ext.web.handler.FormLoginHandler)io.vertx.ext.web.handler.FormLoginHandler.create(authProvider.getDelegate(), usernameParam, passwordParam, returnURLParam, directLoggedInOKURL));
    return ret;
  }

  /**
   * Set the name of the form param used to submit the username
   * @param usernameParam the name of the param
   * @return a reference to this for a fluent API
   */
  public io.vertx.rxjava3.ext.web.handler.FormLoginHandler setUsernameParam(java.lang.String usernameParam) { 
    delegate.setUsernameParam(usernameParam);
    return this;
  }

  /**
   * Set the name of the form param used to submit the password
   * @param passwordParam the name of the param
   * @return a reference to this for a fluent API
   */
  public io.vertx.rxjava3.ext.web.handler.FormLoginHandler setPasswordParam(java.lang.String passwordParam) { 
    delegate.setPasswordParam(passwordParam);
    return this;
  }

  /**
   * Set the name of the session attrioute used to specify the return url
   * @param returnURLParam the name of the param
   * @return a reference to this for a fluent API
   */
  public io.vertx.rxjava3.ext.web.handler.FormLoginHandler setReturnURLParam(java.lang.String returnURLParam) { 
    delegate.setReturnURLParam(returnURLParam);
    return this;
  }

  /**
   * Set the url to redirect to if the user logs in directly at the url of the form login handler
   * without being redirected here first
   * @param directLoggedInOKURL the URL to redirect to
   * @return a reference to this for a fluent API
   */
  public io.vertx.rxjava3.ext.web.handler.FormLoginHandler setDirectLoggedInOKURL(java.lang.String directLoggedInOKURL) { 
    delegate.setDirectLoggedInOKURL(directLoggedInOKURL);
    return this;
  }

  /**
   * The default value of the form attribute which will contain the username
   */
  public static final java.lang.String DEFAULT_USERNAME_PARAM = io.vertx.ext.web.handler.FormLoginHandler.DEFAULT_USERNAME_PARAM;
  /**
   * The default value of the form attribute which will contain the password
   */
  public static final java.lang.String DEFAULT_PASSWORD_PARAM = io.vertx.ext.web.handler.FormLoginHandler.DEFAULT_PASSWORD_PARAM;
  /**
   * The default value of the session attribute which will contain the return url
   */
  public static final java.lang.String DEFAULT_RETURN_URL_PARAM = io.vertx.ext.web.handler.FormLoginHandler.DEFAULT_RETURN_URL_PARAM;
  public static FormLoginHandler newInstance(io.vertx.ext.web.handler.FormLoginHandler arg) {
    return arg != null ? new FormLoginHandler(arg) : null;
  }

}
