/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.unit;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * This object provides callback-ability for the end of a test suite, the completion <i>succeeds</i>
 * when all tests pass otherwise it fails.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.unit.TestCompletion original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.unit.TestCompletion.class)
public class TestCompletion extends io.vertx.rxjava3.ext.unit.Completion<java.lang.Void> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TestCompletion that = (TestCompletion) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<TestCompletion> __TYPE_ARG = new TypeArg<>(    obj -> new TestCompletion((io.vertx.ext.unit.TestCompletion) obj),
    TestCompletion::getDelegate
  );

  private final io.vertx.ext.unit.TestCompletion delegate;
  
  public TestCompletion(io.vertx.ext.unit.TestCompletion delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public TestCompletion(Object delegate) {
    super((io.vertx.ext.unit.TestCompletion)delegate);
    this.delegate = (io.vertx.ext.unit.TestCompletion)delegate;
  }

  public io.vertx.ext.unit.TestCompletion getDelegate() {
    return delegate;
  }

  /**
   * Completes the future upon completion, otherwise fails it.
   * @param future the future to resolve
   */
  public void resolve(io.vertx.rxjava3.core.Promise<java.lang.Void> future) { 
    delegate.resolve(future.getDelegate());
  }

  /**
   * Completion handler to receive a completion signal when this completions completes.
   * @return 
   */
  public io.reactivex.rxjava3.core.Maybe<java.lang.Void> handler() { 
    io.reactivex.rxjava3.core.Maybe<java.lang.Void> ret = rxHandler();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Completion handler to receive a completion signal when this completions completes.
   * @return 
   */
  public io.reactivex.rxjava3.core.Maybe<java.lang.Void> rxHandler() { 
    return AsyncResultMaybe.toMaybe( completionHandler -> {
      delegate.handler(completionHandler);
    });
  }

  public static TestCompletion newInstance(io.vertx.ext.unit.TestCompletion arg) {
    return arg != null ? new TestCompletion(arg) : null;
  }

}
