/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.shell.term;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A server for terminal based applications.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.term.TermServer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.shell.term.TermServer.class)
public class TermServer {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TermServer that = (TermServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<TermServer> __TYPE_ARG = new TypeArg<>(    obj -> new TermServer((io.vertx.ext.shell.term.TermServer) obj),
    TermServer::getDelegate
  );

  private final io.vertx.ext.shell.term.TermServer delegate;
  
  public TermServer(io.vertx.ext.shell.term.TermServer delegate) {
    this.delegate = delegate;
  }

  public TermServer(Object delegate) {
    this.delegate = (io.vertx.ext.shell.term.TermServer)delegate;
  }

  public io.vertx.ext.shell.term.TermServer getDelegate() {
    return delegate;
  }

  /**
   * Create a term server for the SSH protocol.
   * @param vertx the vertx instance
   * @return the term server
   */
  public static io.vertx.rxjava3.ext.shell.term.TermServer createSSHTermServer(io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.ext.shell.term.TermServer ret = io.vertx.rxjava3.ext.shell.term.TermServer.newInstance((io.vertx.ext.shell.term.TermServer)io.vertx.ext.shell.term.TermServer.createSSHTermServer(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a term server for the SSH protocol.
   * @param vertx the vertx instance
   * @param options the ssh options
   * @return the term server
   */
  public static io.vertx.rxjava3.ext.shell.term.TermServer createSSHTermServer(io.vertx.rxjava3.core.Vertx vertx, io.vertx.ext.shell.term.SSHTermOptions options) { 
    io.vertx.rxjava3.ext.shell.term.TermServer ret = io.vertx.rxjava3.ext.shell.term.TermServer.newInstance((io.vertx.ext.shell.term.TermServer)io.vertx.ext.shell.term.TermServer.createSSHTermServer(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Create a term server for the Telnet protocol.
   * @param vertx the vertx instance
   * @return the term server
   */
  public static io.vertx.rxjava3.ext.shell.term.TermServer createTelnetTermServer(io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.ext.shell.term.TermServer ret = io.vertx.rxjava3.ext.shell.term.TermServer.newInstance((io.vertx.ext.shell.term.TermServer)io.vertx.ext.shell.term.TermServer.createTelnetTermServer(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a term server for the Telnet protocol.
   * @param vertx the vertx instance
   * @param options the term options
   * @return the term server
   */
  public static io.vertx.rxjava3.ext.shell.term.TermServer createTelnetTermServer(io.vertx.rxjava3.core.Vertx vertx, io.vertx.ext.shell.term.TelnetTermOptions options) { 
    io.vertx.rxjava3.ext.shell.term.TermServer ret = io.vertx.rxjava3.ext.shell.term.TermServer.newInstance((io.vertx.ext.shell.term.TermServer)io.vertx.ext.shell.term.TermServer.createTelnetTermServer(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Create a term server for the HTTP protocol.
   * @param vertx the vertx instance
   * @return the term server
   */
  public static io.vertx.rxjava3.ext.shell.term.TermServer createHttpTermServer(io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.ext.shell.term.TermServer ret = io.vertx.rxjava3.ext.shell.term.TermServer.newInstance((io.vertx.ext.shell.term.TermServer)io.vertx.ext.shell.term.TermServer.createHttpTermServer(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a term server for the HTTP protocol.
   * @param vertx the vertx instance
   * @param options the term options
   * @return the term server
   */
  public static io.vertx.rxjava3.ext.shell.term.TermServer createHttpTermServer(io.vertx.rxjava3.core.Vertx vertx, io.vertx.ext.shell.term.HttpTermOptions options) { 
    io.vertx.rxjava3.ext.shell.term.TermServer ret = io.vertx.rxjava3.ext.shell.term.TermServer.newInstance((io.vertx.ext.shell.term.TermServer)io.vertx.ext.shell.term.TermServer.createHttpTermServer(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Create a term server for the HTTP protocol, using an existing router.
   * @param vertx the vertx instance
   * @param router the router
   * @return the term server
   */
  public static io.vertx.rxjava3.ext.shell.term.TermServer createHttpTermServer(io.vertx.rxjava3.core.Vertx vertx, io.vertx.rxjava3.ext.web.Router router) { 
    io.vertx.rxjava3.ext.shell.term.TermServer ret = io.vertx.rxjava3.ext.shell.term.TermServer.newInstance((io.vertx.ext.shell.term.TermServer)io.vertx.ext.shell.term.TermServer.createHttpTermServer(vertx.getDelegate(), router.getDelegate()));
    return ret;
  }

  /**
   * Create a term server for the HTTP protocol, using an existing router.
   * @param vertx the vertx instance
   * @param router the router
   * @param options the term options
   * @return the term server
   */
  public static io.vertx.rxjava3.ext.shell.term.TermServer createHttpTermServer(io.vertx.rxjava3.core.Vertx vertx, io.vertx.rxjava3.ext.web.Router router, io.vertx.ext.shell.term.HttpTermOptions options) { 
    io.vertx.rxjava3.ext.shell.term.TermServer ret = io.vertx.rxjava3.ext.shell.term.TermServer.newInstance((io.vertx.ext.shell.term.TermServer)io.vertx.ext.shell.term.TermServer.createHttpTermServer(vertx.getDelegate(), router.getDelegate(), options));
    return ret;
  }

  /**
   * Set the term handler that will receive incoming client connections. When a remote terminal connects
   * the <code>handler</code> will be called with the {@link io.vertx.rxjava3.ext.shell.term.Term} which can be used to interact with the remote
   * terminal.
   * @param handler the term handler
   * @return this object
   */
  public io.vertx.rxjava3.ext.shell.term.TermServer termHandler(io.vertx.core.Handler<io.vertx.rxjava3.ext.shell.term.Term> handler) { 
    delegate.termHandler(new Handler<io.vertx.ext.shell.term.Term>() {
      public void handle(io.vertx.ext.shell.term.Term event) {
        handler.handle(io.vertx.rxjava3.ext.shell.term.Term.newInstance((io.vertx.ext.shell.term.Term)event));
      }
    });
    return this;
  }

  /**
   * @param provider the auth to use
   * @return this object
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.shell.term.TermServer authProvider(io.vertx.rxjava3.ext.auth.AuthProvider provider) { 
    delegate.authProvider(provider.getDelegate());
    return this;
  }

  /**
   * Set an auth provider to use, any provider configured in options will override this provider. This should be used
   * when a custom auth provider should be used.
   * @param provider the auth to use
   * @return this object
   */
  public io.vertx.rxjava3.ext.shell.term.TermServer authenticationProvider(io.vertx.rxjava3.ext.auth.authentication.AuthenticationProvider provider) { 
    delegate.authenticationProvider(provider.getDelegate());
    return this;
  }

  /**
   * Bind the term server, the {@link io.vertx.rxjava3.ext.shell.term.TermServer#termHandler} must be set before.
   * @return this object
   */
  public io.reactivex.rxjava3.core.Completable listen() { 
    io.reactivex.rxjava3.core.Completable ret = rxListen();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Bind the term server, the {@link io.vertx.rxjava3.ext.shell.term.TermServer#termHandler} must be set before.
   * @return this object
   */
  public io.reactivex.rxjava3.core.Completable rxListen() { 
    return AsyncResultCompletable.toCompletable( listenHandler -> {
      delegate.listen(listenHandler);
    });
  }

  /**
   * The actual port the server is listening on. This is useful if you bound the server specifying 0 as port number
   * signifying an ephemeral port
   * @return the actual port the server is listening on.
   */
  public int actualPort() { 
    int ret = delegate.actualPort();
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.ext.shell.term.TermServer#close} but supplying a handler that will be notified when close is complete.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable close() { 
    io.reactivex.rxjava3.core.Completable ret = rxClose();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.ext.shell.term.TermServer#close} but supplying a handler that will be notified when close is complete.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.close(completionHandler);
    });
  }

  public static TermServer newInstance(io.vertx.ext.shell.term.TermServer arg) {
    return arg != null ? new TermServer(arg) : null;
  }

}
