/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.cassandra;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * It is like {@link com.datastax.oss.driver.api.core.cql.AsyncResultSet}, but adapted for Vert.x.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.cassandra.ResultSet original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.cassandra.ResultSet.class)
public class ResultSet {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResultSet that = (ResultSet) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ResultSet> __TYPE_ARG = new TypeArg<>(    obj -> new ResultSet((io.vertx.cassandra.ResultSet) obj),
    ResultSet::getDelegate
  );

  private final io.vertx.cassandra.ResultSet delegate;
  
  public ResultSet(io.vertx.cassandra.ResultSet delegate) {
    this.delegate = delegate;
  }

  public ResultSet(Object delegate) {
    this.delegate = (io.vertx.cassandra.ResultSet)delegate;
  }

  public io.vertx.cassandra.ResultSet getDelegate() {
    return delegate;
  }


  /**
   * @return 
   */
  public int remaining() { 
    int ret = delegate.remaining();
    return ret;
  }

  /**
   * @return 
   */
  public boolean hasMorePages() { 
    boolean ret = delegate.hasMorePages();
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.cassandra.ResultSet#fetchNextPage} but with a direct callback.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.cassandra.ResultSet> fetchNextPage() { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.cassandra.ResultSet> ret = rxFetchNextPage();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.cassandra.ResultSet#fetchNextPage} but with a direct callback.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.cassandra.ResultSet> rxFetchNextPage() { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.fetchNextPage(new Handler<AsyncResult<io.vertx.cassandra.ResultSet>>() {
      public void handle(AsyncResult<io.vertx.cassandra.ResultSet> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.cassandra.ResultSet.newInstance((io.vertx.cassandra.ResultSet)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * @return 
   */
  public boolean wasApplied() { 
    boolean ret = delegate.wasApplied();
    return ret;
  }

  /**
   * The method should <strong>not</strong> be used concurrently with others like {@link io.vertx.rxjava3.cassandra.ResultSet#fetchNextPage} or .
   * This may lead to unexpected result.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<com.datastax.oss.driver.api.core.cql.Row>> all() { 
    io.reactivex.rxjava3.core.Single<java.util.List<com.datastax.oss.driver.api.core.cql.Row>> ret = rxAll();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * The method should <strong>not</strong> be used concurrently with others like {@link io.vertx.rxjava3.cassandra.ResultSet#fetchNextPage} or .
   * This may lead to unexpected result.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<com.datastax.oss.driver.api.core.cql.Row>> rxAll() { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.all(handler);
    });
  }

  /**
   * @return 
   */
  public com.datastax.oss.driver.api.core.cql.ColumnDefinitions getColumnDefinitions() { 
    com.datastax.oss.driver.api.core.cql.ColumnDefinitions ret = delegate.getColumnDefinitions();
    return ret;
  }

  /**
   * @return 
   */
  public com.datastax.oss.driver.api.core.cql.ExecutionInfo getExecutionInfo() { 
    com.datastax.oss.driver.api.core.cql.ExecutionInfo ret = delegate.getExecutionInfo();
    return ret;
  }

  /**
   * @return 
   */
  public java.lang.Iterable<com.datastax.oss.driver.api.core.cql.Row> currentPage() { 
    java.lang.Iterable<com.datastax.oss.driver.api.core.cql.Row> ret = delegate.currentPage();
    return ret;
  }

  /**
   * @return 
   */
  public com.datastax.oss.driver.api.core.cql.Row one() { 
    com.datastax.oss.driver.api.core.cql.Row ret = delegate.one();
    return ret;
  }

  public static ResultSet newInstance(io.vertx.cassandra.ResultSet arg) {
    return arg != null ? new ResultSet(arg) : null;
  }

}
