/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.redis.client;

import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.redis.client.RedisOptions;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.redis.client.RedisConnection;
import io.vertx.rxjava3.redis.client.Request;
import io.vertx.rxjava3.redis.client.Response;
import java.util.List;
import java.util.stream.Collectors;

@RxGen(value=io.vertx.redis.client.Redis.class)
public class Redis {
    public static final TypeArg<Redis> __TYPE_ARG = new TypeArg(obj -> new Redis((io.vertx.redis.client.Redis)obj), Redis::getDelegate);
    private final io.vertx.redis.client.Redis delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Redis that = (Redis)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Redis(io.vertx.redis.client.Redis delegate) {
        this.delegate = delegate;
    }

    public Redis(Object delegate) {
        this.delegate = (io.vertx.redis.client.Redis)delegate;
    }

    public io.vertx.redis.client.Redis getDelegate() {
        return this.delegate;
    }

    public static Redis createClient(io.vertx.rxjava3.core.Vertx vertx) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static Redis createClient(io.vertx.rxjava3.core.Vertx vertx, String connectionString) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate(), (String)connectionString));
        return ret;
    }

    public static Redis createClient(io.vertx.rxjava3.core.Vertx vertx, RedisOptions options) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate(), (RedisOptions)options));
        return ret;
    }

    public Single<RedisConnection> connect() {
        Single ret = this.rxConnect();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<RedisConnection> rxConnect() {
        return AsyncResultSingle.toSingle(handler -> this.delegate.connect((Handler)new Handler<AsyncResult<io.vertx.redis.client.RedisConnection>>(){

            public void handle(AsyncResult<io.vertx.redis.client.RedisConnection> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)RedisConnection.newInstance((io.vertx.redis.client.RedisConnection)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public void close() {
        this.delegate.close();
    }

    public Maybe<Response> send(Request command) {
        Maybe ret = this.rxSend(command);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Response> rxSend(Request command) {
        return AsyncResultMaybe.toMaybe(onSend -> this.delegate.send(command.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    onSend.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    onSend.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Single<List<Response>> batch(List<Request> commands) {
        Single ret = this.rxBatch(commands);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<List<Response>> rxBatch(List<Request> commands) {
        return AsyncResultSingle.toSingle(onSend -> this.delegate.batch(commands.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), (Handler)new Handler<AsyncResult<List<io.vertx.redis.client.Response>>>(){

            public void handle(AsyncResult<List<io.vertx.redis.client.Response>> ar) {
                if (ar.succeeded()) {
                    onSend.handle((Object)Future.succeededFuture(((List)ar.result()).stream().map(elt -> Response.newInstance(elt)).collect(Collectors.toList())));
                } else {
                    onSend.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public static Redis newInstance(io.vertx.redis.client.Redis arg) {
        return arg != null ? new Redis(arg) : null;
    }
}

