/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.json.schema;

import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.common.ValidatorFactory;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.core.json.pointer.JsonPointer;
import io.vertx.rxjava3.json.schema.Schema;
import io.vertx.rxjava3.json.schema.SchemaRouter;
import java.util.function.Predicate;

@RxGen(value=io.vertx.json.schema.SchemaParser.class)
public class SchemaParser {
    public static final TypeArg<SchemaParser> __TYPE_ARG = new TypeArg(obj -> new SchemaParser((io.vertx.json.schema.SchemaParser)obj), SchemaParser::getDelegate);
    private final io.vertx.json.schema.SchemaParser delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaParser that = (SchemaParser)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public SchemaParser(io.vertx.json.schema.SchemaParser delegate) {
        this.delegate = delegate;
    }

    public SchemaParser(Object delegate) {
        this.delegate = (io.vertx.json.schema.SchemaParser)delegate;
    }

    public io.vertx.json.schema.SchemaParser getDelegate() {
        return this.delegate;
    }

    public Schema parse(JsonObject jsonSchema) {
        Schema ret = Schema.newInstance(this.delegate.parse(jsonSchema));
        return ret;
    }

    public Schema parse(JsonObject jsonSchema, JsonPointer schemaPointer) {
        Schema ret = Schema.newInstance(this.delegate.parse(jsonSchema, schemaPointer.getDelegate()));
        return ret;
    }

    public Schema parse(Boolean jsonSchema) {
        Schema ret = Schema.newInstance(this.delegate.parse(jsonSchema));
        return ret;
    }

    public Schema parse(Boolean jsonSchema, JsonPointer schemaPointer) {
        Schema ret = Schema.newInstance(this.delegate.parse(jsonSchema, schemaPointer.getDelegate()));
        return ret;
    }

    public Schema parseFromString(String unparsedJson) {
        Schema ret = Schema.newInstance(this.delegate.parseFromString(unparsedJson));
        return ret;
    }

    public Schema parseFromString(String unparsedJson, JsonPointer schemaPointer) {
        Schema ret = Schema.newInstance(this.delegate.parseFromString(unparsedJson, schemaPointer.getDelegate()));
        return ret;
    }

    public SchemaRouter getSchemaRouter() {
        SchemaRouter ret = SchemaRouter.newInstance(this.delegate.getSchemaRouter());
        return ret;
    }

    public static SchemaParser createOpenAPI3SchemaParser(SchemaRouter router) {
        SchemaParser ret = SchemaParser.newInstance(io.vertx.json.schema.SchemaParser.createOpenAPI3SchemaParser((io.vertx.json.schema.SchemaRouter)router.getDelegate()));
        return ret;
    }

    public static SchemaParser createDraft7SchemaParser(SchemaRouter router) {
        SchemaParser ret = SchemaParser.newInstance(io.vertx.json.schema.SchemaParser.createDraft7SchemaParser((io.vertx.json.schema.SchemaRouter)router.getDelegate()));
        return ret;
    }

    public static SchemaParser createDraft201909SchemaParser(SchemaRouter router) {
        SchemaParser ret = SchemaParser.newInstance(io.vertx.json.schema.SchemaParser.createDraft201909SchemaParser((io.vertx.json.schema.SchemaRouter)router.getDelegate()));
        return ret;
    }

    public SchemaParser withValidatorFactory(ValidatorFactory factory) {
        this.delegate.withValidatorFactory(factory);
        return this;
    }

    public SchemaParser withStringFormatValidator(String formatName, Predicate<String> predicate) {
        this.delegate.withStringFormatValidator(formatName, predicate);
        return this;
    }

    public static SchemaParser newInstance(io.vertx.json.schema.SchemaParser arg) {
        return arg != null ? new SchemaParser(arg) : null;
    }
}

