/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.impl;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.vertx.core.AsyncResult;
import io.vertx.core.streams.WriteStream;
import io.vertx.rxjava3.WriteStreamObserver;
import java.util.Objects;
import java.util.function.Function;

public class WriteStreamObserverImpl<R, T>
implements WriteStreamObserver<R> {
    private final WriteStream<T> writeStream;
    private final Function<R, T> mapping;
    private Disposable disposable;
    private boolean done;
    private Consumer<? super Throwable> observableErrorHandler;
    private Consumer<? super Throwable> writeStreamExceptionHandler;
    private Action writeStreamEndHandler;
    private Consumer<? super Throwable> writeStreamEndErrorHandler;

    public WriteStreamObserverImpl(WriteStream<T> writeStream, Function<R, T> mapping) {
        Objects.requireNonNull(writeStream, "writeStream");
        Objects.requireNonNull(mapping, "mapping");
        this.writeStream = writeStream;
        this.mapping = mapping;
    }

    public void onSubscribe(Disposable disposable) {
        Objects.requireNonNull(disposable, "disposable");
        if (!this.setDisposable(disposable)) {
            disposable.dispose();
            DisposableHelper.reportDisposableSet();
            return;
        }
        this.writeStream.exceptionHandler(t -> {
            Consumer<? super Throwable> c;
            if (!this.setDone()) {
                RxJavaPlugins.onError((Throwable)t);
                return;
            }
            this.getDisposable().dispose();
            WriteStreamObserverImpl writeStreamObserverImpl = this;
            synchronized (writeStreamObserverImpl) {
                c = this.writeStreamExceptionHandler;
            }
            if (c != null) {
                try {
                    c.accept(t);
                }
                catch (Throwable e) {
                    RxJavaPlugins.onError((Throwable)t);
                }
            }
        });
    }

    public void onNext(R r) {
        if (this.isDone()) {
            return;
        }
        if (r == null) {
            NullPointerException throwable = new NullPointerException("onNext called with null");
            try {
                this.getDisposable().dispose();
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal((Throwable)t);
                throwable = new CompositeException(new Throwable[]{throwable, t});
            }
            this.onError(throwable);
            return;
        }
        try {
            this.writeStream.write(this.mapping.apply(r));
        }
        catch (Throwable t) {
            Throwable throwable;
            Exceptions.throwIfFatal((Throwable)t);
            try {
                this.getDisposable().dispose();
                throwable = t;
            }
            catch (Throwable t1) {
                Exceptions.throwIfFatal((Throwable)t1);
                throwable = new CompositeException(new Throwable[]{t, t1});
            }
            this.onError(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable t) {
        Consumer<? super Throwable> c;
        if (!this.setDone()) {
            RxJavaPlugins.onError((Throwable)t);
            return;
        }
        Objects.requireNonNull(t, "onError called with null");
        WriteStreamObserverImpl writeStreamObserverImpl = this;
        synchronized (writeStreamObserverImpl) {
            c = this.observableErrorHandler;
        }
        try {
            if (c != null) {
                c.accept((Object)t);
            }
        }
        catch (Throwable t1) {
            Exceptions.throwIfFatal((Throwable)t1);
            RxJavaPlugins.onError((Throwable)t1);
        }
    }

    public void onComplete() {
        if (!this.setDone()) {
            return;
        }
        try {
            this.writeStream.end(this::writeStreamEnd);
        }
        catch (Throwable t) {
            Exceptions.throwIfFatal((Throwable)t);
            RxJavaPlugins.onError((Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStreamEnd(AsyncResult<Void> result) {
        block11: {
            try {
                Consumer<? super Throwable> c;
                if (result.succeeded()) {
                    Action a;
                    WriteStreamObserverImpl writeStreamObserverImpl = this;
                    synchronized (writeStreamObserverImpl) {
                        a = this.writeStreamEndHandler;
                    }
                    if (a != null) {
                        a.run();
                    }
                    break block11;
                }
                WriteStreamObserverImpl writeStreamObserverImpl = this;
                synchronized (writeStreamObserverImpl) {
                    c = this.writeStreamEndErrorHandler;
                }
                if (c != null) {
                    c.accept((Object)result.cause());
                }
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal((Throwable)t);
                RxJavaPlugins.onError((Throwable)t);
            }
        }
    }

    private synchronized Disposable getDisposable() {
        return this.disposable;
    }

    private synchronized boolean setDisposable(Disposable disposable) {
        if (this.disposable == null) {
            this.disposable = disposable;
            return true;
        }
        return false;
    }

    private synchronized boolean isDone() {
        return this.done;
    }

    private synchronized boolean setDone() {
        return this.done ? false : (this.done = true);
    }

    @Override
    public synchronized WriteStreamObserver<R> onError(Consumer<? super Throwable> handler) {
        this.observableErrorHandler = handler;
        return this;
    }

    @Override
    public synchronized WriteStreamObserver<R> onWriteStreamError(Consumer<? super Throwable> handler) {
        this.writeStreamExceptionHandler = handler;
        return this;
    }

    @Override
    public synchronized WriteStreamObserver<R> onWriteStreamEnd(Action handler) {
        this.writeStreamEndHandler = handler;
        return this;
    }

    @Override
    public synchronized WriteStreamObserver<R> onWriteStreamEndError(Consumer<? super Throwable> handler) {
        this.writeStreamEndErrorHandler = handler;
        return this;
    }
}

