/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class CompletableHelper {
    public static Completable toCompletable(Consumer<Handler<AsyncResult<Void>>> handler) {
        return AsyncResultCompletable.toCompletable(handler);
    }

    public static <T> CompletableObserver toObserver(final Handler<AsyncResult<T>> handler) {
        final AtomicBoolean completed = new AtomicBoolean();
        return new CompletableObserver(){

            public void onSubscribe(@NonNull Disposable d) {
            }

            public void onComplete() {
                if (completed.compareAndSet(false, true)) {
                    handler.handle((Object)Future.succeededFuture());
                }
            }

            public void onSuccess() {
                if (completed.compareAndSet(false, true)) {
                    handler.handle((Object)Future.succeededFuture());
                }
            }

            public void onError(Throwable error) {
                if (completed.compareAndSet(false, true)) {
                    handler.handle((Object)Future.failedFuture((Throwable)error));
                }
            }
        };
    }

    public static <T> Future<Void> toFuture(Completable maybe) {
        Promise promise = Promise.promise();
        maybe.subscribe(() -> ((Promise)promise).complete(), arg_0 -> ((Promise)promise).fail(arg_0));
        return promise.future();
    }
}

